/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypographyDetector
extends ResourceXmlDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(TypographyDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue DASHES = Issue.create("TypographyDashes", "Hyphen can be replaced with dash", "The \"n dash\" (\u2013, &#8211;) and the \"m dash\" (\u2014, &#8212;) characters are used for ranges (n dash) and breaks (m dash). Using these instead of plain hyphens can make text easier to read and your application will look more polished.", Category.TYPOGRAPHY, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://en.wikipedia.org/wiki/Dash");
    public static final Issue QUOTES = Issue.create("TypographyQuotes", "Straight quotes can be replaced with curvy quotes", "Straight single quotes and double quotes, when used as a pair, can be replaced by \"curvy quotes\" (or directional quotes). This can make the text more readable.\n\nNote that you should never use grave accents and apostrophes to quote, `like this'.\n\n(Also note that you should not use curvy quotes for code fragments.)", Category.TYPOGRAPHY, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://en.wikipedia.org/wiki/Quotation_mark").setEnabledByDefault(false);
    public static final Issue FRACTIONS = Issue.create("TypographyFractions", "Fraction string can be replaced with fraction character", "You can replace certain strings, such as 1/2, and 1/4, with dedicated characters for these, such as \u00bd (&#189;) and \u00bc (&#188;). This can help make the text more readable.", Category.TYPOGRAPHY, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://en.wikipedia.org/wiki/Number_Forms");
    public static final Issue ELLIPSIS = Issue.create("TypographyEllipsis", "Ellipsis string can be replaced with ellipsis character", "You can replace the string \"...\" with a dedicated ellipsis character, ellipsis character (\u2026, &#8230;). This can help make the text more readable.", Category.TYPOGRAPHY, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://en.wikipedia.org/wiki/Ellipsis");
    public static final Issue OTHER = Issue.create("TypographyOther", "Other typographical problems", "This check looks for miscellaneous typographical problems and offers replacement sequences that will make the text easier to read and your application more polished.", Category.TYPOGRAPHY, 3, Severity.WARNING, IMPLEMENTATION);
    private static final String GRAVE_QUOTE_MESSAGE = "Avoid quoting with grave accents; use apostrophes or better yet directional quotes instead";
    private static final String ELLIPSIS_MESSAGE = "Replace \"...\" with ellipsis character (\u2026, &#8230;) ?";
    private static final String EN_DASH_MESSAGE = "Replace \"-\" with an \"en dash\" character (\u2013, &#8211;) ?";
    private static final String EM_DASH_MESSAGE = "Replace \"--\" with an \"em dash\" character (\u2014, &#8212;) ?";
    private static final String TYPOGRAPHIC_APOSTROPHE_MESSAGE = "Replace apostrophe (') with typographic apostrophe (\u2019, &#8217;) ?";
    private static final String SINGLE_QUOTE_MESSAGE = "Replace straight quotes ('') with directional quotes (\u2018\u2019, &#8216; and &#8217;) ?";
    private static final String DBL_QUOTES_MESSAGE = "Replace straight quotes (\") with directional quotes (\u201c\u201d, &#8220; and &#8221;) ?";
    private static final String COPYRIGHT_MESSAGE = "Replace (c) with copyright symbol \u00a9 (&#169;) ?";
    static final Pattern HYPHEN_RANGE_PATTERN = Pattern.compile(".*(\\d+\\s*)-(\\s*\\d+).*");
    static final Pattern GRAVE_QUOTATION = Pattern.compile("(^[^`]*`[^'`]+'[^']*$)|(^[^`]*``[^'`]+''[^']*$)");
    static final Pattern FRACTION_PATTERN = Pattern.compile(".*\\b([13])\\s*/\\s*([234])\\b.*");
    static final Pattern SINGLE_QUOTE = Pattern.compile(".*\\W*'[^']+'(\\W.*)?");
    private static final String FRACTION_MESSAGE = "Use fraction character %1$c (%2$s) instead of %3$s ?";
    private static final String FRACTION_MESSAGE_PATTERN = "Use fraction character (.+) \\((.+)\\) instead of (.+) \\?";
    private boolean mCheckDashes;
    private boolean mCheckQuotes;
    private boolean mCheckFractions;
    private boolean mCheckEllipsis;
    private boolean mCheckMisc;

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("string", "string-array");
    }

    @Override
    public void beforeCheckProject(@NonNull Context context) {
        this.mCheckDashes = context.isEnabled(DASHES);
        this.mCheckQuotes = context.isEnabled(QUOTES);
        this.mCheckFractions = context.isEnabled(FRACTIONS);
        this.mCheckEllipsis = context.isEnabled(ELLIPSIS);
        this.mCheckMisc = context.isEnabled(OTHER);
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        NodeList childNodes = element.getChildNodes();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 3) {
                String text = child.getNodeValue();
                this.checkText(context, element, child, text);
                continue;
            }
            if (child.getNodeType() != 1 || !child.getParentNode().getNodeName().equals("string-array")) continue;
            NodeList items = child.getChildNodes();
            int m = items.getLength();
            for (int j = 0; j < m; ++j) {
                Node item = items.item(j);
                if (item.getNodeType() != 3) continue;
                String text = item.getNodeValue();
                this.checkText(context, child, item, text);
            }
        }
    }

    private void checkText(XmlContext context, Node element, Node textNode, String text) {
        Matcher matcher;
        int hyphen;
        int ellipsis;
        if (this.mCheckEllipsis && (ellipsis = text.indexOf("...")) != -1 && !text.startsWith(".", ellipsis + 3)) {
            context.report(ELLIPSIS, element, context.getLocation(textNode), ELLIPSIS_MESSAGE);
        }
        if (this.mCheckDashes && (hyphen = text.indexOf(45)) != -1) {
            int emdash;
            Matcher matcher2 = HYPHEN_RANGE_PATTERN.matcher(text);
            if (matcher2.matches()) {
                boolean isNegativeNumber;
                boolean bl = isNegativeNumber = !Character.isWhitespace(matcher2.group(2).charAt(0)) && Character.isWhitespace(matcher2.group(1).charAt(matcher2.group(1).length() - 1));
                if (!isNegativeNumber && !TypographyDetector.isAnalyticsTrackingId((Element)element)) {
                    context.report(DASHES, element, context.getLocation(textNode), EN_DASH_MESSAGE);
                }
            }
            if ((emdash = text.indexOf("--")) > 1 && !text.startsWith("-", emdash + 2)) {
                context.report(DASHES, element, context.getLocation(textNode), EM_DASH_MESSAGE);
            }
        }
        if (this.mCheckQuotes) {
            int quoteEnd;
            int quoteStart = text.indexOf(39);
            if (quoteStart != -1) {
                int quoteEnd2 = text.indexOf(39, quoteStart + 1);
                if (quoteEnd2 != -1 && quoteEnd2 > quoteStart + 1 && (quoteEnd2 < text.length() - 1 || quoteStart > 0) && SINGLE_QUOTE.matcher(text).matches()) {
                    context.report(QUOTES, element, context.getLocation(textNode), SINGLE_QUOTE_MESSAGE);
                    return;
                }
                if (quoteEnd2 == -1 && quoteStart > 0 && Character.isLetterOrDigit(text.charAt(quoteStart - 1))) {
                    context.report(QUOTES, element, context.getLocation(textNode), TYPOGRAPHIC_APOSTROPHE_MESSAGE);
                    return;
                }
            }
            if ((quoteStart = text.indexOf(34)) != -1 && (quoteEnd = text.indexOf(34, quoteStart + 1)) != -1 && quoteEnd > quoteStart + 1 && (quoteEnd < text.length() - 1 || quoteStart > 0)) {
                context.report(QUOTES, element, context.getLocation(textNode), DBL_QUOTES_MESSAGE);
                return;
            }
            if (text.indexOf(96) != -1 && GRAVE_QUOTATION.matcher(text).matches()) {
                context.report(QUOTES, element, context.getLocation(textNode), GRAVE_QUOTE_MESSAGE);
                return;
            }
        }
        if (this.mCheckFractions && text.indexOf(47) != -1 && (matcher = FRACTION_PATTERN.matcher(text)).matches()) {
            String top = matcher.group(1);
            String bottom = matcher.group(2);
            if (top.equals("1") && bottom.equals("2")) {
                context.report(FRACTIONS, element, context.getLocation(textNode), String.format(FRACTION_MESSAGE, Character.valueOf('\u00bd'), "&#189;", "1/2"));
            } else if (top.equals("1") && bottom.equals("4")) {
                context.report(FRACTIONS, element, context.getLocation(textNode), String.format(FRACTION_MESSAGE, Character.valueOf('\u00bc'), "&#188;", "1/4"));
            } else if (top.equals("3") && bottom.equals("4")) {
                context.report(FRACTIONS, element, context.getLocation(textNode), String.format(FRACTION_MESSAGE, Character.valueOf('\u00be'), "&#190;", "3/4"));
            } else if (top.equals("1") && bottom.equals("3")) {
                context.report(FRACTIONS, element, context.getLocation(textNode), String.format(FRACTION_MESSAGE, Character.valueOf('\u2153'), "&#8531;", "1/3"));
            } else if (top.equals("2") && bottom.equals("3")) {
                context.report(FRACTIONS, element, context.getLocation(textNode), String.format(FRACTION_MESSAGE, Character.valueOf('\u2154'), "&#8532;", "2/3"));
            }
        }
        if (this.mCheckMisc && text.indexOf(40) != -1 && (text.contains("(c)") || text.contains("(C)"))) {
            context.report(OTHER, element, context.getLocation(textNode), COPYRIGHT_MESSAGE);
        }
    }

    private static boolean isAnalyticsTrackingId(Element element) {
        String name = element.getAttribute("name");
        return "ga_trackingId".equals(name);
    }

    public static List<ReplaceEdit> getEdits(String issueId, String message, Node textNode) {
        return TypographyDetector.getEdits(issueId, message, textNode.getNodeValue());
    }

    public static List<ReplaceEdit> getEdits(String issueId, String message, String text) {
        ArrayList<ReplaceEdit> edits = new ArrayList<ReplaceEdit>();
        if (message.equals(ELLIPSIS_MESSAGE)) {
            int offset = text.indexOf("...");
            if (offset != -1) {
                edits.add(new ReplaceEdit(offset, 3, "\u2026"));
            }
        } else if (message.equals(EN_DASH_MESSAGE)) {
            int offset = text.indexOf(45);
            if (offset != -1) {
                edits.add(new ReplaceEdit(offset, 1, "\u2013"));
            }
        } else if (message.equals(EM_DASH_MESSAGE)) {
            int offset = text.indexOf("--");
            if (offset != -1) {
                edits.add(new ReplaceEdit(offset, 2, "\u2014"));
            }
        } else if (message.equals(TYPOGRAPHIC_APOSTROPHE_MESSAGE)) {
            int offset = text.indexOf(39);
            if (offset != -1) {
                edits.add(new ReplaceEdit(offset, 1, "\u2019"));
            }
        } else if (message.equals(COPYRIGHT_MESSAGE)) {
            int offset = text.indexOf("(c)");
            if (offset == -1) {
                offset = text.indexOf("(C)");
            }
            if (offset != -1) {
                edits.add(new ReplaceEdit(offset, 3, "\u00a9"));
            }
        } else if (message.equals(SINGLE_QUOTE_MESSAGE)) {
            int endOffset;
            int offset = text.indexOf(39);
            if (offset != -1 && (endOffset = text.indexOf(39, offset + 1)) != -1) {
                edits.add(new ReplaceEdit(offset, 1, "\u2018"));
                edits.add(new ReplaceEdit(endOffset, 1, "\u2019"));
            }
        } else if (message.equals(DBL_QUOTES_MESSAGE)) {
            int endOffset;
            int offset = text.indexOf(34);
            if (offset != -1 && (endOffset = text.indexOf(34, offset + 1)) != -1) {
                edits.add(new ReplaceEdit(offset, 1, "\u201c"));
                edits.add(new ReplaceEdit(endOffset, 1, "\u201d"));
            }
        } else if (message.equals(GRAVE_QUOTE_MESSAGE)) {
            int endOffset;
            int offset = text.indexOf(96);
            if (offset != -1 && (endOffset = text.indexOf(39, offset + 1)) != -1) {
                edits.add(new ReplaceEdit(offset, 1, "\u2018"));
                edits.add(new ReplaceEdit(endOffset, 1, "\u2019"));
            }
        } else {
            String replace;
            int offset;
            Matcher matcher = Pattern.compile(FRACTION_MESSAGE_PATTERN).matcher(message);
            if (matcher.find() && (offset = text.indexOf(replace = matcher.group(3))) != -1) {
                String replaceWith = matcher.group(2);
                edits.add(new ReplaceEdit(offset, replace.length(), replaceWith));
            }
        }
        return edits;
    }

    public static class ReplaceEdit {
        public final int offset;
        public final int length;
        public final String replaceWith;

        public ReplaceEdit(int offset, int length, String replaceWith) {
            this.offset = offset;
            this.length = length;
            this.replaceWith = replaceWith;
        }
    }
}

