/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.ResultConsumer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AsyncUtil {
    private static final AsyncFuture<Boolean> TRUE = AsyncUtil.createConst(true);
    private static final AsyncFuture<Boolean> FALSE = AsyncUtil.createConst(false);

    public static <V> V get(@NotNull Future<V> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/concurrency/AsyncUtil", "get"));
        }
        try {
            return result.get();
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new Error(cause);
        }
    }

    private static AsyncFuture<Boolean> createConst(final boolean result) {
        return new AsyncFuture<Boolean>(){

            @Override
            public void addConsumer(@NotNull Executor executor, @NotNull ResultConsumer<Boolean> consumer) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/concurrency/AsyncUtil$1", "addConsumer"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/concurrency/AsyncUtil$1", "addConsumer"));
                }
                consumer.onSuccess(result);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Boolean get() {
                return result;
            }

            @Override
            public Boolean get(long timeout, @NotNull TimeUnit timeUnit) {
                if (timeUnit == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/concurrency/AsyncUtil$1", "get"));
                }
                return result;
            }
        };
    }

    @NotNull
    public static AsyncFuture<Boolean> wrapBoolean(boolean result) {
        AsyncFuture<Boolean> asyncFuture = result ? TRUE : FALSE;
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/AsyncUtil", "wrapBoolean"));
        }
        return asyncFuture;
    }
}

