/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValue;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PatchReader {
    @NonNls
    public static final String NO_NEWLINE_SIGNATURE = "\\ No newline at end of file";
    private final List<String> myLines;
    private final PatchContentParser myPatchContentParser;
    private final AdditionalInfoParser myAdditionalInfoParser;
    private List<TextFilePatch> myPatches;
    @NonNls
    private static final String CONTEXT_HUNK_PREFIX = "***************";
    @NonNls
    private static final String CONTEXT_FILE_PREFIX = "*** ";
    @NonNls
    private static final Pattern ourUnifiedHunkStartPattern = Pattern.compile("@@ -(\\d+)(,(\\d+))? \\+(\\d+)(,(\\d+))? @@.*");
    @NonNls
    private static final Pattern ourContextBeforeHunkStartPattern = Pattern.compile("\\*\\*\\* (\\d+),(\\d+) \\*\\*\\*\\*");
    @NonNls
    private static final Pattern ourContextAfterHunkStartPattern = Pattern.compile("--- (\\d+),(\\d+) ----");

    public PatchReader(CharSequence patchContent) {
        this(patchContent, true);
    }

    public PatchReader(CharSequence patchContent, boolean parseHunks) {
        this.myLines = LineTokenizer.tokenizeIntoList((CharSequence)patchContent, (boolean)false);
        this.myAdditionalInfoParser = new AdditionalInfoParser(!parseHunks);
        this.myPatchContentParser = new PatchContentParser(parseHunks);
    }

    public List<TextFilePatch> readAllPatches() throws PatchSyntaxException {
        this.parseAllPatches();
        return this.myPatches;
    }

    @Nullable
    public CharSequence getBaseRevision(Project project, String relativeFilePath) {
        BaseRevisionTextPatchEP baseRevisionTextPatchEP;
        Map<String, CharSequence> inner;
        Map<String, Map<String, CharSequence>> map = this.myAdditionalInfoParser.getResultMap();
        if (!map.isEmpty() && (inner = map.get(relativeFilePath)) != null && (baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)Extensions.findExtension(PatchEP.EP_NAME, (AreaInstance)project, BaseRevisionTextPatchEP.class)) != null) {
            return inner.get(baseRevisionTextPatchEP.getName());
        }
        return null;
    }

    public List<TextFilePatch> getPatches() {
        return this.myPatches;
    }

    public void parseAllPatches() throws PatchSyntaxException {
        ListIterator<String> iterator = this.myLines.listIterator();
        if (!iterator.hasNext()) {
            this.myPatches = Collections.emptyList();
            return;
        }
        boolean containsAdditional = false;
        while (iterator.hasNext()) {
            String next = iterator.next();
            boolean containsAdditionalNow = this.myAdditionalInfoParser.testIsStart(next);
            if (containsAdditionalNow && containsAdditional) {
                this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator.previousIndex(), "Contains additional information without patch itself"));
            }
            if (containsAdditionalNow) {
                containsAdditional = containsAdditionalNow;
                this.myAdditionalInfoParser.parse(next, iterator);
                if (!iterator.hasNext()) {
                    this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator.previousIndex(), "Contains additional information without patch itself"));
                    break;
                }
                next = iterator.next();
            }
            if (!this.myPatchContentParser.testIsStart(next)) continue;
            this.myPatchContentParser.parse(next, iterator);
            if (containsAdditional) {
                String lastName = this.myPatchContentParser.getLastName();
                if (lastName == null) {
                    this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator.previousIndex(), "Contains additional information without patch itself"));
                } else {
                    this.myAdditionalInfoParser.copyToResult(lastName);
                }
            }
            containsAdditional = false;
        }
        this.myPatches = this.myPatchContentParser.getResult();
    }

    public TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> getAdditionalInfo(Set<String> filterByPaths) {
        TransparentlyFailedValue<Map<String, Map<String, CharSequence>>, PatchSyntaxException> value = new TransparentlyFailedValue<Map<String, Map<String, CharSequence>>, PatchSyntaxException>();
        Map<String, Map<String, CharSequence>> map = this.myAdditionalInfoParser.getResultMap();
        HashMap<String, Map<String, CharSequence>> newMap = new HashMap<String, Map<String, CharSequence>>();
        for (Map.Entry<String, Map<String, CharSequence>> entry : map.entrySet()) {
            Map<String, CharSequence> innerMap = entry.getValue();
            if (filterByPaths != null && !filterByPaths.contains(entry.getKey())) continue;
            newMap.put(entry.getKey(), innerMap);
        }
        value.set(newMap);
        PatchSyntaxException e = this.myAdditionalInfoParser.getSyntaxException();
        if (e != null) {
            value.fail(e);
        }
        return value;
    }

    private static interface Parser {
        public boolean testIsStart(String var1);

        public void parse(String var1, ListIterator<String> var2) throws PatchSyntaxException;
    }

    private static class PatchContentParser
    implements Parser {
        private final boolean myParseHunks;
        private DiffFormat myDiffFormat = null;
        private final List<TextFilePatch> myPatches;
        private boolean myDiffCommandLike;
        private boolean myIndexLike;

        private PatchContentParser(boolean parseHunks) {
            this.myParseHunks = parseHunks;
            this.myPatches = new SmartList();
        }

        @Override
        public boolean testIsStart(String start) {
            if (start.startsWith("diff")) {
                this.myDiffCommandLike = true;
                return false;
            }
            if (start.startsWith("index")) {
                this.myIndexLike = true;
                return false;
            }
            if (start.startsWith("--- ") && (this.myDiffFormat == null || this.myDiffFormat == DiffFormat.UNIFIED)) {
                this.myDiffFormat = DiffFormat.UNIFIED;
                return true;
            }
            if (start.startsWith(PatchReader.CONTEXT_FILE_PREFIX) && (this.myDiffFormat == null || this.myDiffFormat == DiffFormat.CONTEXT)) {
                this.myDiffFormat = DiffFormat.CONTEXT;
                return true;
            }
            return false;
        }

        @Override
        public void parse(String start, ListIterator<String> iterator) throws PatchSyntaxException {
            TextFilePatch patch = this.readPatch(start, iterator);
            if (patch != null) {
                this.myPatches.add(patch);
            }
            this.myDiffCommandLike = false;
            this.myIndexLike = false;
        }

        public List<TextFilePatch> getResult() throws PatchSyntaxException {
            return this.myPatches;
        }

        private TextFilePatch readPatch(String curLine, ListIterator<String> iterator) throws PatchSyntaxException {
            PatchHunk hunk;
            String secondNamePrefix;
            TextFilePatch curPatch = new TextFilePatch(null);
            PatchContentParser.extractFileName(curLine, curPatch, true, this.myDiffCommandLike && this.myIndexLike);
            if (!iterator.hasNext()) {
                throw new PatchSyntaxException(iterator.previousIndex(), "Second file name expected");
            }
            curLine = iterator.next();
            String string = secondNamePrefix = this.myDiffFormat == DiffFormat.UNIFIED ? "+++ " : "--- ";
            if (!curLine.startsWith(secondNamePrefix)) {
                throw new PatchSyntaxException(iterator.previousIndex(), "Second file name expected");
            }
            PatchContentParser.extractFileName(curLine, curPatch, false, this.myDiffCommandLike && this.myIndexLike);
            while (this.myParseHunks && iterator.hasNext() && (hunk = this.myDiffFormat == DiffFormat.UNIFIED ? this.readNextHunkUnified(iterator) : this.readNextHunkContext(iterator)) != null) {
                curPatch.addHunk(hunk);
            }
            if (curPatch.getBeforeName() == null) {
                curPatch.setBeforeName(curPatch.getAfterName());
            }
            if (curPatch.getAfterName() == null) {
                curPatch.setAfterName(curPatch.getBeforeName());
            }
            return curPatch;
        }

        @Nullable
        private PatchHunk readNextHunkUnified(ListIterator<String> iterator) throws PatchSyntaxException {
            String curLine = null;
            int numIncrements = 0;
            while (iterator.hasNext()) {
                curLine = iterator.next();
                ++numIncrements;
                if (curLine.startsWith("--- ")) {
                    for (int i = 0; i < numIncrements; ++i) {
                        iterator.previous();
                    }
                    return null;
                }
                if (!curLine.startsWith("@@ ")) continue;
            }
            if (!iterator.hasNext()) {
                return null;
            }
            Matcher m = ourUnifiedHunkStartPattern.matcher(curLine);
            if (!m.matches()) {
                throw new PatchSyntaxException(iterator.previousIndex(), "Unknown hunk start syntax");
            }
            int startLineBefore = Integer.parseInt(m.group(1));
            String linesBeforeText = m.group(3);
            int linesBefore = linesBeforeText == null ? 1 : Integer.parseInt(linesBeforeText);
            int startLineAfter = Integer.parseInt(m.group(4));
            String linesAfterText = m.group(6);
            int linesAfter = linesAfterText == null ? 1 : Integer.parseInt(linesAfterText);
            PatchHunk hunk = new PatchHunk(startLineBefore - 1, startLineBefore + linesBefore - 1, startLineAfter - 1, startLineAfter + linesAfter - 1);
            PatchLine lastLine = null;
            int before = 0;
            int after = 0;
            while (iterator.hasNext()) {
                String hunkCurLine = iterator.next();
                if (lastLine != null && hunkCurLine.startsWith(PatchReader.NO_NEWLINE_SIGNATURE)) {
                    lastLine.setSuppressNewLine(true);
                    continue;
                }
                lastLine = PatchContentParser.parsePatchLine(hunkCurLine, 1, before < linesBefore || after < linesAfter);
                if (lastLine == null) {
                    iterator.previous();
                    break;
                }
                switch (lastLine.getType()) {
                    case CONTEXT: {
                        ++before;
                        ++after;
                        break;
                    }
                    case ADD: {
                        ++after;
                        break;
                    }
                    case REMOVE: {
                        ++before;
                    }
                }
                hunk.addLine(lastLine);
            }
            return hunk;
        }

        @Nullable
        public String getLastName() {
            if (this.myPatches.isEmpty()) {
                return null;
            }
            TextFilePatch patch = this.myPatches.get(this.myPatches.size() - 1);
            return patch.getBeforeName() == null ? patch.getAfterName() : patch.getBeforeName();
        }

        @Nullable
        private static PatchLine parsePatchLine(String line, int prefixLength) {
            return PatchContentParser.parsePatchLine(line, prefixLength, true);
        }

        @Nullable
        private static PatchLine parsePatchLine(String line, int prefixLength, boolean expectMeaningfulLines) {
            PatchLine.Type type;
            if (line.startsWith("+") && expectMeaningfulLines) {
                type = PatchLine.Type.ADD;
            } else if (line.startsWith("-") && expectMeaningfulLines) {
                type = PatchLine.Type.REMOVE;
            } else if (line.startsWith(" ") || line.length() == 0) {
                type = PatchLine.Type.CONTEXT;
            } else {
                return null;
            }
            String lineText = line.length() < prefixLength ? "" : line.substring(prefixLength);
            return new PatchLine(type, lineText);
        }

        @Nullable
        private PatchHunk readNextHunkContext(ListIterator<String> iterator) throws PatchSyntaxException {
            while (iterator.hasNext()) {
                String curLine = iterator.next();
                if (curLine.startsWith(PatchReader.CONTEXT_FILE_PREFIX)) {
                    iterator.previous();
                    return null;
                }
                if (!curLine.startsWith(PatchReader.CONTEXT_HUNK_PREFIX)) continue;
                break;
            }
            if (!iterator.hasNext()) {
                return null;
            }
            Matcher beforeMatcher = ourContextBeforeHunkStartPattern.matcher(iterator.next());
            if (!beforeMatcher.matches()) {
                throw new PatchSyntaxException(iterator.previousIndex(), "Unknown before hunk start syntax");
            }
            List<String> beforeLines = this.readContextDiffLines(iterator);
            if (!iterator.hasNext()) {
                throw new PatchSyntaxException(iterator.previousIndex(), "Missing after hunk");
            }
            Matcher afterMatcher = ourContextAfterHunkStartPattern.matcher(iterator.next());
            if (!afterMatcher.matches()) {
                throw new PatchSyntaxException(iterator.previousIndex(), "Unknown after hunk start syntax");
            }
            List<String> afterLines = this.readContextDiffLines(iterator);
            int startLineBefore = Integer.parseInt(beforeMatcher.group(1));
            int endLineBefore = Integer.parseInt(beforeMatcher.group(2));
            int startLineAfter = Integer.parseInt(afterMatcher.group(1));
            int endLineAfter = Integer.parseInt(afterMatcher.group(2));
            PatchHunk hunk = new PatchHunk(startLineBefore - 1, endLineBefore - 1, startLineAfter - 1, endLineAfter - 1);
            int beforeLineIndex = 0;
            int afterLineIndex = 0;
            PatchLine lastBeforePatchLine = null;
            PatchLine lastAfterPatchLine = null;
            if (beforeLines.size() == 0) {
                for (String line : afterLines) {
                    hunk.addLine(PatchContentParser.parsePatchLine(line, 2));
                }
            } else if (afterLines.size() == 0) {
                for (String line : beforeLines) {
                    hunk.addLine(PatchContentParser.parsePatchLine(line, 2));
                }
            } else {
                while (beforeLineIndex < beforeLines.size() || afterLineIndex < afterLines.size()) {
                    String afterLine;
                    String beforeLine = beforeLineIndex >= beforeLines.size() ? null : beforeLines.get(beforeLineIndex);
                    String string = afterLine = afterLineIndex >= afterLines.size() ? null : afterLines.get(afterLineIndex);
                    if (PatchContentParser.startsWith(beforeLine, PatchReader.NO_NEWLINE_SIGNATURE) && lastBeforePatchLine != null) {
                        lastBeforePatchLine.setSuppressNewLine(true);
                        ++beforeLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(afterLine, PatchReader.NO_NEWLINE_SIGNATURE) && lastAfterPatchLine != null) {
                        lastAfterPatchLine.setSuppressNewLine(true);
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, " ") && (PatchContentParser.startsWith(afterLine, " ") || afterLine == null)) {
                        PatchContentParser.addContextDiffLine(hunk, beforeLine, PatchLine.Type.CONTEXT);
                        ++beforeLineIndex;
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, "-")) {
                        lastBeforePatchLine = PatchContentParser.addContextDiffLine(hunk, beforeLine, PatchLine.Type.REMOVE);
                        ++beforeLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(afterLine, "+")) {
                        lastAfterPatchLine = PatchContentParser.addContextDiffLine(hunk, afterLine, PatchLine.Type.ADD);
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, "!") && PatchContentParser.startsWith(afterLine, "!")) {
                        while (beforeLineIndex < beforeLines.size() && beforeLines.get(beforeLineIndex).startsWith("! ")) {
                            lastBeforePatchLine = PatchContentParser.addContextDiffLine(hunk, beforeLines.get(beforeLineIndex), PatchLine.Type.REMOVE);
                            ++beforeLineIndex;
                        }
                        while (afterLineIndex < afterLines.size() && afterLines.get(afterLineIndex).startsWith("! ")) {
                            lastAfterPatchLine = PatchContentParser.addContextDiffLine(hunk, afterLines.get(afterLineIndex), PatchLine.Type.ADD);
                            ++afterLineIndex;
                        }
                        continue;
                    }
                    throw new PatchSyntaxException(-1, "Unknown line prefix");
                }
            }
            return hunk;
        }

        private static boolean startsWith(@Nullable String line, String prefix) {
            return line != null && line.startsWith(prefix);
        }

        private static PatchLine addContextDiffLine(PatchHunk hunk, String line, PatchLine.Type type) {
            PatchLine patchLine = new PatchLine(type, line.length() < 2 ? "" : line.substring(2));
            hunk.addLine(patchLine);
            return patchLine;
        }

        private List<String> readContextDiffLines(ListIterator<String> iterator) {
            ArrayList<String> result = new ArrayList<String>();
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (!(line.startsWith(" ") || line.startsWith("+ ") || line.startsWith("- ") || line.startsWith("! ") || line.startsWith(PatchReader.NO_NEWLINE_SIGNATURE))) {
                    iterator.previous();
                    break;
                }
                result.add(line);
            }
            return result;
        }

        private static void extractFileName(String curLine, FilePatch patch, boolean before, boolean gitPatch) {
            String fileName = curLine.substring(4);
            int pos = fileName.indexOf(9);
            if (pos < 0) {
                pos = fileName.indexOf(32);
            }
            if (pos >= 0) {
                String versionId = fileName.substring(pos).trim();
                fileName = fileName.substring(0, pos);
                if (versionId.length() > 0) {
                    if (before) {
                        patch.setBeforeVersionId(versionId);
                    } else {
                        patch.setAfterVersionId(versionId);
                    }
                }
            }
            if ("/dev/null".equals(fileName)) {
                return;
            }
            if (before) {
                if (gitPatch && fileName.startsWith("a/")) {
                    fileName = fileName.substring(2);
                }
                patch.setBeforeName(fileName);
            } else {
                if (gitPatch && fileName.startsWith("b/")) {
                    fileName = fileName.substring(2);
                }
                patch.setAfterName(fileName);
            }
        }
    }

    private static class AdditionalInfoParser
    implements Parser {
        private final Map<String, Map<String, CharSequence>> myResultMap;
        private final boolean myIgnoreMode;
        private Map<String, CharSequence> myAddMap;
        private PatchSyntaxException mySyntaxException;

        private AdditionalInfoParser(boolean ignore) {
            this.myIgnoreMode = ignore;
            this.myAddMap = new HashMap<String, CharSequence>();
            this.myResultMap = new HashMap<String, Map<String, CharSequence>>();
        }

        public PatchSyntaxException getSyntaxException() {
            return this.mySyntaxException;
        }

        public Map<String, Map<String, CharSequence>> getResultMap() {
            return this.myResultMap;
        }

        public void copyToResult(String filePath) {
            if (this.myAddMap != null && !this.myAddMap.isEmpty()) {
                this.myResultMap.put(filePath, this.myAddMap);
                this.myAddMap = new HashMap<String, CharSequence>();
            }
        }

        @Override
        public boolean testIsStart(String start) {
            if (this.myIgnoreMode || this.mySyntaxException != null) {
                return false;
            }
            return start != null && start.contains("IDEA additional info:");
        }

        @Override
        public void parse(String start, ListIterator<String> iterator) {
            if (this.myIgnoreMode) {
                return;
            }
            if (!iterator.hasNext()) {
                this.mySyntaxException = new PatchSyntaxException(iterator.previousIndex(), "Empty additional info header");
                return;
            }
            block0: while (true) {
                String header;
                int idxHead;
                if ((idxHead = (header = iterator.next()).indexOf("Subsystem: ")) == -1) {
                    if (this.myAddMap.isEmpty()) {
                        this.mySyntaxException = new PatchSyntaxException(iterator.previousIndex(), "Empty additional info header");
                    }
                    iterator.previous();
                    return;
                }
                String subsystem = header.substring(idxHead + "Subsystem: ".length()).trim();
                if (!iterator.hasNext()) {
                    this.mySyntaxException = new PatchSyntaxException(iterator.previousIndex(), "Empty '" + subsystem + "' data section");
                    return;
                }
                StringBuilder sb = new StringBuilder();
                this.myAddMap.put(subsystem, sb);
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    String line = iterator.next();
                    if (!line.startsWith("<+>")) {
                        iterator.previous();
                        continue block0;
                    }
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(StringUtil.unescapeStringCharacters((String)line.substring("<+>".length())));
                }
                break;
            }
        }

        public void acceptError(PatchSyntaxException e) {
            this.mySyntaxException = e;
        }
    }

    private static enum DiffFormat {
        CONTEXT,
        UNIFIED;

    }
}

