/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumbService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbService");
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract boolean isDumb();

    public static boolean isDumb(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/DumbService", "isDumb"));
        }
        return DumbService.getInstance(project).isDumb();
    }

    public abstract void runWhenSmart(@NotNull Runnable var1);

    public abstract void waitForSmartMode();

    public <T> T runReadActionInSmartMode(final @NotNull Computable<T> r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/project/DumbService", "runReadActionInSmartMode"));
        }
        final Ref result = new Ref();
        this.runReadActionInSmartMode(new Runnable(){

            @Override
            public void run() {
                result.set(r.compute());
            }
        });
        return (T)result.get();
    }

    @Nullable
    public <T> T tryRunReadActionInSmartMode(@NotNull Computable<T> task, @Nullable String notification) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbService", "tryRunReadActionInSmartMode"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                return (T)task.compute();
            }
            catch (IndexNotReadyException e) {
                if (notification != null) {
                    this.showDumbModeNotification(notification);
                }
                return null;
            }
        }
        return this.runReadActionInSmartMode(task);
    }

    public void runReadActionInSmartMode(final @NotNull Runnable r) {
        boolean success;
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/project/DumbService", "runReadActionInSmartMode"));
        }
        do {
            this.waitForSmartMode();
        } while (!(success = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                if (DumbService.this.isDumb()) {
                    return false;
                }
                r.run();
                return true;
            }
        }).booleanValue()));
    }

    public void repeatUntilPassesInSmartMode(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/project/DumbService", "repeatUntilPassesInSmartMode"));
        }
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
                continue;
            }
            break;
        }
    }

    public abstract void smartInvokeLater(@NotNull Runnable var1);

    public abstract void smartInvokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/DumbService", "getInstance"));
        }
        return (DumbService)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
        }
        List<T> list = this.filterByDumbAwareness(Arrays.asList(array));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
        }
        return list;
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
        }
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result.add(element);
            }
            ArrayList<T> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
            }
            return arrayList;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
            }
            return list;
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
        }
        return arrayList;
    }

    public abstract void queueTask(@NotNull DumbModeTask var1);

    public abstract void cancelTask(@NotNull DumbModeTask var1);

    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    public void makeDumbAware(final @NotNull JComponent component, @NotNull Disposable disposable) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/project/DumbService", "makeDumbAware"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/project/DumbService", "makeDumbAware"));
        }
        component.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(disposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                component.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                component.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(@NotNull String var1);

    public abstract Project getProject();

    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public abstract void setAlternativeResolveEnabled(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withAlternativeResolveEnabled(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbService", "withAlternativeResolveEnabled"));
        }
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public abstract boolean isAlternativeResolveEnabled();

    public static interface DumbModeListener {
        public void enteredDumbMode();

        public void exitDumbMode();
    }
}

