/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorsProvider {
    @NotNull
    public abstract FileType getFileType();

    @NotNull
    public abstract Document createDocument(@NotNull Project var1, @NotNull String var2, @Nullable XSourcePosition var3, @NotNull EvaluationMode var4);

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "createDocument"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "createDocument"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "createDocument"));
        }
        Document document = this.createDocument(project, expression.getExpression(), sourcePosition, mode);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "createDocument"));
        }
        return document;
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "getSupportedLanguages"));
        }
        FileType type = this.getFileType();
        if (type instanceof LanguageFileType) {
            Set<Language> set = Collections.singleton(((LanguageFileType)type).getLanguage());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "getSupportedLanguages"));
            }
            return set;
        }
        List<Language> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "getSupportedLanguages"));
        }
        return list;
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "createExpression"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "createExpression"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "createExpression"));
        }
        XExpression xExpression = XDebuggerUtil.getInstance().createExpression(document.getText(), language, null, mode);
        if (xExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider", "createExpression"));
        }
        return xExpression;
    }

    public InlineDebuggerHelper getInlineDebuggerHelper() {
        return InlineDebuggerHelper.DEFAULT;
    }
}

