/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.hash.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyImportUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyImportOptimizerRefactoringHelper
implements RefactoringHelper<Set<GroovyFile>> {
    public Set<GroovyFile> prepareOperation(UsageInfo[] usages) {
        HashSet files = new HashSet();
        for (UsageInfo usage : usages) {
            PsiFile file;
            if (usage.isNonCodeUsage || !((file = usage.getFile()) instanceof GroovyFile) || !file.isValid() || !file.isPhysical()) continue;
            files.add((GroovyFile)file);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(final Project project, final Set<GroovyFile> files) {
        HashMap redundants;
        Runnable findUnusedImports;
        final ProgressManager progressManager = ProgressManager.getInstance();
        if (!progressManager.runProcessWithProgressSynchronously(findUnusedImports = new Runnable(redundants = new HashMap()){
            final /* synthetic */ Map val$redundants;
            {
                this.val$redundants = map;
            }

            @Override
            public void run() {
                ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                int total = files.size();
                int i = 0;
                for (final GroovyFile file : files) {
                    if (!file.isValid()) continue;
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInSource(virtualFile)) continue;
                    if (progressIndicator != null) {
                        progressIndicator.setText2(virtualFile.getPresentableUrl());
                        progressIndicator.setFraction((double)i++ / (double)total);
                    }
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            Set<GrImportStatement> usedImports = GroovyImportUtil.findUsedImports(file);
                            List<GrImportStatement> validImports = PsiUtil.getValidImportStatements(file);
                            val$redundants.put(file, Pair.create(validImports, usedImports));
                        }
                    });
                }
            }
        }, "Optimizing imports (Groovy) ... ", false, project)) {
            return;
        }
        AccessToken accessToken = WriteAction.start();
        try {
            for (GroovyFile groovyFile : redundants.keySet()) {
                if (!groovyFile.isValid()) continue;
                Pair pair = (Pair)redundants.get(groovyFile);
                List validImports = (List)pair.getFirst();
                Set usedImports = (Set)pair.getSecond();
                for (GrImportStatement importStatement : validImports) {
                    if (usedImports.contains(importStatement)) continue;
                    groovyFile.removeImport(importStatement);
                }
            }
        }
        finally {
            accessToken.finish();
        }
    }
}

