/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.RunAvdAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class WipeAvdDataAction
extends AvdUiAction {
    private static final Logger LOG = Logger.getInstance(RunAvdAction.class);

    public WipeAvdDataAction(AvdUiAction.AvdInfoProvider avdInfoProvider) {
        super(avdInfoProvider, "Wipe Data", "Wipe the user data of this AVD", AllIcons.Modules.Edit);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AvdInfo avdInfo = this.getAvdInfo();
        if (avdInfo == null) {
            return;
        }
        if (avdInfo.isRunning()) {
            JOptionPane.showMessageDialog(null, "The selected AVD is currently running in the Emulator. Please exit the emulator instance and try wiping again.", "Cannot Wipe A Running AVD", 0);
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Do you really want to wipe user files from AVD " + avdInfo.getName() + "?", "Confirm Data Wipe", 0);
        if (result == 0) {
            AvdManagerConnection.getDefaultAvdManagerConnection().wipeUserData(avdInfo);
            this.refreshAvds();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getAvdInfo() != null;
    }
}

