/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.ClientCellRenderer;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.ddms.OpenVmTraceHandler;
import com.android.tools.idea.ddms.ShowAllocationsHandler;
import com.android.tools.idea.ddms.actions.DumpSysActions;
import com.android.tools.idea.ddms.actions.GcAction;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenshotAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.ddms.actions.ToggleAllocationTrackingAction;
import com.android.tools.idea.ddms.actions.ToggleMethodProfilingAction;
import com.android.tools.idea.ddms.hprof.DumpHprofAction;
import com.android.tools.idea.ddms.hprof.SaveHprofHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePanel
implements Disposable,
AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener {
    private static final String NO_DEVICES = "No Connected Devices";
    private JPanel myPanel;
    private JComboBox myDevicesComboBox;
    private JBList myClientsList;
    private final DefaultComboBoxModel myComboBoxModel;
    private final SortedListModel<Client> myClientsListModel;
    private boolean myIgnoreListeners;
    private final DeviceContext myDeviceContext;
    private final Project myProject;
    @Nullable
    private AndroidDebugBridge myBridge;

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/DevicePanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/DevicePanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myComboBoxModel = new DefaultComboBoxModel();
        this.myClientsListModel = new SortedListModel((Comparator)new ClientCellRenderer.ClientComparator());
        this.myProject = project;
        this.myDeviceContext = context;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)new OpenVmTraceHandler(project));
        ClientData.setHprofDumpHandler((ClientData.IHprofDumpHandler)new SaveHprofHandler(project));
        ClientData.setAllocationTrackingHandler((ClientData.IAllocationTrackingHandler)new ShowAllocationsHandler(project));
        this.initializeDeviceCombo();
        this.initializeClientsList();
    }

    private void initializeDeviceCombo() {
        this.myDevicesComboBox.setModel(this.myComboBoxModel);
        this.myDevicesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object sel = DevicePanel.this.myDevicesComboBox.getSelectedItem();
                IDevice device = sel instanceof IDevice ? (IDevice)sel : null;
                DevicePanel.this.updateClientsForDevice(device);
                DevicePanel.this.myDeviceContext.fireDeviceSelected(device);
                DevicePanel.this.myDeviceContext.fireClientSelected(null);
            }
        });
        this.myDevicesComboBox.setRenderer(new DeviceRenderer.DeviceComboBoxRenderer());
    }

    private void setBridge(@Nullable AndroidDebugBridge bridge) {
        IDevice[] devices;
        this.myBridge = bridge;
        this.myComboBoxModel.removeAllElements();
        IDevice[] iDeviceArray = devices = this.myBridge == null ? null : this.myBridge.getDevices();
        if (devices == null || devices.length == 0) {
            this.myComboBoxModel.addElement(NO_DEVICES);
        } else {
            for (IDevice device : devices) {
                this.myComboBoxModel.addElement(device);
            }
        }
        this.myDevicesComboBox.setSelectedIndex(0);
    }

    public void selectDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/ddms/DevicePanel", "selectDevice"));
        }
        this.myDevicesComboBox.setSelectedItem(device);
    }

    private void initializeClientsList() {
        this.myClientsList.setModel(this.myClientsListModel);
        this.myClientsList.setSelectionMode(0);
        this.myClientsList.setEmptyText("No debuggable applications");
        this.myClientsList.setCellRenderer((ListCellRenderer)((Object)new ClientCellRenderer()));
        new ListSpeedSearch((JList)this.myClientsList){

            protected boolean isMatchingElement(Object element, String pattern) {
                if (element instanceof Client) {
                    String pkg = ((Client)element).getClientData().getClientDescription();
                    return pkg != null && pkg.contains(pattern);
                }
                return false;
            }
        };
        this.myClientsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || DevicePanel.this.myIgnoreListeners) {
                    return;
                }
                Object sel = DevicePanel.this.myClientsList.getSelectedValue();
                Client c = sel instanceof Client ? (Client)sel : null;
                DevicePanel.this.myDeviceContext.fireClientSelected(c);
            }
        });
    }

    public void dispose() {
        if (this.myBridge != null) {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            this.myBridge = null;
        }
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    public void bridgeChanged(final AndroidDebugBridge bridge) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.setBridge(bridge);
            }
        });
    }

    public void deviceConnected(final IDevice device) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.myComboBoxModel.removeElement(DevicePanel.NO_DEVICES);
                DevicePanel.this.myComboBoxModel.addElement(device);
            }
        });
    }

    public void deviceDisconnected(final IDevice device) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.myComboBoxModel.removeElement(device);
                if (DevicePanel.this.myComboBoxModel.getSize() == 0) {
                    DevicePanel.this.myComboBoxModel.addElement(DevicePanel.NO_DEVICES);
                }
            }
        });
    }

    public void deviceChanged(final IDevice device, final int changeMask) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.myDevicesComboBox.repaint();
                if (device != DevicePanel.this.myDevicesComboBox.getSelectedItem()) {
                    return;
                }
                if ((changeMask & 2) == 2) {
                    DevicePanel.this.updateClientsForDevice(device);
                }
                if (device != null) {
                    DevicePanel.this.myDeviceContext.fireDeviceChanged(device, changeMask);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClientsForDevice(@Nullable IDevice device) {
        if (device == null) {
            this.myClientsListModel.clear();
            return;
        }
        Object selectedObject = this.myClientsList.getSelectedValue();
        Object[] clients = device.getClients();
        try {
            this.myIgnoreListeners = ArrayUtil.contains((Object)selectedObject, (Object[])clients);
            this.myClientsListModel.clear();
            this.myClientsListModel.addAll(clients);
            this.myClientsList.setSelectedValue(selectedObject, true);
        }
        finally {
            this.myIgnoreListeners = false;
        }
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ScreenshotAction(this.myProject, this.myDeviceContext));
        group.add((AnAction)new ScreenRecorderAction(this.myProject, this.myDeviceContext));
        group.add((AnAction)DumpSysActions.create(this.myProject, this.myDeviceContext));
        group.add((AnAction)new Separator());
        group.add((AnAction)new TerminateVMAction(this.myDeviceContext));
        group.add((AnAction)new GcAction(this.myDeviceContext));
        group.add((AnAction)new DumpHprofAction(this.myDeviceContext));
        group.add((AnAction)new ToggleMethodProfilingAction(this.myProject, this.myDeviceContext));
        group.add((AnAction)new ToggleAllocationTrackingAction(this.myDeviceContext));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/DevicePanel", "getToolbarActions"));
        }
        return defaultActionGroup;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.myDevicesComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, "North");
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.myClientsList = jBList = new JBList();
        DefaultListModel defaultListModel = new DefaultListModel();
        jBList.setModel(defaultListModel);
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

