/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.PsiProjectListener;
import com.android.tools.idea.rendering.ResourceFolderRepository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ResourceFolderRegistry {
    private static final Map<VirtualFile, ResourceFolderRepository> ourDirMap = new HashMap<VirtualFile, ResourceFolderRepository>();

    public static void reset() {
        for (Map.Entry<VirtualFile, ResourceFolderRepository> entry : ourDirMap.entrySet()) {
            VirtualFile dir = entry.getKey();
            ResourceFolderRepository repository = entry.getValue();
            Project project = repository.getFacet().getModule().getProject();
            PsiProjectListener.removeRoot(project, dir, repository);
        }
        ourDirMap.clear();
    }

    @NotNull
    public static ResourceFolderRepository get(@NotNull AndroidFacet facet, final @NotNull VirtualFile dir) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ResourceFolderRegistry", "get"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/android/tools/idea/rendering/ResourceFolderRegistry", "get"));
        }
        ResourceFolderRepository repository = ourDirMap.get(dir);
        if (repository == null) {
            Project project = facet.getModule().getProject();
            repository = ResourceFolderRepository.create(facet, dir);
            PsiProjectListener.addRoot(project, dir, repository);
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    ResourceFolderRepository repository = (ResourceFolderRepository)((Object)ourDirMap.remove(dir));
                    if (repository != null) {
                        repository.dispose();
                    }
                }
            });
            ourDirMap.put(dir, repository);
        }
        ResourceFolderRepository resourceFolderRepository = repository;
        if (resourceFolderRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceFolderRegistry", "get"));
        }
        return resourceFolderRepository;
    }
}

