/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.Haxm;
import com.google.common.collect.Iterables;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class FirstRunWizardDefaults {
    public static final String HAXM_DOCUMENTATION_URL = "http://www.intel.com/software/android/";
    public static final FullRevision MIN_BUILD_TOOLS_REVSION = new FullRevision(21, 1, 1);

    private FirstRunWizardDefaults() {
    }

    public static int getRecommendedHaxmMemory(long memorySize) {
        long GB = Storage.Unit.GiB.getNumberOfBytes();
        long defaultMemory = memorySize > 4L * GB ? 2L * GB : (memorySize > 2L * GB ? GB : GB / 2L);
        return (int)(defaultMemory / Haxm.UI_UNITS.getNumberOfBytes());
    }

    @NotNull
    public static String getSdkDownloadUrl() {
        String downloadUrl;
        String url = System.getProperty("android.sdkurl");
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            File file = new File(url);
            if (file.isFile()) {
                String string = "file://" + PathUtil.toSystemIndependentName((String)file.getAbsolutePath());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getSdkDownloadUrl"));
                }
                return string;
            }
            System.err.println("File " + file.getAbsolutePath() + " does not exist.");
        }
        if ((downloadUrl = AndroidSdkUtils.getSdkDownloadUrl()) == null) {
            throw new IllegalStateException("Unsupported OS");
        }
        String string = downloadUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getSdkDownloadUrl"));
        }
        return string;
    }

    @NotNull
    private static File getDefaultSdkLocation() {
        String path;
        String userHome = System.getProperty("user.home");
        if (SystemInfo.isWindows) {
            path = FileUtil.join((String[])new String[]{userHome, "AppData", "Local", "Android", "Sdk"});
        } else if (SystemInfo.isMac) {
            path = FileUtil.join((String[])new String[]{userHome, "Library", "Android", "sdk"});
        } else if (SystemInfo.isLinux) {
            path = FileUtil.join((String[])new String[]{userHome, "Android", "Sdk"});
        } else {
            throw new IllegalStateException("Unsupported OS");
        }
        File file = new File(path);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getDefaultSdkLocation"));
        }
        return file;
    }

    @NotNull
    public static File getInitialSdkLocation(@NotNull FirstRunWizardMode mode) {
        VirtualFile homeDirectory;
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getInitialSdkLocation"));
        }
        File dest = mode.getSdkLocation();
        if (dest != null) {
            File file = dest;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getInitialSdkLocation"));
            }
            return file;
        }
        List<Sdk> sdks = AndroidSdkUtils.getAllAndroidSdks();
        Sdk sdk = (Sdk)Iterables.getFirst(sdks, null);
        if (sdk != null && (homeDirectory = sdk.getHomeDirectory()) != null) {
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)homeDirectory);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getInitialSdkLocation"));
            }
            return file;
        }
        File file = FirstRunWizardDefaults.getDefaultSdkLocation();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getInitialSdkLocation"));
        }
        return file;
    }
}

