/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.ASGallery;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ModuleTemplate;
import com.android.tools.idea.wizard.ModuleTemplateProvider;
import com.android.tools.idea.wizard.NewModuleWizardDynamic;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseModuleTypeStep
extends DynamicWizardStepWithHeaderAndDescription {
    private final Iterable<ModuleTemplateProvider> myModuleTypesProviders;
    private JPanel myPanel;
    private JBList myModuleTypeList;
    private ASGallery<ModuleTemplate> myFormFactorGallery;
    private JPanel myModulesPanel;
    private boolean myIsSynchronizingSelection = false;

    @Override
    @Nullable
    protected JComponent getHeader() {
        return NewModuleWizardDynamic.buildHeader();
    }

    @Override
    @Nullable
    protected JBColor getTitleTextColor() {
        return WizardConstants.ANDROID_NPW_TITLE_COLOR;
    }

    public ChooseModuleTypeStep(Iterable<ModuleTemplateProvider> moduleTypesProviders, @Nullable Disposable parentDisposable) {
        super("Choose Module Type", "Select an option below to create your new module", null, parentDisposable);
        this.$$$setupUI$$$();
        this.myModuleTypeList.setCellRenderer((ListCellRenderer)new TemplateListCellRenderer());
        this.myModuleTypesProviders = moduleTypesProviders;
        this.myModuleTypeList.setBorder(BorderFactory.createLineBorder(UIUtil.getBorderColor()));
        this.myFormFactorGallery.setBorder(BorderFactory.createLineBorder(UIUtil.getBorderColor()));
        this.setBodyComponent(this.myPanel);
    }

    @Nullable
    @Contract(value="null->null")
    public static Image iconToImage(@Nullable Icon icon) {
        if (icon == null) {
            return null;
        }
        BufferedImage image = UIUtil.createImage((int)icon.getIconWidth(), (int)icon.getIconHeight(), (int)6);
        Graphics2D graphics = image.createGraphics();
        graphics.setBackground(JBColor.background());
        graphics.setColor(JBColor.background());
        icon.paintIcon(null, graphics, 0, 0);
        return image;
    }

    @Override
    public void init() {
        super.init();
        ImmutableList.Builder galleryTemplates = ImmutableList.builder();
        ImmutableList.Builder extrasTemplates = ImmutableList.builder();
        HashSet formFactorSet = Sets.newHashSet();
        for (ModuleTemplateProvider provider : this.myModuleTypesProviders) {
            for (ModuleTemplate moduleTemplate : provider.getModuleTemplates()) {
                FormFactorUtils.FormFactor formFactor;
                if (moduleTemplate.isGalleryModuleType()) {
                    galleryTemplates.add((Object)moduleTemplate);
                } else {
                    extrasTemplates.add((Object)moduleTemplate);
                }
                if ((formFactor = moduleTemplate.getFormFactor()) == null) continue;
                formFactorSet.add(formFactor);
            }
        }
        for (final FormFactorUtils.FormFactor formFactor : formFactorSet) {
            this.registerValueDeriver(FormFactorUtils.getInclusionKey(formFactor), new ScopedDataBinder.ValueDeriver<Boolean>(){

                @Override
                @Nullable
                public Boolean deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable Boolean currentValue) {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/wizard/ChooseModuleTypeStep$1", "deriveValue"));
                    }
                    ModuleTemplate moduleTemplate = ChooseModuleTypeStep.this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
                    return moduleTemplate != null && Objects.equal((Object)formFactor, (Object)moduleTemplate.getFormFactor());
                }
            });
        }
        ImmutableList galleryTemplatesList = galleryTemplates.build();
        ImmutableList extrasTemplatesList = extrasTemplates.build();
        this.myModuleTypeList.setSelectionMode(0);
        this.myModuleTypeList.setModel((ListModel)JBList.createDefaultListModel((Object[])ArrayUtil.toObjectArray((Collection)extrasTemplatesList)));
        this.myFormFactorGallery.setModel(JBList.createDefaultListModel((Object[])ArrayUtil.toObjectArray((Collection)galleryTemplatesList)));
        ModuleTypeBinding binding = new ModuleTypeBinding();
        this.register(WizardConstants.SELECTED_MODULE_TYPE_KEY, this.myPanel, binding);
        this.myModuleTypeList.addListSelectionListener((ListSelectionListener)new ModuleTypeSelectionListener(true));
        this.myFormFactorGallery.addListSelectionListener(new ModuleTypeSelectionListener(false));
        if (!galleryTemplatesList.isEmpty()) {
            this.myState.put(WizardConstants.SELECTED_MODULE_TYPE_KEY, galleryTemplatesList.get(0));
        }
    }

    @Override
    public boolean commitStep() {
        ModuleTemplate selected = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        if (selected != null) {
            selected.updateWizardStateOnSelection(this.myState);
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Choose Module Type Step" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ChooseModuleTypeStep", "getStepName"));
        }
        return "Choose Module Type Step";
    }

    public JComponent getPreferredFocusedComponent() {
        ModuleTemplate moduleTemplate = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        return moduleTemplate == null || moduleTemplate.isGalleryModuleType() ? this.myFormFactorGallery : this.myModuleTypeList;
    }

    private void createUIComponents() {
        this.myFormFactorGallery = new ASGallery<ModuleTemplate>(JBList.createDefaultListModel((Object[])new Object[0]), new Function<ModuleTemplate, Image>(){

            public Image apply(ModuleTemplate input) {
                return ChooseModuleTypeStep.iconToImage(input.getIcon());
            }
        }, Functions.toStringFunction(), new Dimension(128, 128));
        this.myFormFactorGallery.setCellMargin(new Insets(0, 25, 0, 25));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ASGallery<ModuleTemplate> aSGallery = this.myFormFactorGallery;
        jPanel2.add(aSGallery, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModulesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 0, 7, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(650, -1), null));
        this.myModuleTypeList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("More Modules");
        jPanel2.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class ModuleTypeSelectionListener
    implements ListSelectionListener {
        private final boolean myGallery;

        public ModuleTypeSelectionListener(boolean gallery) {
            this.myGallery = gallery;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ChooseModuleTypeStep.this.myIsSynchronizingSelection) {
                return;
            }
            ChooseModuleTypeStep.this.myIsSynchronizingSelection = true;
            if (this.myGallery) {
                ChooseModuleTypeStep.this.myFormFactorGallery.setSelectedElement(null);
            } else {
                ChooseModuleTypeStep.this.myModuleTypeList.clearSelection();
            }
            ChooseModuleTypeStep.this.myIsSynchronizingSelection = false;
            ChooseModuleTypeStep.this.saveState(ChooseModuleTypeStep.this.myPanel);
            ChooseModuleTypeStep.this.invokeUpdate(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        }
    }

    private class ModuleTypeBinding
    extends ScopedDataBinder.ComponentBinding<ModuleTemplate, JPanel> {
        private ModuleTypeBinding() {
        }

        @Override
        public void setValue(@Nullable ModuleTemplate newValue, @NotNull JPanel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ChooseModuleTypeStep$ModuleTypeBinding", "setValue"));
            }
            if (newValue == null) {
                ChooseModuleTypeStep.this.myModuleTypeList.clearSelection();
                ChooseModuleTypeStep.this.myFormFactorGallery.setSelectedElement(null);
            } else if (!newValue.isGalleryModuleType()) {
                ChooseModuleTypeStep.this.myModuleTypeList.setSelectedValue((Object)newValue, true);
                ChooseModuleTypeStep.this.myFormFactorGallery.setSelectedElement(null);
            } else {
                ChooseModuleTypeStep.this.myModuleTypeList.clearSelection();
                ChooseModuleTypeStep.this.myFormFactorGallery.setSelectedElement(newValue);
            }
        }

        @Override
        @Nullable
        public ModuleTemplate getValue(@NotNull JPanel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ChooseModuleTypeStep$ModuleTypeBinding", "getValue"));
            }
            ModuleTemplate moduleTemplate = (ModuleTemplate)ChooseModuleTypeStep.this.myFormFactorGallery.getSelectedElement();
            if (moduleTemplate == null) {
                moduleTemplate = (ModuleTemplate)ChooseModuleTypeStep.this.myModuleTypeList.getSelectedValue();
            }
            return moduleTemplate;
        }
    }

    private static class TemplateListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout(32, 0));
        private final JLabel myDescriptionLabel = new JLabel();
        private JLabel myLabel = new JLabel();

        public TemplateListCellRenderer() {
            this.myLabel.setFont(UIUtil.getListFont());
            this.myDescriptionLabel.setFont(UIUtil.getToolTipFont());
            this.myDescriptionLabel.setVerticalAlignment(1);
            this.myPanel.add((Component)this.myLabel, "North");
            this.myPanel.add((Component)this.myDescriptionLabel, "Center");
        }

        private static int getInsetsWidth(Insets insets) {
            return insets.left + insets.right;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color bg = UIUtil.getListBackground();
            Color fg = UIUtil.getListForeground();
            Color descriptionFg = UIUtil.getInactiveTextColor();
            Border border = BorderFactory.createCompoundBorder(UIUtil.getTableFocusCellHighlightBorder(), IdeBorderFactory.createEmptyBorder((int)5));
            if (isSelected) {
                bg = UIUtil.getListSelectionBackground();
                descriptionFg = fg = UIUtil.getListSelectionForeground();
            }
            if (!cellHasFocus) {
                border = IdeBorderFactory.createEmptyBorder((Insets)border.getBorderInsets(this.myLabel));
            }
            this.myPanel.setBorder(border);
            if (value instanceof ModuleTemplate) {
                String name = ((ModuleTemplate)value).getName();
                this.myLabel.setText(name);
                String description = ((ModuleTemplate)value).getDescription();
                if (!StringUtil.isEmpty((String)description) && !BasicHTML.isHTMLString(description)) {
                    description = "<html>" + description + "</html>";
                }
                if (!StringUtil.isEmpty((String)description)) {
                    View htmlView = BasicHTML.createHTMLView(this.myDescriptionLabel, description);
                    int width = 630 - (TemplateListCellRenderer.getInsetsWidth(border.getBorderInsets(this.myPanel)) + TemplateListCellRenderer.getInsetsWidth(list.getInsets()));
                    htmlView.setSize(width, 500.0f);
                    int preferredSpan = (int)htmlView.getPreferredSpan(1);
                    this.myDescriptionLabel.setPreferredSize(new Dimension(width, preferredSpan));
                }
                this.myDescriptionLabel.setText(description);
            }
            this.myLabel.setForeground(fg);
            this.myDescriptionLabel.setForeground(descriptionFg);
            this.myPanel.setBackground(bg);
            return this.myPanel;
        }
    }
}

