/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardHost;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.Maps;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DialogWrapperHost
extends DialogWrapper
implements DynamicWizardHost {
    private Action myPreviousAction = new PreviousAction();
    private Action myNextAction = new NextAction();
    private Action myFinishAction = new FinishAction();
    private DynamicWizard myWizard;
    private TallImageComponent myIcon = new TallImageComponent(null);
    private JPanel myCenterPanel;
    private Map<Action, JButton> myActionToButtonMap = Maps.newHashMapWithExpectedSize((int)5);

    public DialogWrapperHost(@Nullable Project project) {
        super(project);
        Window window = this.getWindow();
        if (window == null) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
        } else {
            window.setPreferredSize(WizardConstants.DEFAULT_WIZARD_WINDOW_SIZE);
        }
    }

    @Override
    public void init(@NotNull DynamicWizard wizard) {
        Container rootPanel;
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/wizard/DialogWrapperHost", "init"));
        }
        this.myWizard = wizard;
        super.init();
        Container centerRootPanel = this.myCenterPanel.getParent();
        if (centerRootPanel != null && (rootPanel = centerRootPanel.getParent()) instanceof JPanel) {
            ((JPanel)rootPanel).setBorder(new EmptyBorder(0, 0, 0, 0));
        }
    }

    @Override
    public void close(@NotNull DynamicWizardHost.CloseAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/wizard/DialogWrapperHost", "close"));
        }
        if (action == DynamicWizardHost.CloseAction.FINISH) {
            this.doOKAction();
        } else if (action == DynamicWizardHost.CloseAction.CANCEL) {
            this.dialogWrapperCancel();
        }
    }

    private void dialogWrapperCancel() {
        super.doCancelAction();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent focusedComponent = this.myWizard.getPreferredFocusedComponent();
        return focusedComponent == null ? this.getNextButton() : focusedComponent;
    }

    @Override
    public void shakeWindow() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DialogEarthquakeShaker.shake((JDialog)((JDialog)this.getPeer().getWindow()));
        }
    }

    @NotNull
    protected final Action[] createActions() {
        if (this.getHelpId() == null) {
            if (SystemInfo.isMac) {
                Action[] actionArray = new Action[]{this.getCancelAction(), this.myPreviousAction, this.myNextAction, this.myFinishAction};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DialogWrapperHost", "createActions"));
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{this.myPreviousAction, this.myNextAction, this.getCancelAction(), this.myFinishAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DialogWrapperHost", "createActions"));
            }
            return actionArray;
        }
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getHelpAction(), this.getCancelAction(), this.myPreviousAction, this.myNextAction, this.myFinishAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DialogWrapperHost", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myPreviousAction, this.myNextAction, this.getCancelAction(), this.myFinishAction, this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DialogWrapperHost", "createActions"));
        }
        return actionArray;
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
        this.myIcon.setIcon(icon);
        this.myIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
    }

    @Override
    public void runSensitiveOperation(@NotNull ProgressIndicator progressIndicator, boolean cancellable, @NotNull Runnable operation) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/android/tools/idea/wizard/DialogWrapperHost", "runSensitiveOperation"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/android/tools/idea/wizard/DialogWrapperHost", "runSensitiveOperation"));
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    protected final JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        this.myActionToButtonMap.put(action, button);
        return button;
    }

    protected void doHelpAction() {
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JPanel southPanel = (JPanel)super.createSouthPanel();
        assert (southPanel != null);
        southPanel.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        return southPanel;
    }

    public final void doCancelAction() {
        this.myWizard.doCancelAction();
    }

    @Override
    public void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canCancel, boolean canFinish) {
        this.getPreviousButton().setEnabled(canGoPrev);
        this.getNextButton().setEnabled(canGoNext);
        this.getFinishButton().setEnabled(canFinish);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getRootPane().setDefaultButton(canFinish ? this.getFinishButton() : this.getNextButton());
        }
    }

    @Nullable
    protected final JComponent createCenterPanel() {
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.myCenterPanel.add(this.myWizard.getContentPane(), "Center");
        this.myCenterPanel.add((Component)((Object)this.myIcon), "West");
        return this.myCenterPanel;
    }

    @NotNull
    private JButton getNextButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myNextAction);
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DialogWrapperHost", "getNextButton"));
        }
        return jButton;
    }

    @NotNull
    private JButton getPreviousButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myPreviousAction);
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DialogWrapperHost", "getPreviousButton"));
        }
        return jButton;
    }

    @NotNull
    private JButton getFinishButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myFinishAction);
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DialogWrapperHost", "getFinishButton"));
        }
        return jButton;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    @Override
    public void setPreferredWindowSize(Dimension dimension) {
        this.getContentPanel().setPreferredSize(dimension);
    }

    protected class FinishAction
    extends DialogWrapper.DialogWrapperAction {
        protected FinishAction() {
            super((DialogWrapper)DialogWrapperHost.this, IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DialogWrapperHost.this.myWizard.doFinishAction();
        }
    }

    protected class PreviousAction
    extends DialogWrapper.DialogWrapperAction {
        protected PreviousAction() {
            super((DialogWrapper)DialogWrapperHost.this, IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DialogWrapperHost.this.myWizard.doPreviousAction();
        }
    }

    protected class NextAction
    extends DialogWrapper.DialogWrapperAction {
        protected NextAction() {
            super((DialogWrapper)DialogWrapperHost.this, IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        protected void doAction(ActionEvent e) {
            DialogWrapperHost.this.myWizard.doNextAction();
        }
    }

    public static class TallImageComponent
    extends OpaquePanel {
        @Nullable
        private Icon myIcon;

        public TallImageComponent(@Nullable Icon icon) {
            this.myIcon = icon;
        }

        protected void paintChildren(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            this.paintIcon(g);
        }

        public void paintIcon(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            BufferedImage image = UIUtil.createImage((int)this.myIcon.getIconWidth(), (int)this.myIcon.getIconHeight(), (int)2);
            Graphics2D gg = image.createGraphics();
            this.myIcon.paintIcon((Component)((Object)this), gg, 0, 0);
            Rectangle bounds = g.getClipBounds();
            for (int y = this.myIcon.getIconHeight() - 1; y < bounds.y + bounds.height; ++y) {
                g.drawImage(image, bounds.x, y, bounds.x + bounds.width, y + 1, 0, this.myIcon.getIconHeight() - 1, bounds.width, this.myIcon.getIconHeight(), (ImageObserver)((Object)this));
            }
            g.drawImage(image, 0, 0, (ImageObserver)((Object)this));
        }

        public void setIcon(@Nullable Icon icon) {
            this.myIcon = icon;
            this.revalidate();
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }
    }
}

