/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.aapt;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.aapt.AbstractAaptOutputParser;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class Error5Parser
extends AbstractAaptOutputParser {
    private static final List<Pattern> MSG_PATTERNS = ImmutableList.of((Object)Pattern.compile("^(.+?):(\\d+): error: Error:\\s+(.+)$"), (Object)Pattern.compile("^(.+?):(\\d+): error:\\s+(.+)$"), (Object)Pattern.compile("^(.+?):(\\d+):\\s+(.+)$"));

    Error5Parser() {
    }

    @Override
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<GradleMessage> messages) throws ParsingFailedException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/aapt/Error5Parser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/gradle/output/parser/aapt/Error5Parser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/aapt/Error5Parser", "parse"));
        }
        for (Pattern pattern : MSG_PATTERNS) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            String sourcePath = m.group(1);
            String lineNumber = m.group(2);
            String msgText = m.group(3);
            GradleMessage.Kind kind = GradleMessage.Kind.ERROR;
            if (msgText.startsWith("warning: ")) {
                kind = GradleMessage.Kind.WARNING;
            }
            if (sourcePath.endsWith(".java")) {
                return false;
            }
            GradleMessage msg = this.createMessage(kind, msgText, sourcePath, lineNumber);
            messages.add(msg);
            return true;
        }
        return false;
    }
}

