/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.FieldAccessor;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.JDOMExternalizableStringListBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.PropertyAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.TObjectFloatHashMap;
import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanBinding
extends Binding {
    private static final Logger LOG = Logger.getInstance(BeanBinding.class);
    private static final Map<Class, List<Accessor>> ourAccessorCache = ContainerUtil.createConcurrentSoftValueMap();
    private final String myTagName;
    private Binding[] myBindings;
    private final Class<?> myBeanClass;

    public BeanBinding(@NotNull Class<?> beanClass, @Nullable Accessor accessor) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/util/xmlb/BeanBinding", "<init>"));
        }
        super(accessor);
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public synchronized void init() {
        assert (this.myBindings == null);
        List<Accessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new Binding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = BeanBinding.createBinding(accessors.get(i));
            binding.init();
            this.myBindings[i] = binding;
        }
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/BeanBinding", "serialize"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/BeanBinding", "serialize"));
        }
        return this.serializeInto(o, context == null ? null : new Element(this.myTagName), filter);
    }

    public Element serialize(@NotNull Object object, boolean createElementIfEmpty, @NotNull SerializationFilter filter) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/BeanBinding", "serialize"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/BeanBinding", "serialize"));
        }
        return this.serializeInto(object, createElementIfEmpty ? new Element(this.myTagName) : null, filter);
    }

    @Nullable
    public Element serializeInto(@NotNull Object o, @Nullable Element element, @NotNull SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/BeanBinding", "serializeInto"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/BeanBinding", "serializeInto"));
        }
        for (Binding binding : this.myBindings) {
            Object node;
            Property property;
            Accessor accessor = binding.getAccessor();
            if (!filter.accepts(accessor, o) || (property = accessor.getAnnotation(Property.class)) != null && property.filter() != SerializationFilter.class && !ReflectionUtil.newInstance(property.filter(), new Class[0]).accepts(accessor, o)) continue;
            if (element == null) {
                element = new Element(this.myTagName);
            }
            if ((node = binding.serialize(o, element, filter)) == null) continue;
            if (node instanceof org.jdom.Attribute) {
                element.setAttribute((org.jdom.Attribute)node);
                continue;
            }
            JDOMUtil.addContent(element, node);
        }
        return element;
    }

    @Override
    public Object deserialize(Object context, @NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/BeanBinding", "deserialize"));
        }
        Object instance = ReflectionUtil.newInstance(this.myBeanClass, new Class[0]);
        this.deserializeInto(instance, (Element)node, null);
        return instance;
    }

    @NotNull
    public TObjectFloatHashMap<String> computeBindingWeights(@NotNull LinkedHashSet<String> accessorNameTracker) {
        if (accessorNameTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorNameTracker", "com/intellij/util/xmlb/BeanBinding", "computeBindingWeights"));
        }
        TObjectFloatHashMap weights = new TObjectFloatHashMap(accessorNameTracker.size());
        float weight = 0.0f;
        float step = (float)this.myBindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put((Object)name, weight);
            weight += step;
        }
        weight = 0.0f;
        for (Binding binding : this.myBindings) {
            String name = binding.getAccessor().getName();
            if (!weights.containsKey((Object)name)) {
                weights.put((Object)name, weight);
            }
            weight += 1.0f;
        }
        TObjectFloatHashMap tObjectFloatHashMap = weights;
        if (tObjectFloatHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "computeBindingWeights"));
        }
        return tObjectFloatHashMap;
    }

    public void sortBindings(final @NotNull TObjectFloatHashMap<String> weights) {
        if (weights == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "weights", "com/intellij/util/xmlb/BeanBinding", "sortBindings"));
        }
        Arrays.sort(this.myBindings, new Comparator<Binding>(){

            @Override
            public int compare(@NotNull Binding o1, @NotNull Binding o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/util/xmlb/BeanBinding$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/util/xmlb/BeanBinding$1", "compare"));
                }
                String n1 = o1.getAccessor().getName();
                String n2 = o2.getAccessor().getName();
                float w1 = weights.get((Object)n1);
                float w2 = weights.get((Object)n2);
                return (int)(w1 - w2);
            }
        });
    }

    public void deserializeInto(@NotNull Object result, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        MultiMap<Binding, Cloneable> data = null;
        block0: for (Cloneable child : ContainerUtil.concat(element.getContent(), element.getAttributes())) {
            if (XmlSerializerImpl.isIgnoredNode(child)) continue;
            for (Binding binding : this.myBindings) {
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = MultiMap.createLinked();
                    }
                    data.putValue(binding, child);
                    continue block0;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserialize(result, child);
                continue block0;
            }
            String message = "Format error: no binding for " + child + " inside " + this;
            LOG.debug(message);
            Logger.getInstance(this.myBeanClass.getName()).debug(message);
            Logger.getInstance("#" + this.myBeanClass.getName()).debug(message);
        }
        if (data != null) {
            for (Binding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result, (List)data.get(binding));
            }
        }
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    private static String getTagName(Class<?> aClass) {
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            return name;
        }
        String name = aClass.getSimpleName();
        return name.isEmpty() ? aClass.getSuperclass().getSimpleName() : name;
    }

    private static String getTagNameFromAnnotation(Class<?> aClass) {
        Tag tag = aClass.getAnnotation(Tag.class);
        return tag != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    static List<Accessor> getAccessors(Class<?> aClass) {
        List<Accessor> accessors = ourAccessorCache.get(aClass);
        if (accessors != null) {
            List<Accessor> list = accessors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "getAccessors"));
            }
            return list;
        }
        accessors = ContainerUtil.newArrayList();
        if (aClass != Rectangle.class) {
            BeanBinding.collectPropertyAccessors(aClass, accessors);
        }
        BeanBinding.collectFieldAccessors(aClass, accessors);
        ourAccessorCache.put(aClass, accessors);
        List<Accessor> list = accessors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "getAccessors"));
        }
        return list;
    }

    private static void collectPropertyAccessors(Class<?> aClass, List<Accessor> accessors) {
        TreeMap candidates = ContainerUtilRt.newTreeMap();
        for (Method method : aClass.getMethods()) {
            Pair<String, Boolean> propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || ((String)propertyData.first).equals("class") || method.getParameterTypes().length != ((Boolean)propertyData.second != false ? 1 : 0)) continue;
            Couple<Object> candidate = (Couple)candidates.get(propertyData.first);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if (((Boolean)propertyData.second != false ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = Couple.of((Boolean)propertyData.second != false ? (Method)candidate.first : method, (Boolean)propertyData.second != false ? method : (Method)candidate.second);
            candidates.put(propertyData.first, candidate);
        }
        for (Map.Entry candidate : candidates.entrySet()) {
            Couple methods = (Couple)candidate.getValue();
            if (methods.first == null || methods.second == null || !((Method)methods.first).getReturnType().equals(((Method)methods.second).getParameterTypes()[0]) || ((Method)methods.first).getAnnotation(Transient.class) != null || ((Method)methods.second).getAnnotation(Transient.class) != null) continue;
            accessors.add(new PropertyAccessor((String)candidate.getKey(), ((Method)methods.first).getReturnType(), (Method)methods.first, (Method)methods.second));
        }
    }

    private static void collectFieldAccessors(@NotNull Class<?> aClass, @NotNull List<Accessor> accessors) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/BeanBinding", "collectFieldAccessors"));
        }
        if (accessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessors", "com/intellij/util/xmlb/BeanBinding", "collectFieldAccessors"));
        }
        Class<?> currentClass = aClass;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || field.getAnnotation(OptionTag.class) == null && field.getAnnotation(Tag.class) == null && field.getAnnotation(Attribute.class) == null && field.getAnnotation(Property.class) == null && field.getAnnotation(Text.class) == null && (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers) || field.getAnnotation(Transient.class) != null)) continue;
                accessors.add(new FieldAccessor(field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass.getAnnotation(Transient.class) == null);
    }

    @Nullable
    private static Pair<String, Boolean> getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/util/xmlb/BeanBinding", "getPropertyData"));
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3, methodName.length());
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2, methodName.length());
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3, methodName.length());
            isSetter = true;
        }
        return part.isEmpty() ? null : Pair.create(Introspector.decapitalize(part), isSetter);
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static Binding createBinding(@NotNull Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
        }
        Binding binding = XmlSerializerImpl.getTypeBinding(accessor.getGenericType(), accessor);
        if (binding instanceof JDOMElementBinding) {
            Binding binding2 = binding;
            if (binding2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return binding2;
        }
        Attribute attribute = accessor.getAnnotation(Attribute.class);
        if (attribute != null) {
            AttributeBinding attributeBinding = new AttributeBinding(accessor, attribute);
            if (attributeBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return attributeBinding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            TagBinding tagBinding = new TagBinding(accessor, tag);
            if (tagBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return tagBinding;
        }
        Text text = accessor.getAnnotation(Text.class);
        if (text != null) {
            TextBinding textBinding = new TextBinding(accessor);
            if (textBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return textBinding;
        }
        if (binding instanceof JDOMExternalizableStringListBinding) {
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding);
            if (accessorBindingWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return accessorBindingWrapper;
        }
        boolean surroundWithTag = true;
        Property property = accessor.getAnnotation(Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
        }
        if (!surroundWithTag) {
            if (!Element.class.isAssignableFrom(binding.getBoundNodeType())) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding);
            if (accessorBindingWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return accessorBindingWrapper;
        }
        OptionTagBinding optionTagBinding = new OptionTagBinding(accessor, accessor.getAnnotation(OptionTag.class));
        if (optionTagBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "createBinding"));
        }
        return optionTagBinding;
    }
}

