/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.struct.attr.StructLineNumberTableAttribute;

public class BytecodeMappingTracer {
    private int currentSourceLine;
    private StructLineNumberTableAttribute lineNumberTable = null;
    private Map<Integer, Integer> mapping = new HashMap<Integer, Integer>();

    public BytecodeMappingTracer() {
    }

    public BytecodeMappingTracer(int initial_source_line) {
        this.currentSourceLine = initial_source_line;
    }

    public void incrementCurrentSourceLine() {
        ++this.currentSourceLine;
    }

    public void incrementCurrentSourceLine(int number_lines) {
        this.currentSourceLine += number_lines;
    }

    public void shiftSourceLines(int shift) {
        for (Map.Entry<Integer, Integer> entry : this.mapping.entrySet()) {
            entry.setValue(entry.getValue() + shift);
        }
    }

    public void addMapping(int bytecode_offset) {
        if (!this.mapping.containsKey(bytecode_offset)) {
            this.mapping.put(bytecode_offset, this.currentSourceLine);
        }
    }

    public void addMapping(Set<Integer> bytecode_offsets) {
        if (bytecode_offsets != null) {
            for (Integer bytecode_offset : bytecode_offsets) {
                this.addMapping(bytecode_offset);
            }
        }
    }

    public void addTracer(BytecodeMappingTracer tracer) {
        if (tracer != null) {
            for (Map.Entry<Integer, Integer> entry : tracer.mapping.entrySet()) {
                if (this.mapping.containsKey(entry.getKey())) continue;
                this.mapping.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<Integer, Integer> getMapping() {
        return this.mapping;
    }

    public int getCurrentSourceLine() {
        return this.currentSourceLine;
    }

    public void setCurrentSourceLine(int currentSourceLine) {
        this.currentSourceLine = currentSourceLine;
    }

    public void setLineNumberTable(StructLineNumberTableAttribute lineNumberTable) {
        this.lineNumberTable = lineNumberTable;
    }

    public Map<Integer, Integer> getOriginalLinesMapping() {
        int originalLine;
        if (this.lineNumberTable == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> res = new HashMap<Integer, Integer>();
        int[] data = this.lineNumberTable.getRawData();
        for (int i = 0; i < data.length; i += 2) {
            int originalOffset = data[i];
            originalLine = data[i + 1];
            Integer newLine = this.mapping.get(originalOffset);
            if (newLine == null) continue;
            res.put(originalLine, newLine);
        }
        for (Map.Entry<Integer, Integer> entry : this.mapping.entrySet()) {
            originalLine = this.lineNumberTable.findLineNumber(entry.getKey());
            if (originalLine <= -1) continue;
            res.put(originalLine, entry.getValue());
        }
        return res;
    }
}

