/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ConstExprent
extends Exprent {
    private static final Map<Integer, String> ESCAPES = new HashMap<Integer, String>(){
        {
            this.put(new Integer(8), "\\b");
            this.put(new Integer(9), "\\t");
            this.put(new Integer(10), "\\n");
            this.put(new Integer(12), "\\f");
            this.put(new Integer(13), "\\r");
            this.put(new Integer(34), "\\\"");
            this.put(new Integer(39), "\\'");
            this.put(new Integer(92), "\\\\");
        }
    };
    private VarType constType;
    private final Object value;
    private final boolean boolPermitted;

    public ConstExprent(int val, boolean boolPermitted, Set<Integer> bytecodeOffsets) {
        this(ConstExprent.guessType(val, boolPermitted), new Integer(val), boolPermitted, bytecodeOffsets);
    }

    public ConstExprent(VarType constType, Object value, Set<Integer> bytecodeOffsets) {
        this(constType, value, false, bytecodeOffsets);
    }

    private ConstExprent(VarType constType, Object value, boolean boolPermitted, Set<Integer> bytecodeOffsets) {
        super(3);
        this.constType = constType;
        this.value = value;
        this.boolPermitted = boolPermitted;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private static VarType guessType(int val, boolean boolPermitted) {
        if (boolPermitted) {
            VarType constType = VarType.VARTYPE_BOOLEAN;
            if (val != 0 && val != 1) {
                constType = constType.copy(true);
            }
            return constType;
        }
        if (0 <= val && val <= 127) {
            return VarType.VARTYPE_BYTECHAR;
        }
        if (-128 <= val && val <= 127) {
            return VarType.VARTYPE_BYTE;
        }
        if (0 <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORTCHAR;
        }
        if (Short.MIN_VALUE <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORT;
        }
        if (0 <= val && val <= 65535) {
            return VarType.VARTYPE_CHAR;
        }
        return VarType.VARTYPE_INT;
    }

    @Override
    public Exprent copy() {
        return new ConstExprent(this.constType, this.value, (Set<Integer>)this.bytecode);
    }

    @Override
    public VarType getExprType() {
        return this.constType;
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents() {
        return new ArrayList<Exprent>();
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        boolean literal = DecompilerContext.getOption("lit");
        boolean ascii = DecompilerContext.getOption("asc");
        tracer.addMapping(this.bytecode);
        if (this.constType.type != 13 && this.value == null) {
            return new TextBuffer(ExprProcessor.getCastTypeName(this.constType));
        }
        switch (this.constType.type) {
            case 7: {
                return new TextBuffer(Boolean.toString((Integer)this.value != 0));
            }
            case 1: {
                Integer val = (Integer)this.value;
                String ret = ESCAPES.get(val);
                if (ret == null) {
                    char c = (char)val.intValue();
                    ret = c >= ' ' && c < '\u007f' || !ascii && InterpreterUtil.isPrintableUnicode(c) ? String.valueOf(c) : InterpreterUtil.charToUnicodeLiteral(c);
                }
                return new TextBuffer(ret).enclose("'", "'");
            }
            case 0: 
            case 4: 
            case 6: 
            case 15: 
            case 16: {
                String intfield;
                int ival = (Integer)this.value;
                if (literal) {
                    return new TextBuffer(this.value.toString());
                }
                if (ival == Integer.MAX_VALUE) {
                    intfield = "MAX_VALUE";
                } else if (ival == Integer.MIN_VALUE) {
                    intfield = "MIN_VALUE";
                } else {
                    return new TextBuffer(this.value.toString());
                }
                return new FieldExprent(intfield, "java/lang/Integer", true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            case 5: {
                String longfield;
                long lval = (Long)this.value;
                if (literal) {
                    return new TextBuffer(this.value.toString()).append("L");
                }
                if (lval == Long.MAX_VALUE) {
                    longfield = "MAX_VALUE";
                } else if (lval == Long.MIN_VALUE) {
                    longfield = "MIN_VALUE";
                } else {
                    return new TextBuffer(this.value.toString()).append("L");
                }
                return new FieldExprent(longfield, "java/lang/Long", true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            case 2: {
                String doublefield;
                double dval = (Double)this.value;
                if (literal) {
                    if (Double.isNaN(dval)) {
                        return new TextBuffer("0.0D / 0.0");
                    }
                    if (dval == Double.POSITIVE_INFINITY) {
                        return new TextBuffer("1.0D / 0.0");
                    }
                    if (dval == Double.NEGATIVE_INFINITY) {
                        return new TextBuffer("-1.0D / 0.0");
                    }
                    return new TextBuffer(this.value.toString()).append("D");
                }
                if (Double.isNaN(dval)) {
                    doublefield = "NaN";
                } else if (dval == Double.POSITIVE_INFINITY) {
                    doublefield = "POSITIVE_INFINITY";
                } else if (dval == Double.NEGATIVE_INFINITY) {
                    doublefield = "NEGATIVE_INFINITY";
                } else if (dval == Double.MAX_VALUE) {
                    doublefield = "MAX_VALUE";
                } else if (dval == Double.MIN_VALUE) {
                    doublefield = "MIN_VALUE";
                } else {
                    return new TextBuffer(this.value.toString()).append("D");
                }
                return new FieldExprent(doublefield, "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            case 3: {
                String floatfield;
                float fval = ((Float)this.value).floatValue();
                if (literal) {
                    if (Double.isNaN(fval)) {
                        return new TextBuffer("0.0F / 0.0");
                    }
                    if ((double)fval == Double.POSITIVE_INFINITY) {
                        return new TextBuffer("1.0F / 0.0");
                    }
                    if ((double)fval == Double.NEGATIVE_INFINITY) {
                        return new TextBuffer("-1.0F / 0.0");
                    }
                    return new TextBuffer(this.value.toString()).append("F");
                }
                if (Float.isNaN(fval)) {
                    floatfield = "NaN";
                } else if (fval == Float.POSITIVE_INFINITY) {
                    floatfield = "POSITIVE_INFINITY";
                } else if (fval == Float.NEGATIVE_INFINITY) {
                    floatfield = "NEGATIVE_INFINITY";
                } else if (fval == Float.MAX_VALUE) {
                    floatfield = "MAX_VALUE";
                } else if (fval == Float.MIN_VALUE) {
                    floatfield = "MIN_VALUE";
                } else {
                    return new TextBuffer(this.value.toString()).append("F");
                }
                return new FieldExprent(floatfield, "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            case 13: {
                return new TextBuffer("null");
            }
            case 8: {
                if (this.constType.equals(VarType.VARTYPE_STRING)) {
                    return new TextBuffer(ConstExprent.convertStringToJava(this.value.toString(), ascii)).enclose("\"", "\"");
                }
                if (!this.constType.equals(VarType.VARTYPE_CLASS)) break;
                String strval = this.value.toString();
                VarType classtype = strval.startsWith("[") ? new VarType(strval, false) : new VarType(strval, true);
                return new TextBuffer(ExprProcessor.getCastTypeName(classtype)).append(".class");
            }
        }
        throw new RuntimeException("invalid constant type");
    }

    private static String convertStringToJava(String value, boolean ascii) {
        char[] arr = value.toCharArray();
        StringBuilder buffer = new StringBuilder(arr.length);
        block10: for (char c : arr) {
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block10;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block10;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block10;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block10;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block10;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block10;
                }
                default: {
                    if (c >= ' ' && c < '\u007f' || !ascii && InterpreterUtil.isPrintableUnicode(c)) {
                        buffer.append(c);
                        continue block10;
                    }
                    buffer.append(InterpreterUtil.charToUnicodeLiteral(c));
                }
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ConstExprent)) {
            return false;
        }
        ConstExprent cn = (ConstExprent)o;
        return InterpreterUtil.equalObjects(this.constType, cn.getConstType()) && InterpreterUtil.equalObjects(this.value, cn.getValue());
    }

    public boolean hasBooleanValue() {
        switch (this.constType.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                Integer ival = (Integer)this.value;
                return ival == 0 || DecompilerContext.getOption("bto") && ival == 1;
            }
        }
        return false;
    }

    public boolean hasValueOne() {
        switch (this.constType.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                return (Integer)this.value == 1;
            }
            case 5: {
                return ((Long)this.value).intValue() == 1;
            }
            case 2: {
                return ((Double)this.value).intValue() == 1;
            }
            case 3: {
                return ((Float)this.value).intValue() == 1;
            }
        }
        return false;
    }

    public static ConstExprent getZeroConstant(int type) {
        switch (type) {
            case 4: {
                return new ConstExprent(VarType.VARTYPE_INT, new Integer(0), null);
            }
            case 5: {
                return new ConstExprent(VarType.VARTYPE_LONG, new Long(0L), null);
            }
            case 2: {
                return new ConstExprent(VarType.VARTYPE_DOUBLE, new Double(0.0), null);
            }
            case 3: {
                return new ConstExprent(VarType.VARTYPE_FLOAT, new Float(0.0f), null);
            }
        }
        throw new RuntimeException("Invalid argument!");
    }

    public VarType getConstType() {
        return this.constType;
    }

    public void setConstType(VarType constType) {
        this.constType = constType;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public boolean isBoolPermitted() {
        return this.boolPermitted;
    }
}

