/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class Exprent {
    public static final int MULTIPLE_USES = 1;
    public static final int SIDE_EFFECTS_FREE = 2;
    public static final int BOTH_FLAGS = 3;
    public static final int EXPRENT_ARRAY = 1;
    public static final int EXPRENT_ASSIGNMENT = 2;
    public static final int EXPRENT_CONST = 3;
    public static final int EXPRENT_EXIT = 4;
    public static final int EXPRENT_FIELD = 5;
    public static final int EXPRENT_FUNCTION = 6;
    public static final int EXPRENT_IF = 7;
    public static final int EXPRENT_INVOCATION = 8;
    public static final int EXPRENT_MONITOR = 9;
    public static final int EXPRENT_NEW = 10;
    public static final int EXPRENT_SWITCH = 11;
    public static final int EXPRENT_VAR = 12;
    public static final int EXPRENT_ANNOTATION = 13;
    public static final int EXPRENT_ASSERT = 14;
    public final int type;
    public final int id;
    public Set<Integer> bytecode = null;

    public Exprent(int type) {
        this.type = type;
        this.id = DecompilerContext.getCounterContainer().getCounterAndIncrement(1);
    }

    public int getPrecedence() {
        return 0;
    }

    public VarType getExprType() {
        return VarType.VARTYPE_VOID;
    }

    public int getExprentUse() {
        return 0;
    }

    public CheckTypesResult checkExprTypeBounds() {
        return new CheckTypesResult();
    }

    public boolean containsExprent(Exprent exprent) {
        ArrayList<Exprent> listTemp = new ArrayList<Exprent>(this.getAllExprents(true));
        listTemp.add(this);
        for (Exprent lstExpr : listTemp) {
            if (!lstExpr.equals(exprent)) continue;
            return true;
        }
        return false;
    }

    public List<Exprent> getAllExprents(boolean recursive) {
        List<Exprent> lst = this.getAllExprents();
        if (recursive) {
            for (int i = lst.size() - 1; i >= 0; --i) {
                lst.addAll(lst.get(i).getAllExprents(true));
            }
        }
        return lst;
    }

    public Set<VarVersionPair> getAllVariables() {
        List<Exprent> lstAllExprents = this.getAllExprents(true);
        lstAllExprents.add(this);
        HashSet<VarVersionPair> set = new HashSet<VarVersionPair>();
        for (Exprent expr : lstAllExprents) {
            if (expr.type != 12) continue;
            set.add(new VarVersionPair((VarExprent)expr));
        }
        return set;
    }

    public List<Exprent> getAllExprents() {
        throw new RuntimeException("not implemented");
    }

    public Exprent copy() {
        throw new RuntimeException("not implemented");
    }

    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        throw new RuntimeException("not implemented");
    }

    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
    }

    public void addBytecodeOffsets(Collection<Integer> bytecodeOffsets) {
        if (bytecodeOffsets != null && !bytecodeOffsets.isEmpty()) {
            if (this.bytecode == null) {
                this.bytecode = new HashSet<Integer>(bytecodeOffsets);
            } else {
                this.bytecode.addAll(bytecodeOffsets);
            }
        }
    }
}

