/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool.properties;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.difftool.properties.PropertiesTableModel;
import org.jetbrains.idea.svn.difftool.properties.PropertiesTableView;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SvnPropertiesDiffViewer
implements FrameDiffTool.DiffViewer {
    private static final Logger LOG = Logger.getInstance(SvnPropertiesDiffViewer.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final SvnPropertiesDiffRequest myRequest;
    @Nullable
    private final List<PropertyData> myProperties1;
    @Nullable
    private final List<PropertyData> myProperties2;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final TableView<PropertyDiffRecord> myTable;

    public SvnPropertiesDiffViewer(@NotNull DiffContext context, @NotNull SvnPropertiesDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "<init>"));
        }
        this.myProject = context.getProject();
        this.myContext = context;
        this.myRequest = request;
        List<String> titles = request.getContentTitles();
        List<DiffContent> contents = request.getContents();
        this.myProperties1 = SvnPropertiesDiffViewer.getProperties(contents.get(0));
        this.myProperties2 = SvnPropertiesDiffViewer.getProperties(contents.get(1));
        assert (this.myProperties1 != null || this.myProperties2 != null);
        PropertiesTableModel model = new PropertiesTableModel(titles.get(0), titles.get(1), (Disposable)this);
        this.myTable = new PropertiesTableView(model);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 1));
        this.myTable.setCellSelectionEnabled(false);
        this.myTable.setTableHeader(null);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        this.rediff();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbar();
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "init"));
        }
        return toolbarComponents;
    }

    public void dispose() {
    }

    public void rediff() {
        assert (this.myProperties1 != null || this.myProperties2 != null);
        HashMap before = new HashMap();
        HashMap after = new HashMap();
        if (this.myProperties1 != null) {
            for (PropertyData data : this.myProperties1) {
                before.put(data.getName(), data.getValue());
            }
        }
        if (this.myProperties2 != null) {
            for (PropertyData data : this.myProperties2) {
                after.put(data.getName(), data.getValue());
            }
        }
        ArrayList<PropertyDiffRecord> records = new ArrayList<PropertyDiffRecord>();
        for (String name : ContainerUtil.union(before.keySet(), after.keySet())) {
            records.add(SvnPropertiesDiffViewer.createRecord(name, (PropertyValue)before.get(name), (PropertyValue)after.get(name)));
        }
        ContainerUtil.sort(records, (Comparator)new Comparator<PropertyDiffRecord>(){

            @Override
            public int compare(PropertyDiffRecord o1, PropertyDiffRecord o2) {
                return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            }
        });
        PropertiesTableModel model = (PropertiesTableModel)((Object)this.myTable.getModel());
        model.setItems(records);
        model.updateRowHeights((JTable)this.myTable);
    }

    @Nullable
    private static PropertyDiffRecord createRecord(@NotNull String name, @Nullable PropertyValue value1, @Nullable PropertyValue value2) {
        String text2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "createRecord"));
        }
        assert (value1 != null || value2 != null);
        String text1 = value1 != null ? value1.toString() : null;
        String string = text2 = value2 != null ? value2.toString() : null;
        if (text1 != null) {
            text1 = StringUtil.convertLineSeparators((String)text1);
        }
        if (text2 != null) {
            text2 = StringUtil.convertLineSeparators((String)text2);
        }
        List<? extends LineFragment> fragments = SvnPropertiesDiffViewer.compareValues(text1, text2);
        return new PropertyDiffRecord(name, text1, text2, fragments);
    }

    @Nullable
    private static List<PropertyData> getProperties(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "getProperties"));
        }
        if (content instanceof SvnPropertiesDiffRequest.PropertyContent) {
            return ((SvnPropertiesDiffRequest.PropertyContent)content).getProperties();
        }
        return null;
    }

    @NotNull
    private static List<? extends LineFragment> compareValues(@Nullable CharSequence text1, @Nullable CharSequence text2) {
        int lines2;
        int lines1;
        block12: {
            List list;
            ComparisonManager comparisonManager;
            int MAX_ITEM_COUNT;
            block11: {
                assert (text1 != null || text2 != null);
                if (text1 == null) {
                    List<? extends LineFragment> list2 = SvnPropertiesDiffViewer.createEverythingChanged(0, text2.length(), 0, StringUtil.countNewLines((CharSequence)text2) + 1);
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "compareValues"));
                    }
                    return list2;
                }
                if (text2 == null) {
                    List<? extends LineFragment> list3 = SvnPropertiesDiffViewer.createEverythingChanged(text1.length(), 0, StringUtil.countNewLines((CharSequence)text1) + 1, 0);
                    if (list3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "compareValues"));
                    }
                    return list3;
                }
                MAX_ITEM_COUNT = 10000;
                Couple<Integer> couple1 = SvnPropertiesDiffViewer.countWordsAndLines(text1);
                Couple<Integer> couple2 = SvnPropertiesDiffViewer.countWordsAndLines(text1);
                int words1 = (Integer)couple1.first;
                int words2 = (Integer)couple2.first;
                lines1 = (Integer)couple1.second;
                lines2 = (Integer)couple2.second;
                comparisonManager = ComparisonManager.getInstance();
                if (words1 >= MAX_ITEM_COUNT || words2 >= MAX_ITEM_COUNT) break block11;
                List list4 = comparisonManager.squash(comparisonManager.compareLinesInner(text1, text2, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE));
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "compareValues"));
                }
                return list4;
            }
            try {
                if (lines1 >= MAX_ITEM_COUNT || lines2 >= MAX_ITEM_COUNT) break block12;
                list = comparisonManager.squash(comparisonManager.compareLines(text1, text2, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE));
            }
            catch (DiffTooBigException e) {
                LOG.warn((Throwable)e);
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "compareValues"));
            }
            return list;
        }
        List<? extends LineFragment> list = SvnPropertiesDiffViewer.createEverythingChanged(text1.length(), text2.length(), lines1, lines2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "compareValues"));
        }
        return list;
    }

    @NotNull
    private static List<? extends LineFragment> createEverythingChanged(int length1, int length2, int lines1, int lines2) {
        List<LineFragmentImpl> list = Collections.singletonList(new LineFragmentImpl(0, lines1, 0, lines2, 0, length1, 0, length2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "createEverythingChanged"));
        }
        return list;
    }

    @NotNull
    private static Couple<Integer> countWordsAndLines(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "countWordsAndLines"));
        }
        int words = 0;
        int lines = 1;
        boolean inWord = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++lines;
            }
            if (!inWord && TrimUtil.isAlpha((char)c)) {
                ++words;
                inWord = true;
                continue;
            }
            inWord = false;
        }
        Couple couple = Couple.of((Object)words, (Object)lines);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "countWordsAndLines"));
        }
        return couple;
    }

    @NotNull
    private List<AnAction> createToolbar() {
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "createToolbar"));
        }
        return arrayList;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    public static class PropertyDiffRecord {
        @NotNull
        private final String myName;
        @Nullable
        private final String myBefore;
        @Nullable
        private final String myAfter;
        @NotNull
        private final List<? extends LineFragment> myFragments;

        public PropertyDiffRecord(@NotNull String name, @Nullable String before, @Nullable String after, @NotNull List<? extends LineFragment> fragments) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer$PropertyDiffRecord", "<init>"));
            }
            if (fragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer$PropertyDiffRecord", "<init>"));
            }
            assert (before != null || after != null);
            this.myName = name;
            this.myBefore = before;
            this.myAfter = after;
            this.myFragments = fragments;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer$PropertyDiffRecord", "getName"));
            }
            return string;
        }

        @Nullable
        public String getBefore() {
            return this.myBefore;
        }

        @Nullable
        public String getAfter() {
            return this.myAfter;
        }

        @NotNull
        public List<? extends LineFragment> getFragments() {
            List<? extends LineFragment> list = this.myFragments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffViewer$PropertyDiffRecord", "getFragments"));
            }
            return list;
        }
    }
}

