/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match.tokens;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementRuleAliasConfigurable
implements UnnamedConfigurable {
    private StdArrangementRuleAliasToken myToken;
    private ArrangementRuleAliasesPanel myTokenRulesPanel;

    public ArrangementRuleAliasConfigurable(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull StdArrangementRuleAliasToken token) {
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasConfigurable", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasConfigurable", "<init>"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasConfigurable", "<init>"));
        }
        this.myToken = token;
        this.myTokenRulesPanel = new ArrangementRuleAliasesPanel(settingsManager, colorsProvider);
        this.myTokenRulesPanel.setRuleSequences(token.getDefinitionRules());
        ArrangementRuleAliasConfigurable.registerShortcut("Arrangement.Alias.Rule.Add", CommonShortcuts.getNew(), this.myTokenRulesPanel);
        ArrangementRuleAliasConfigurable.registerShortcut("Arrangement.Alias.Rule.Remove", CommonShortcuts.getDelete(), this.myTokenRulesPanel);
        ArrangementRuleAliasConfigurable.registerShortcut("Arrangement.Alias.Rule.Match.Condition.Move.Up", CommonShortcuts.MOVE_UP, this.myTokenRulesPanel);
        ArrangementRuleAliasConfigurable.registerShortcut("Arrangement.Alias.Rule.Match.Condition.Move.Down", CommonShortcuts.MOVE_DOWN, this.myTokenRulesPanel);
        CustomShortcutSet edit = new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0));
        ArrangementRuleAliasConfigurable.registerShortcut("Arrangement.Alias.Rule.Edit", (ShortcutSet)edit, this.myTokenRulesPanel);
    }

    private static void registerShortcut(@NotNull String actionId, @NotNull ShortcutSet shortcut, @NotNull JComponent component) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasConfigurable", "registerShortcut"));
        }
        if (shortcut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcut", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasConfigurable", "registerShortcut"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasConfigurable", "registerShortcut"));
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            action.registerCustomShortcutSet(shortcut, component);
        }
    }

    private static void unregisterShortcut(@NotNull String actionId, @NotNull JComponent component) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasConfigurable", "unregisterShortcut"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasConfigurable", "unregisterShortcut"));
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            action.unregisterCustomShortcutSet(component);
        }
    }

    @Nullable
    public JComponent createComponent() {
        return this.myTokenRulesPanel;
    }

    public boolean isModified() {
        List<StdArrangementMatchRule> newRules = this.myTokenRulesPanel.getRuleSequences();
        return !((Object)newRules).equals(this.myToken.getDefinitionRules());
    }

    public void apply() throws ConfigurationException {
        this.myToken.setDefinitionRules(this.myTokenRulesPanel.getRuleSequences());
    }

    public void reset() {
        this.myTokenRulesPanel.setRuleSequences(this.myToken.getDefinitionRules());
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)new Disposable(){

            public void dispose() {
                ArrangementRuleAliasConfigurable.unregisterShortcut("Arrangement.Alias.Rule.Add", ArrangementRuleAliasConfigurable.this.myTokenRulesPanel);
                ArrangementRuleAliasConfigurable.unregisterShortcut("Arrangement.Alias.Rule.Remove", ArrangementRuleAliasConfigurable.this.myTokenRulesPanel);
                ArrangementRuleAliasConfigurable.unregisterShortcut("Arrangement.Alias.Rule.Match.Condition.Move.Up", ArrangementRuleAliasConfigurable.this.myTokenRulesPanel);
                ArrangementRuleAliasConfigurable.unregisterShortcut("Arrangement.Alias.Rule.Match.Condition.Move.Down", ArrangementRuleAliasConfigurable.this.myTokenRulesPanel);
                ArrangementRuleAliasConfigurable.unregisterShortcut("Arrangement.Alias.Rule.Edit", ArrangementRuleAliasConfigurable.this.myTokenRulesPanel);
            }
        });
    }
}

