/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEmmetConfigurable
implements SearchableConfigurable,
Disposable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JBCheckBox myEnableEmmetJBCheckBox;
    private JBCheckBox myEnablePreviewJBCheckBox;
    private JPanel myFiltersListPanel;
    private JBCheckBox myEnableHrefAutodetectJBCheckBox;
    private Map<String, JBCheckBox> myFilterCheckboxes;

    public XmlEmmetConfigurable() {
        this.$$$setupUI$$$();
        this.myFilterCheckboxes = ContainerUtil.newHashMap();
        this.myEnableEmmetJBCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = XmlEmmetConfigurable.this.myEnableEmmetJBCheckBox.isSelected();
                XmlEmmetConfigurable.this.myEnablePreviewJBCheckBox.setEnabled(selected);
                XmlEmmetConfigurable.this.myFiltersListPanel.setEnabled(selected);
                XmlEmmetConfigurable.this.myEnableHrefAutodetectJBCheckBox.setEnabled(selected);
            }
        });
        this.myFiltersListPanel.setBorder(IdeBorderFactory.createTitledBorder((String)XmlBundle.message((String)"emmet.filters.enabled.by.default", (Object[])new Object[0])));
        this.createFiltersCheckboxes();
    }

    public void createFiltersCheckboxes() {
        List<ZenCodingFilter> filters = ZenCodingFilter.getInstances();
        GridBagLayout layoutManager = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.myFiltersListPanel.setLayout(layoutManager);
        int i = 0;
        while (i < filters.size()) {
            ZenCodingFilter filter = filters.get(i);
            JBCheckBox checkBox = new JBCheckBox(filter.getDisplayName());
            this.myFilterCheckboxes.put(filter.getSuffix(), checkBox);
            constraints.gridy = i++;
            this.myFiltersListPanel.add((Component)checkBox, constraints);
        }
        this.myFiltersListPanel.revalidate();
    }

    public void dispose() {
        this.myFilterCheckboxes.clear();
        this.myFilterCheckboxes = null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        return emmetOptions.isEmmetEnabled() != this.myEnableEmmetJBCheckBox.isSelected() || emmetOptions.isPreviewEnabled() != this.myEnablePreviewJBCheckBox.isSelected() || emmetOptions.isHrefAutoDetectEnabled() != this.myEnableHrefAutodetectJBCheckBox.isSelected() || !((Object)emmetOptions.getFiltersEnabledByDefault()).equals(this.enabledFilters());
    }

    public void apply() throws ConfigurationException {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        emmetOptions.setEmmetEnabled(this.myEnableEmmetJBCheckBox.isSelected());
        emmetOptions.setPreviewEnabled(this.myEnablePreviewJBCheckBox.isSelected());
        emmetOptions.setHrefAutoDetectEnabled(this.myEnableHrefAutodetectJBCheckBox.isSelected());
        emmetOptions.setFiltersEnabledByDefault(this.enabledFilters());
    }

    public void reset() {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        this.myEnableEmmetJBCheckBox.setSelected(emmetOptions.isEmmetEnabled());
        this.myEnablePreviewJBCheckBox.setEnabled(emmetOptions.isEmmetEnabled());
        this.myEnablePreviewJBCheckBox.setSelected(emmetOptions.isPreviewEnabled());
        this.myEnableHrefAutodetectJBCheckBox.setEnabled(emmetOptions.isEmmetEnabled());
        this.myEnableHrefAutodetectJBCheckBox.setSelected(emmetOptions.isHrefAutoDetectEnabled());
        Set<String> enabledByDefault = emmetOptions.getFiltersEnabledByDefault();
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            String filterSuffix = filter.getSuffix();
            JBCheckBox checkBox = this.myFilterCheckboxes.get(filterSuffix);
            if (checkBox == null) continue;
            checkBox.setSelected(enabledByDefault.contains(filterSuffix));
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    private Set<String> enabledFilters() {
        HashSet result = ContainerUtil.newHashSet();
        for (Map.Entry<String, JBCheckBox> checkbox : this.myFilterCheckboxes.entrySet()) {
            if (!checkbox.getValue().isSelected()) continue;
            result.add(checkbox.getKey());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/XmlEmmetConfigurable", "enabledFilters"));
        }
        return hashSet;
    }

    @Nls
    public String getDisplayName() {
        return "HTML";
    }

    @Nullable
    public String getHelpTopic() {
        return XmlBundle.message((String)"emmet.configuration.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        if ("xml.emmet" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/XmlEmmetConfigurable", "getId"));
        }
        return "xml.emmet";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableEmmetJBCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("messages/XmlBundle").getString("emmet.enable.label"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myEnablePreviewJBCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/XmlBundle").getString("emmet.enable.preview"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myFiltersListPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myEnableHrefAutodetectJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/XmlBundle").getString("emmet.href.autodetect"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

