/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.BasePainter;
import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.MultiFilePainter;
import com.intellij.codeEditor.printing.PageSizes;
import com.intellij.codeEditor.printing.PrintDialog;
import com.intellij.codeEditor.printing.PrintSettings;
import com.intellij.codeEditor.printing.TextPainter;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PrintManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeEditor.printing.PrintManager");

    PrintManager() {
    }

    public static void executePrint(DataContext dataContext) {
        BasePainter painter;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDirectory[] psiDirectory = new PsiDirectory[1];
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement instanceof PsiDirectory) {
            psiDirectory[0] = (PsiDirectory)psiElement;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        String[] shortFileName = new String[1];
        String[] directoryName = new String[1];
        if (psiFile != null || psiDirectory[0] != null) {
            if (psiFile != null) {
                shortFileName[0] = psiFile.getName();
                if (psiDirectory[0] == null) {
                    psiDirectory[0] = psiFile.getContainingDirectory();
                }
            }
            if (psiDirectory[0] != null) {
                directoryName[0] = psiDirectory[0].getVirtualFile().getPresentableUrl();
            }
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        String text = null;
        if (editor != null) {
            text = editor.getSelectionModel().hasSelection() ? CodeEditorBundle.message("print.selected.text.radio", new Object[0]) : (psiFile == null ? "Console text" : null);
        }
        PrintDialog printDialog = new PrintDialog(shortFileName[0], directoryName[0], text, project);
        printDialog.reset();
        if (!printDialog.showAndGet()) {
            return;
        }
        printDialog.apply();
        PageFormat pageFormat = PrintManager.createPageFormat();
        PrintSettings printSettings = PrintSettings.getInstance();
        if (printSettings.getPrintScope() != 4) {
            TextPainter textPainter;
            if (psiFile == null && editor == null) {
                return;
            }
            TextPainter textPainter2 = textPainter = psiFile != null ? PrintManager.initTextPainter(psiFile, editor) : PrintManager.initTextPainter((DocumentEx)editor.getDocument(), project);
            if (textPainter == null) {
                return;
            }
            if (printSettings.getPrintScope() == 2 && editor != null && editor.getSelectionModel().hasSelection()) {
                textPainter.setSegment(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
            }
            painter = textPainter;
        } else {
            ArrayList filesList = ContainerUtil.newArrayList();
            boolean isRecursive = printSettings.isIncludeSubdirectories();
            PrintManager.addToPsiFileList(psiDirectory[0], filesList, isRecursive);
            painter = new MultiFilePainter(filesList);
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        try {
            printerJob.setPrintable(painter, pageFormat);
            if (!printerJob.printDialog()) {
                return;
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, CodeEditorBundle.message("print.progress", new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeEditor/printing/PrintManager$1", "run"));
                }
                try {
                    painter.setProgress(indicator);
                    printerJob.print();
                }
                catch (ProcessCanceledException e) {
                    LOG.info("Cancelled");
                    printerJob.cancel();
                }
                catch (PrinterException e) {
                    Notifications.Bus.notify((Notification)new Notification("Print", CommonBundle.getErrorTitle(), e.getMessage(), NotificationType.ERROR));
                    LOG.warn((Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    painter.dispose();
                }
            }
        });
    }

    private static void addToPsiFileList(PsiDirectory psiDirectory, List<Pair<PsiFile, Editor>> filesList, boolean isRecursive) {
        PsiFile[] files;
        for (PsiFile psiFile : files = psiDirectory.getFiles()) {
            filesList.add((Pair<PsiFile, Editor>)Pair.create((Object)psiFile, (Object)PsiUtilBase.findEditor((PsiElement)psiFile)));
        }
        if (isRecursive) {
            for (PsiFile psiFile : psiDirectory.getSubdirectories()) {
                if (".idea".equals(psiFile.getName())) continue;
                PrintManager.addToPsiFileList((PsiDirectory)psiFile, filesList, true);
            }
        }
    }

    private static PageFormat createPageFormat() {
        PrintSettings printSettings = PrintSettings.getInstance();
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        String paperSize = printSettings.PAPER_SIZE;
        double paperWidth = PageSizes.getWidth(paperSize) * 72.0;
        double paperHeight = PageSizes.getHeight(paperSize) * 72.0;
        double leftMargin = printSettings.LEFT_MARGIN * 72.0f;
        double rightMargin = printSettings.RIGHT_MARGIN * 72.0f;
        double topMargin = printSettings.TOP_MARGIN * 72.0f;
        double bottomMargin = printSettings.BOTTOM_MARGIN * 72.0f;
        paper.setSize(paperWidth, paperHeight);
        if (printSettings.PORTRAIT_LAYOUT) {
            pageFormat.setOrientation(1);
            paper.setImageableArea(leftMargin, topMargin, paperWidth -= leftMargin + rightMargin, paperHeight -= topMargin + bottomMargin);
        } else {
            pageFormat.setOrientation(0);
            paper.setImageableArea(rightMargin, topMargin, paperWidth -= topMargin + bottomMargin, paperHeight -= leftMargin + rightMargin);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    static TextPainter initTextPainter(final PsiFile psiFile, final Editor editor) {
        return (TextPainter)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TextPainter>(){

            public TextPainter compute() {
                return PrintManager.doInitTextPainter(psiFile, editor);
            }
        });
    }

    private static TextPainter doInitTextPainter(PsiFile psiFile, Editor editor) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        DocumentEx doc = (DocumentEx)PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)psiFile.getProject(), (VirtualFile)virtualFile);
        highlighter.setText(doc.getCharsSequence());
        return new TextPainter(doc, highlighter, virtualFile.getPresentableUrl(), virtualFile.getPresentableName(), psiFile, psiFile.getFileType(), editor);
    }

    private static TextPainter initTextPainter(final @NotNull DocumentEx doc, final Project project) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/codeEditor/printing/PrintManager", "initTextPainter"));
        }
        final TextPainter[] res = new TextPainter[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                res[0] = PrintManager.doInitTextPainter(doc, project);
            }
        });
        return res[0];
    }

    private static TextPainter doInitTextPainter(@NotNull DocumentEx doc, Project project) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/codeEditor/printing/PrintManager", "doInitTextPainter"));
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)project, (String)"unknown");
        highlighter.setText(doc.getCharsSequence());
        return new TextPainter(doc, highlighter, "unknown", "unknown", project, (FileType)FileTypes.PLAIN_TEXT, null);
    }
}

