/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ConditionChecker;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ConditionCheckManager", storages={@Storage(id="dir", file="$PROJECT_CONFIG_DIR$/checker.xml", scheme=StorageScheme.DIRECTORY_BASED), @Storage(file="$PROJECT_FILE$")})
public class ConditionCheckManager
implements PersistentStateComponent<State> {
    private State state;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ConditionCheckManager");
    private final List<ConditionChecker> myIsNullCheckMethods = new ArrayList<ConditionChecker>();
    private final List<ConditionChecker> myIsNotNullCheckMethods = new ArrayList<ConditionChecker>();
    private final List<ConditionChecker> myAssertIsNullMethods = new ArrayList<ConditionChecker>();
    private final List<ConditionChecker> myAssertIsNotNullMethods = new ArrayList<ConditionChecker>();
    private final List<ConditionChecker> myAssertTrueMethods = new ArrayList<ConditionChecker>();
    private final List<ConditionChecker> myAssertFalseMethods = new ArrayList<ConditionChecker>();

    public static ConditionCheckManager getInstance(Project project) {
        return (ConditionCheckManager)ServiceManager.getService((Project)project, ConditionCheckManager.class);
    }

    public void setIsNullCheckMethods(List<ConditionChecker> methodConditionChecks) {
        this.myIsNullCheckMethods.clear();
        this.myIsNullCheckMethods.addAll(methodConditionChecks);
    }

    public void setIsNotNullCheckMethods(List<ConditionChecker> methodConditionChecks) {
        this.myIsNotNullCheckMethods.clear();
        this.myIsNotNullCheckMethods.addAll(methodConditionChecks);
    }

    public void setAssertIsNullMethods(List<ConditionChecker> methodConditionChecks) {
        this.myAssertIsNullMethods.clear();
        this.myAssertIsNullMethods.addAll(methodConditionChecks);
    }

    public void setAssertIsNotNullMethods(List<ConditionChecker> methodConditionChecks) {
        this.myAssertIsNotNullMethods.clear();
        this.myAssertIsNotNullMethods.addAll(methodConditionChecks);
    }

    public void setAssertTrueMethods(List<ConditionChecker> psiMethodWrappers) {
        this.myAssertTrueMethods.clear();
        this.myAssertTrueMethods.addAll(psiMethodWrappers);
    }

    public void setAssertFalseMethods(List<ConditionChecker> psiMethodWrappers) {
        this.myAssertFalseMethods.clear();
        this.myAssertFalseMethods.addAll(psiMethodWrappers);
    }

    public List<ConditionChecker> getIsNullCheckMethods() {
        return this.myIsNullCheckMethods;
    }

    public List<ConditionChecker> getIsNotNullCheckMethods() {
        return this.myIsNotNullCheckMethods;
    }

    public List<ConditionChecker> getAssertIsNullMethods() {
        return this.myAssertIsNullMethods;
    }

    public List<ConditionChecker> getAssertIsNotNullMethods() {
        return this.myAssertIsNotNullMethods;
    }

    public List<ConditionChecker> getAssertFalseMethods() {
        return this.myAssertFalseMethods;
    }

    public List<ConditionChecker> getAssertTrueMethods() {
        return this.myAssertTrueMethods;
    }

    public State getState() {
        State state = new State();
        ConditionCheckManager.loadMethodChecksToState(state.myIsNullCheckMethods, this.myIsNullCheckMethods);
        ConditionCheckManager.loadMethodChecksToState(state.myIsNotNullCheckMethods, this.myIsNotNullCheckMethods);
        ConditionCheckManager.loadMethodChecksToState(state.myAssertIsNullMethods, this.myAssertIsNullMethods);
        ConditionCheckManager.loadMethodChecksToState(state.myAssertIsNotNullMethods, this.myAssertIsNotNullMethods);
        ConditionCheckManager.loadMethodChecksToState(state.myAssertTrueMethods, this.myAssertTrueMethods);
        ConditionCheckManager.loadMethodChecksToState(state.myAssertFalseMethods, this.myAssertFalseMethods);
        return state;
    }

    private static void loadMethodChecksToState(List<String> listToLoadTo, List<ConditionChecker> listToLoadFrom) {
        for (ConditionChecker checker : listToLoadFrom) {
            listToLoadTo.add(checker.toString());
        }
    }

    public void loadState(State state) {
        this.state = state;
        ConditionCheckManager.loadMethods(this.myIsNullCheckMethods, state.myIsNullCheckMethods, ConditionChecker.Type.IS_NULL_METHOD);
        ConditionCheckManager.loadMethods(this.myIsNotNullCheckMethods, state.myIsNotNullCheckMethods, ConditionChecker.Type.IS_NOT_NULL_METHOD);
        ConditionCheckManager.loadMethods(this.myAssertIsNullMethods, state.myAssertIsNullMethods, ConditionChecker.Type.ASSERT_IS_NULL_METHOD);
        ConditionCheckManager.loadMethods(this.myAssertIsNotNullMethods, state.myAssertIsNotNullMethods, ConditionChecker.Type.ASSERT_IS_NOT_NULL_METHOD);
        ConditionCheckManager.loadMethods(this.myAssertTrueMethods, state.myAssertTrueMethods, ConditionChecker.Type.ASSERT_TRUE_METHOD);
        ConditionCheckManager.loadMethods(this.myAssertFalseMethods, state.myAssertFalseMethods, ConditionChecker.Type.ASSERT_FALSE_METHOD);
    }

    private static void loadMethods(List<ConditionChecker> listToLoadTo, List<String> listToLoadFrom, ConditionChecker.Type type) {
        listToLoadTo.clear();
        for (String setting : listToLoadFrom) {
            try {
                listToLoadTo.add(new ConditionChecker.FromConfigBuilder(setting, type).build());
            }
            catch (Exception e) {
                LOG.error("Problem occurred while attempting to load Condition Check from configuration file. " + e.getMessage());
            }
        }
    }

    @Nullable
    public static ConditionChecker findConditionChecker(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ConditionCheckManager", "findConditionChecker"));
        }
        ConditionCheckManager instance = ConditionCheckManager.getInstance(method.getProject());
        ConditionChecker checker = ConditionCheckManager.methodMatches(method, instance.getIsNullCheckMethods());
        if (checker == null) {
            checker = ConditionCheckManager.methodMatches(method, instance.getIsNotNullCheckMethods());
        }
        if (checker == null) {
            checker = ConditionCheckManager.methodMatches(method, instance.getAssertIsNullMethods());
        }
        if (checker == null) {
            checker = ConditionCheckManager.methodMatches(method, instance.getAssertIsNotNullMethods());
        }
        if (checker == null) {
            checker = ConditionCheckManager.methodMatches(method, instance.getAssertTrueMethods());
        }
        if (checker == null) {
            checker = ConditionCheckManager.methodMatches(method, instance.getAssertFalseMethods());
        }
        return checker;
    }

    private static ConditionChecker methodMatches(PsiMethod psiMethod, List<ConditionChecker> checkers) {
        for (ConditionChecker checker : checkers) {
            if (!checker.matchesPsiMethod(psiMethod)) continue;
            return checker;
        }
        return null;
    }

    public static class State {
        public List<String> myIsNullCheckMethods = new ArrayList<String>();
        public List<String> myIsNotNullCheckMethods = new ArrayList<String>();
        public List<String> myAssertIsNullMethods = new ArrayList<String>();
        public List<String> myAssertIsNotNullMethods = new ArrayList<String>();
        public List<String> myAssertTrueMethods = new ArrayList<String>();
        public List<String> myAssertFalseMethods = new ArrayList<String>();
    }
}

