/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeAction;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsAction
extends AnAction {
    @NonNls
    private static final String HELP_ID = "editing.manageImports";

    public void actionPerformed(AnActionEvent event) {
        OptimizeImportsAction.actionPerformedImpl(event.getDataContext());
    }

    public static void actionPerformedImpl(DataContext dataContext) {
        PsiDirectory dir;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = BaseCodeInsightAction.getInjectedEditor(project, (Editor)CommonDataKeys.EDITOR.getData(dataContext));
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        PsiFile file = null;
        if (editor != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            dir = file.getContainingDirectory();
        } else {
            if (files != null && ReformatCodeAction.containsAtLeastOneFile(files)) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files);
                if (!operationStatus.hasReadonlyFiles()) {
                    new OptimizeImportsProcessor(project, ReformatCodeAction.convertToPsiFiles(files, project), null).run();
                }
                return;
            }
            Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
            Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
            if (projectContext != null || moduleContext != null) {
                boolean hasChanges;
                String text;
                if (moduleContext != null) {
                    text = CodeInsightBundle.message((String)"process.scope.module", (Object[])new Object[]{moduleContext.getName()});
                    hasChanges = FormatChangedTextUtil.hasChanges(moduleContext);
                } else {
                    text = CodeInsightBundle.message((String)"process.scope.project", (Object[])new Object[]{projectContext.getPresentableUrl()});
                    hasChanges = FormatChangedTextUtil.hasChanges(projectContext);
                }
                OptimizeImportsDialog dialog = new OptimizeImportsDialog(project, text, hasChanges);
                if (!dialog.showAndGet()) {
                    return;
                }
                if (moduleContext != null) {
                    new OptimizeImportsProcessor(project, moduleContext).run();
                } else {
                    new OptimizeImportsProcessor(projectContext).run();
                }
                return;
            }
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                return;
            }
            if (element instanceof PsiDirectoryContainer) {
                dir = ((PsiDirectoryContainer)element).getDirectories()[0];
            } else if (element instanceof PsiDirectory) {
                dir = (PsiDirectory)element;
            } else {
                file = element.getContainingFile();
                if (file == null) {
                    return;
                }
                dir = file.getContainingDirectory();
            }
        }
        boolean processDirectory = false;
        boolean processOnlyVcsChangedFiles = false;
        if (!ApplicationManager.getApplication().isUnitTestMode() && file == null && dir != null) {
            String message = CodeInsightBundle.message((String)"process.scope.directory", (Object[])new Object[]{dir.getName()});
            OptimizeImportsDialog dialog = new OptimizeImportsDialog(project, message, FormatChangedTextUtil.hasChanges(dir));
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            processDirectory = true;
            processOnlyVcsChangedFiles = dialog.isProcessOnlyVcsChangedFiles();
        }
        if (processDirectory) {
            new OptimizeImportsProcessor(project, dir, true, processOnlyVcsChangedFiles).run();
        } else {
            new OptimizeImportsProcessor(project, file).run();
        }
    }

    public void update(AnActionEvent event) {
        if (!LanguageImportStatements.INSTANCE.hasAnyExtensions()) {
            event.getPresentation().setVisible(false);
            return;
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Editor editor = BaseCodeInsightAction.getInjectedEditor(project, (Editor)CommonDataKeys.EDITOR.getData(dataContext), false);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null || !OptimizeImportsAction.isOptimizeImportsAvailable(file)) {
                presentation.setEnabled(false);
                return;
            }
        } else if (files != null && ReformatCodeAction.containsAtLeastOneFile(files)) {
            boolean anyHasOptimizeImports = false;
            for (VirtualFile virtualFile : files) {
                PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (file == null) {
                    presentation.setEnabled(false);
                    return;
                }
                if (!OptimizeImportsAction.isOptimizeImportsAvailable(file)) continue;
                anyHasOptimizeImports = true;
            }
            if (!anyHasOptimizeImports) {
                presentation.setEnabled(false);
                return;
            }
        } else if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(dataContext) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext) == null) {
            PsiFile file;
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                presentation.setEnabled(false);
                return;
            }
            if (!(element instanceof PsiDirectory || (file = element.getContainingFile()) != null && OptimizeImportsAction.isOptimizeImportsAvailable(file))) {
                presentation.setEnabled(false);
                return;
            }
        }
        presentation.setEnabled(true);
    }

    private static boolean isOptimizeImportsAvailable(PsiFile file) {
        return !LanguageImportStatements.INSTANCE.forFile(file).isEmpty();
    }

    private static class OptimizeImportsDialog
    extends DialogWrapper {
        private final boolean myContextHasChanges;
        private final String myText;
        private JCheckBox myOnlyVcsCheckBox;
        private final LastRunReformatCodeOptionsProvider myLastRunOptions;

        OptimizeImportsDialog(Project project, String text, boolean hasChanges) {
            super(project, false);
            this.myText = text;
            this.myContextHasChanges = hasChanges;
            this.myLastRunOptions = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
            this.setOKButtonText(CodeInsightBundle.message((String)"reformat.code.accept.button.text", (Object[])new Object[0]));
            this.setTitle(CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]));
            this.init();
        }

        public boolean isProcessOnlyVcsChangedFiles() {
            return this.myOnlyVcsCheckBox.isSelected();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel();
            BoxLayout layout = new BoxLayout(panel, 1);
            panel.setLayout(layout);
            panel.add(new JLabel(this.myText));
            this.myOnlyVcsCheckBox = new JCheckBox(CodeInsightBundle.message((String)"process.scope.changed.files", (Object[])new Object[0]));
            boolean lastRunVcsChangedTextEnabled = this.myLastRunOptions.getLastTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
            this.myOnlyVcsCheckBox.setEnabled(this.myContextHasChanges);
            this.myOnlyVcsCheckBox.setSelected(this.myContextHasChanges && lastRunVcsChangedTextEnabled);
            panel.add(this.myOnlyVcsCheckBox);
            return panel;
        }
    }
}

