/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = "Rearrange code";
    public static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"process.rearrange.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance(RearrangeCodeProcessor.class);
    private SelectionModel mySelectionModel;

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        if (previousProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousProcessor", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
    }

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @NotNull SelectionModel selectionModel) {
        if (previousProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousProcessor", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull PsiFile file, @NotNull SelectionModel selectionModel) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(file.getProject(), file, PROGRESS_TEXT, COMMAND_NAME, false);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(file.getProject(), file, PROGRESS_TEXT, COMMAND_NAME, false);
    }

    public RearrangeCodeProcessor(@NotNull Project project, @NotNull PsiFile[] files, @NotNull String commandName, @Nullable Runnable postRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(project, files, PROGRESS_TEXT, commandName, postRunnable, false);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(final @NotNull PsiFile file, final boolean processChangedTextOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                try {
                    Collection<TextRange> ranges = RearrangeCodeProcessor.this.getRangesToFormat(file, processChangedTextOnly);
                    Document document = PsiDocumentManager.getInstance((Project)RearrangeCodeProcessor.this.myProject).getDocument(file);
                    if (document != null && Rearranger.EXTENSION.forLanguage(file.getLanguage()) != null) {
                        Runnable command = RearrangeCodeProcessor.this.prepareRearrangeCommand(file, ranges);
                        PsiDocumentManager.getInstance((Project)RearrangeCodeProcessor.this.myProject).doPostponedOperationsAndUnblockDocument(document);
                        try {
                            CommandProcessor.getInstance().executeCommand(RearrangeCodeProcessor.this.myProject, command, RearrangeCodeProcessor.COMMAND_NAME, null);
                        }
                        finally {
                            PsiDocumentManager.getInstance((Project)RearrangeCodeProcessor.this.myProject).commitDocument(document);
                        }
                    }
                    return true;
                }
                catch (FilesTooBigForDiffException e) {
                    RearrangeCodeProcessor.this.handleFileTooBigException(LOG, e, file);
                    return false;
                }
            }
        });
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        return futureTask;
    }

    @NotNull
    private Runnable prepareRearrangeCommand(final @NotNull PsiFile file, final @NotNull Collection<TextRange> ranges) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareRearrangeCommand"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareRearrangeCommand"));
        }
        final ArrangementEngine engine = (ArrangementEngine)ServiceManager.getService((Project)this.myProject, ArrangementEngine.class);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                engine.arrange(file, ranges);
                if (RearrangeCodeProcessor.this.getInfoCollector() != null) {
                    String info = engine.getUserNotificationInfo();
                    RearrangeCodeProcessor.this.getInfoCollector().setRearrangeCodeNotification(info);
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareRearrangeCommand"));
        }
        return runnable;
    }

    public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file, boolean processChangedTextOnly) throws FilesTooBigForDiffException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "getRangesToFormat"));
        }
        if (this.mySelectionModel != null) {
            return RearrangeCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        if (processChangedTextOnly) {
            return FormatChangedTextUtil.getChangedTextRanges(this.myProject, file);
        }
        return ContainerUtil.newSmartList((Object)file.getTextRange());
    }
}

