/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalDescriptorsUtil;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManagerImpl;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LocalInspectionsPass");
    public static final TextRange EMPTY_PRIORITY_RANGE = TextRange.EMPTY_RANGE;
    private static final Condition<PsiFile> FILE_FILTER = new Condition<PsiFile>(){

        public boolean value(PsiFile file) {
            return HighlightingLevelManager.getInstance(file.getProject()).shouldInspect((PsiElement)file);
        }
    };
    private final TextRange myPriorityRange;
    private final boolean myIgnoreSuppressed;
    private final ConcurrentMap<PsiFile, List<InspectionResult>> result;
    private static final String PRESENTABLE_NAME = DaemonBundle.message((String)"pass.inspection", (Object[])new Object[0]);
    private volatile List<HighlightInfo> myInfos;
    private final String myShortcutText;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionProfileWrapper myProfileWrapper;
    private boolean myFailFastOnAcquireReadAction;
    private final Map<TextRange, RangeMarker> ranges2markersCache;
    private final TransferToEDTQueue<Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator>> myTransferToEDTQueue;
    private final Set<Pair<TextRange, String>> emptyActionRegistered;

    public LocalInspectionsPass(@NotNull PsiFile file, @Nullable Document document, int startOffset, int endOffset, @NotNull TextRange priorityRange, boolean ignoreSuppressed, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        Keymap keymap;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "<init>"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "<init>"));
        }
        super(file.getProject(), document, PRESENTABLE_NAME, file, null, new TextRange(startOffset, endOffset), true, highlightInfoProcessor);
        this.result = ContainerUtil.newConcurrentMap();
        this.myInfos = Collections.emptyList();
        this.ranges2markersCache = new THashMap();
        this.myTransferToEDTQueue = new TransferToEDTQueue("Apply inspection results", (Processor)new Processor<Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator>>(){
            private final InspectionProfile inspectionProfile;
            private final InjectedLanguageManager ilManager;
            private final List<HighlightInfo> infos;
            private final PsiDocumentManager documentManager;
            {
                this.inspectionProfile = InspectionProjectProfileManager.getInstance(LocalInspectionsPass.this.myProject).getInspectionProfile();
                this.ilManager = InjectedLanguageManager.getInstance((Project)LocalInspectionsPass.this.myProject);
                this.infos = new ArrayList<HighlightInfo>(2);
                this.documentManager = PsiDocumentManager.getInstance((Project)LocalInspectionsPass.this.myProject);
            }

            public boolean process(Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator> trinity) {
                ProgressIndicator indicator = (ProgressIndicator)trinity.getThird();
                if (indicator.isCanceled()) {
                    return false;
                }
                ProblemDescriptor descriptor = (ProblemDescriptor)trinity.first;
                LocalInspectionToolWrapper tool = (LocalInspectionToolWrapper)((Object)trinity.second);
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement == null) {
                    return true;
                }
                PsiFile file = psiElement.getContainingFile();
                Document thisDocument = this.documentManager.getDocument(file);
                HighlightSeverity severity = this.inspectionProfile.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)file).getSeverity();
                this.infos.clear();
                LocalInspectionsPass.this.createHighlightsForDescriptor(this.infos, LocalInspectionsPass.this.emptyActionRegistered, this.ilManager, file, thisDocument, tool, severity, descriptor, psiElement);
                for (HighlightInfo info : this.infos) {
                    EditorColorsScheme colorsScheme = LocalInspectionsPass.this.getColorsScheme();
                    UpdateHighlightersUtil.addHighlighterToEditorIncrementally(LocalInspectionsPass.this.myProject, LocalInspectionsPass.this.myDocument, LocalInspectionsPass.this.myFile, LocalInspectionsPass.this.myRestrictRange.getStartOffset(), LocalInspectionsPass.this.myRestrictRange.getEndOffset(), info, colorsScheme, LocalInspectionsPass.this.getId(), LocalInspectionsPass.this.ranges2markersCache);
                }
                return true;
            }
        }, this.myProject.getDisposed(), 200);
        this.emptyActionRegistered = Collections.synchronizedSet(new THashSet());
        assert (file.isPhysical()) : "can't inspect non-physical file: " + file + "; " + file.getVirtualFile();
        this.myPriorityRange = priorityRange;
        this.myIgnoreSuppressed = ignoreSuppressed;
        this.setId(7);
        KeymapManager keymapManager = KeymapManager.getInstance();
        this.myShortcutText = keymapManager != null ? ((keymap = keymapManager.getActiveKeymap()) == null ? "" : "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap.getShortcuts("ShowErrorDescription")) + ")") : "";
        InspectionProfileWrapper profileToUse = InspectionProjectProfileManagerImpl.getInstanceImpl(this.myProject).getProfileWrapper();
        Function custom = (Function)file.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        if (custom != null) {
            profileToUse = (InspectionProfileWrapper)custom.fun((Object)profileToUse);
        }
        this.myProfileWrapper = profileToUse;
        assert (this.myProfileWrapper != null);
        this.mySeverityRegistrar = ((SeverityProvider)this.myProfileWrapper.getInspectionProfile().getProfileManager()).getSeverityRegistrar();
        this.setProgressLimit(600L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "collectInformationWithProgress"));
        }
        try {
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)this.myFile)) {
                return;
            }
            InspectionManager iManager = InspectionManager.getInstance((Project)this.myProject);
            InspectionProfileWrapper profile = this.myProfileWrapper;
            this.inspect(this.getInspectionTools(profile), iManager, true, true, DumbService.isDumb((Project)this.myProject), progress);
        }
        finally {
            this.disposeDescriptors();
        }
    }

    private void disposeDescriptors() {
        this.result.clear();
    }

    public void doInspectInBatch(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionManager iManager, @NotNull List<LocalInspectionToolWrapper> toolWrappers) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "doInspectInBatch"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "doInspectInBatch"));
        }
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "doInspectInBatch"));
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        this.inspect(new ArrayList<LocalInspectionToolWrapper>(toolWrappers), iManager, false, false, false, progress);
        this.addDescriptorsFromInjectedResults(iManager, context);
        List resultList = (List)this.result.get(this.myFile);
        if (resultList == null) {
            return;
        }
        for (InspectionResult inspectionResult : resultList) {
            LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
            for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                this.addDescriptors(toolWrapper, descriptor, context);
            }
        }
    }

    private void addDescriptors(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull ProblemDescriptor descriptor, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addDescriptors"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addDescriptors"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addDescriptors"));
        }
        InspectionToolPresentation toolPresentation = context.getPresentation(toolWrapper);
        LocalDescriptorsUtil.addProblemDescriptors(Collections.singletonList(descriptor), toolPresentation, this.myIgnoreSuppressed, context, (LocalInspectionTool)toolWrapper.getTool());
    }

    private void addDescriptorsFromInjectedResults(@NotNull InspectionManager iManager, @NotNull GlobalInspectionContextImpl context) {
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addDescriptorsFromInjectedResults"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addDescriptorsFromInjectedResults"));
        }
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        for (Map.Entry entry : this.result.entrySet()) {
            PsiFile file = (PsiFile)entry.getKey();
            if (file == this.myFile) continue;
            DocumentWindow documentRange = (DocumentWindow)documentManager.getDocument(file);
            List resultList = (List)entry.getValue();
            for (InspectionResult inspectionResult : resultList) {
                LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
                for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                    PsiElement psiElement = descriptor.getPsiElement();
                    if (psiElement == null || SuppressionUtil.inspectionResultSuppressed(psiElement, (LocalInspectionTool)toolWrapper.getTool())) continue;
                    List editables = ilManager.intersectWithAllEditableFragments(file, ((ProblemDescriptorBase)descriptor).getTextRange());
                    for (TextRange editable : editables) {
                        TextRange hostRange = documentRange.injectedToHost(editable);
                        QuickFix[] fixes = descriptor.getFixes();
                        LocalQuickFix[] localFixes = null;
                        if (fixes != null) {
                            localFixes = new LocalQuickFix[fixes.length];
                            for (int k = 0; k < fixes.length; ++k) {
                                QuickFix fix = fixes[k];
                                localFixes[k] = (LocalQuickFix)fix;
                            }
                        }
                        ProblemDescriptor patchedDescriptor = iManager.createProblemDescriptor((PsiElement)this.myFile, hostRange, descriptor.getDescriptionTemplate(), descriptor.getHighlightType(), true, localFixes);
                        this.addDescriptors(toolWrapper, patchedDescriptor, context);
                    }
                }
            }
        }
    }

    private void inspect(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, boolean checkDumbAwareness, @NotNull ProgressIndicator progress) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "inspect"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "inspect"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "inspect"));
        }
        this.myFailFastOnAcquireReadAction = failFastOnAcquireReadAction;
        if (toolWrappers.isEmpty()) {
            return;
        }
        ArrayList<PsiElement> inside = new ArrayList<PsiElement>();
        ArrayList<PsiElement> outside = new ArrayList<PsiElement>();
        Divider.divideInsideAndOutside(this.myFile, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myPriorityRange, inside, new ArrayList<ProperTextRange>(), outside, new ArrayList<ProperTextRange>(), true, FILE_FILTER);
        MultiMap<LocalInspectionToolWrapper, String> toolToLanguages = InspectionEngine.getToolsForElements(toolWrappers, checkDumbAwareness, inside, outside);
        this.setProgressLimit((long)toolToLanguages.size() * 2L);
        LocalInspectionToolSession session = new LocalInspectionToolSession(this.myFile, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset());
        List<InspectionContext> init = this.visitPriorityElementsAndInit(toolToLanguages, iManager, isOnTheFly, progress, inside, session, toolWrappers, checkDumbAwareness);
        this.visitRestElementsAndCleanup(progress, outside, session, init);
        this.inspectInjectedPsi(outside, isOnTheFly, progress, iManager, false, checkDumbAwareness, toolWrappers);
        progress.checkCanceled();
        this.myInfos = new ArrayList<HighlightInfo>();
        this.addHighlightsFromResults(this.myInfos, progress);
    }

    @NotNull
    private List<InspectionContext> visitPriorityElementsAndInit(@NotNull MultiMap<LocalInspectionToolWrapper, String> toolToLanguages, final @NotNull InspectionManager iManager, final boolean isOnTheFly, final @NotNull ProgressIndicator indicator, final @NotNull List<PsiElement> elements, final @NotNull LocalInspectionToolSession session, @NotNull List<LocalInspectionToolWrapper> wrappers, boolean checkDumbAwareness) {
        if (toolToLanguages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolToLanguages", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitPriorityElementsAndInit"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitPriorityElementsAndInit"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitPriorityElementsAndInit"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitPriorityElementsAndInit"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitPriorityElementsAndInit"));
        }
        if (wrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitPriorityElementsAndInit"));
        }
        final ArrayList<InspectionContext> init = new ArrayList<InspectionContext>();
        ArrayList entries = new ArrayList(toolToLanguages.entrySet());
        Processor<Map.Entry<LocalInspectionToolWrapper, Collection<String>>> processor = new Processor<Map.Entry<LocalInspectionToolWrapper, Collection<String>>>(){

            public boolean process(Map.Entry<LocalInspectionToolWrapper, Collection<String>> pair) {
                return LocalInspectionsPass.this.runToolOnElements(pair.getKey(), pair.getValue(), iManager, isOnTheFly, indicator, elements, session, init);
            }
        };
        boolean result = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(entries, indicator, this.myFailFastOnAcquireReadAction, processor);
        if (!result) {
            throw new ProcessCanceledException();
        }
        this.inspectInjectedPsi(elements, isOnTheFly, indicator, iManager, true, checkDumbAwareness, wrappers);
        ArrayList<InspectionContext> arrayList = init;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitPriorityElementsAndInit"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runToolOnElements(final @NotNull LocalInspectionToolWrapper toolWrapper, Collection<String> languages, @NotNull InspectionManager iManager, boolean isOnTheFly, final @NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull LocalInspectionToolSession session, @NotNull List<InspectionContext> init) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "runToolOnElements"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "runToolOnElements"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "runToolOnElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "runToolOnElements"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "runToolOnElements"));
        }
        if (init == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "init", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "runToolOnElements"));
        }
        indicator.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        final boolean[] applyIncrementally = new boolean[]{isOnTheFly};
        ProblemsHolder holder = new ProblemsHolder(iManager, this.myFile, isOnTheFly){

            public void registerProblem(@NotNull ProblemDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$3", "registerProblem"));
                }
                super.registerProblem(descriptor);
                if (applyIncrementally[0]) {
                    LocalInspectionsPass.this.addDescriptorIncrementally(descriptor, toolWrapper, indicator);
                }
            }
        };
        PsiElementVisitor visitor = InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session, elements, languages);
        List<InspectionContext> list = init;
        synchronized (list) {
            init.add(new InspectionContext(toolWrapper, holder, visitor, languages));
        }
        this.advanceProgress(1L);
        tool.inspectionFinished(session, holder);
        if (holder.hasResults()) {
            this.appendDescriptors(this.myFile, holder.getResults(), toolWrapper);
        }
        applyIncrementally[0] = false;
        return true;
    }

    private void visitRestElementsAndCleanup(final @NotNull ProgressIndicator indicator, final @NotNull List<PsiElement> elements, final @NotNull LocalInspectionToolSession session, @NotNull List<InspectionContext> init) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitRestElementsAndCleanup"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitRestElementsAndCleanup"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitRestElementsAndCleanup"));
        }
        if (init == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "init", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "visitRestElementsAndCleanup"));
        }
        Processor<InspectionContext> processor = new Processor<InspectionContext>(){

            public boolean process(InspectionContext context) {
                indicator.checkCanceled();
                ApplicationManager.getApplication().assertReadAccessAllowed();
                InspectionEngine.acceptElements(elements, context.visitor, context.languageIds);
                LocalInspectionsPass.this.advanceProgress(1L);
                ((LocalInspectionTool)context.tool.getTool()).inspectionFinished(session, context.holder);
                if (context.holder.hasResults()) {
                    LocalInspectionsPass.this.appendDescriptors(LocalInspectionsPass.this.myFile, context.holder.getResults(), context.tool);
                }
                return true;
            }
        };
        boolean result = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(init, indicator, this.myFailFastOnAcquireReadAction, processor);
        if (!result) {
            throw new ProcessCanceledException();
        }
    }

    void inspectInjectedPsi(@NotNull List<PsiElement> elements, final boolean onTheFly, final @NotNull ProgressIndicator indicator, final @NotNull InspectionManager iManager, final boolean inVisibleRange, final boolean checkDumbAwareness, final @NotNull List<LocalInspectionToolWrapper> wrappers) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "inspectInjectedPsi"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "inspectInjectedPsi"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "inspectInjectedPsi"));
        }
        if (wrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "inspectInjectedPsi"));
        }
        THashSet injected = new THashSet();
        for (PsiElement element : elements) {
            InjectedLanguageUtil.enumerate(element, this.myFile, false, new PsiLanguageInjectionHost.InjectedPsiVisitor((Set)injected){
                final /* synthetic */ Set val$injected;
                {
                    this.val$injected = set;
                }

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$5", "visit"));
                    }
                    if (places == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$5", "visit"));
                    }
                    this.val$injected.add(injectedPsi);
                }
            });
        }
        if (injected.isEmpty()) {
            return;
        }
        Processor<PsiFile> processor = new Processor<PsiFile>(){

            public boolean process(PsiFile injectedPsi) {
                LocalInspectionsPass.this.doInspectInjectedPsi(injectedPsi, onTheFly, indicator, iManager, inVisibleRange, wrappers, checkDumbAwareness);
                return true;
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(injected), indicator, this.myFailFastOnAcquireReadAction, processor)) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    private HighlightInfo highlightInfoFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightInfoType highlightInfoType, @NotNull String message, String toolTip, PsiElement psiElement) {
        if (problemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "highlightInfoFromDescriptor"));
        }
        if (highlightInfoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoType", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "highlightInfoFromDescriptor"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "highlightInfoFromDescriptor"));
        }
        TextRange textRange = ((ProblemDescriptorBase)problemDescriptor).getTextRange();
        if (textRange == null || psiElement == null) {
            return null;
        }
        boolean isFileLevel = psiElement instanceof PsiFile && textRange.equals((Object)psiElement.getTextRange());
        HighlightSeverity severity = highlightInfoType.getSeverity(psiElement);
        TextAttributes attributes = this.mySeverityRegistrar.getTextAttributesBySeverity(severity);
        HighlightInfo.Builder b = HighlightInfo.newHighlightInfo(highlightInfoType).range(psiElement, textRange.getStartOffset(), textRange.getEndOffset()).description(message).severity(severity);
        if (toolTip != null) {
            b.escapedToolTip(toolTip);
        }
        if (attributes != null) {
            b.textAttributes(attributes);
        }
        if (problemDescriptor.isAfterEndOfLine()) {
            b.endOfLine();
        }
        if (isFileLevel) {
            b.fileLevelAnnotation();
        }
        if (problemDescriptor.getProblemGroup() != null) {
            b.problemGroup(problemDescriptor.getProblemGroup());
        }
        return b.create();
    }

    private void addDescriptorIncrementally(@NotNull ProblemDescriptor descriptor, @NotNull LocalInspectionToolWrapper tool, @NotNull ProgressIndicator indicator) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addDescriptorIncrementally"));
        }
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addDescriptorIncrementally"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addDescriptorIncrementally"));
        }
        if (this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed(descriptor.getPsiElement(), (LocalInspectionTool)tool.getTool())) {
            return;
        }
        this.myTransferToEDTQueue.offer((Object)Trinity.create((Object)descriptor, (Object)((Object)tool), (Object)indicator));
    }

    private void appendDescriptors(@NotNull PsiFile file, @NotNull List<ProblemDescriptor> descriptors, @NotNull LocalInspectionToolWrapper tool) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "appendDescriptors"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "appendDescriptors"));
        }
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "appendDescriptors"));
        }
        for (ProblemDescriptor descriptor : descriptors) {
            if (descriptor != null) continue;
            LOG.error("null descriptor. all descriptors(" + descriptors.size() + "): " + descriptors + "; file: " + file + " (" + file.getVirtualFile() + "); tool: " + (Object)((Object)tool));
        }
        InspectionResult res = new InspectionResult(tool, descriptors);
        this.appendResult(file, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendResult(@NotNull PsiFile file, @NotNull InspectionResult res) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "appendResult"));
        }
        if (res == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "appendResult"));
        }
        List resultList = (List)this.result.get(file);
        if (resultList == null) {
            resultList = (List)ConcurrencyUtil.cacheOrGet(this.result, (Object)file, new ArrayList());
        }
        List list = resultList;
        synchronized (list) {
            resultList.add(res);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myInfos, this.getColorsScheme(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlightsFromResults(@NotNull List<HighlightInfo> outInfos, @NotNull ProgressIndicator indicator) {
        if (outInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outInfos", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addHighlightsFromResults"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "addHighlightsFromResults"));
        }
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        THashSet emptyActionRegistered = new THashSet();
        for (Map.Entry entry : this.result.entrySet()) {
            List resultList;
            indicator.checkCanceled();
            PsiFile file = (PsiFile)entry.getKey();
            Document documentRange = documentManager.getDocument(file);
            if (documentRange == null) continue;
            List list = resultList = (List)entry.getValue();
            synchronized (list) {
                for (InspectionResult inspectionResult : resultList) {
                    indicator.checkCanceled();
                    LocalInspectionToolWrapper tool = inspectionResult.tool;
                    HighlightSeverity severity = inspectionProfile.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)file).getSeverity();
                    for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                        indicator.checkCanceled();
                        PsiElement element = descriptor.getPsiElement();
                        this.createHighlightsForDescriptor(outInfos, (Set<Pair<TextRange, String>>)emptyActionRegistered, ilManager, file, documentRange, tool, severity, descriptor, element);
                    }
                }
            }
        }
    }

    private void createHighlightsForDescriptor(@NotNull List<HighlightInfo> outInfos, @NotNull Set<Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper tool, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor, PsiElement element) {
        if (outInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outInfos", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightsForDescriptor"));
        }
        if (emptyActionRegistered == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyActionRegistered", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightsForDescriptor"));
        }
        if (ilManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ilManager", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightsForDescriptor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightsForDescriptor"));
        }
        if (documentRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentRange", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightsForDescriptor"));
        }
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightsForDescriptor"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightsForDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightsForDescriptor"));
        }
        if (element == null) {
            return;
        }
        if (this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed(element, (LocalInspectionTool)tool.getTool())) {
            return;
        }
        HighlightInfoType level = ProblemDescriptorUtil.highlightTypeFromDescriptor(descriptor, severity, this.mySeverityRegistrar);
        HighlightInfo info = this.createHighlightInfo(descriptor, tool, level, emptyActionRegistered, element);
        if (info == null) {
            return;
        }
        if (file == this.myFile) {
            outInfos.add(info);
            return;
        }
        List editables = ilManager.intersectWithAllEditableFragments(file, new TextRange(info.startOffset, info.endOffset));
        for (TextRange editable : editables) {
            String toolTip;
            TextRange hostRange = ((DocumentWindow)documentRange).injectedToHost(editable);
            int start = hostRange.getStartOffset();
            int end = hostRange.getEndOffset();
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(info.type).range(element, start, end);
            String description = info.getDescription();
            if (description != null) {
                builder.description(description);
            }
            if ((toolTip = info.getToolTip()) != null) {
                builder.escapedToolTip(toolTip);
            }
            HighlightInfo patched = builder.createUnconditionally();
            if (patched.startOffset == patched.endOffset && info.startOffset != info.endOffset) continue;
            patched.setFromInjection(true);
            LocalInspectionsPass.registerQuickFixes(tool, descriptor, patched, emptyActionRegistered);
            outInfos.add(patched);
        }
    }

    @Nullable
    private HighlightInfo createHighlightInfo(@NotNull ProblemDescriptor descriptor, @NotNull LocalInspectionToolWrapper tool, @NotNull HighlightInfoType level, @NotNull Set<Pair<TextRange, String>> emptyActionRegistered, @NotNull PsiElement element) {
        HighlightInfo highlightInfo;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightInfo"));
        }
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightInfo"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightInfo"));
        }
        if (emptyActionRegistered == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyActionRegistered", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "createHighlightInfo"));
        }
        String message = ProblemDescriptorUtil.renderDescriptionMessage((CommonProblemDescriptor)descriptor, element);
        HighlightDisplayKey key = HighlightDisplayKey.find((String)tool.getShortName());
        InspectionProfile inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key, (PsiElement)this.myFile)) {
            return null;
        }
        HighlightInfoType.HighlightInfoTypeImpl type = new HighlightInfoType.HighlightInfoTypeImpl(level.getSeverity(element), level.getAttributesKey());
        String plainMessage = message.startsWith("<html>") ? StringUtil.unescapeXml((String)XmlStringUtil.stripHtml((String)message).replaceAll("<[^>]*>", "")) : message;
        String link = " <a href=\"#inspection/" + tool.getShortName() + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a> " + this.myShortcutText;
        String tooltip = null;
        if (descriptor.showTooltip()) {
            tooltip = message.startsWith("<html>") ? XmlStringUtil.wrapInHtml((CharSequence)(XmlStringUtil.stripHtml((String)message) + link)) : XmlStringUtil.wrapInHtml((CharSequence)(XmlStringUtil.escapeString((String)message) + link));
        }
        if ((highlightInfo = this.highlightInfoFromDescriptor(descriptor, type, plainMessage, tooltip, element)) != null) {
            LocalInspectionsPass.registerQuickFixes(tool, descriptor, highlightInfo, emptyActionRegistered);
        }
        return highlightInfo;
    }

    private static void registerQuickFixes(@NotNull LocalInspectionToolWrapper tool, @NotNull ProblemDescriptor descriptor, @NotNull HighlightInfo highlightInfo, @NotNull Set<Pair<TextRange, String>> emptyActionRegistered) {
        HintAction hintAction;
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "registerQuickFixes"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "registerQuickFixes"));
        }
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "registerQuickFixes"));
        }
        if (emptyActionRegistered == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyActionRegistered", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "registerQuickFixes"));
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)tool.getShortName());
        boolean needEmptyAction = true;
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > 0) {
            for (int k = 0; k < fixes.length; ++k) {
                if (fixes[k] == null) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixWrapper.wrap(descriptor, k), key);
                needEmptyAction = false;
            }
        }
        HintAction hintAction2 = hintAction = descriptor instanceof ProblemDescriptorImpl ? ((ProblemDescriptorImpl)descriptor).getHintAction() : null;
        if (hintAction != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)hintAction, key);
            needEmptyAction = false;
        }
        if (((ProblemDescriptorBase)descriptor).getEnforcedTextAttributes() != null) {
            needEmptyAction = false;
        }
        if (needEmptyAction && emptyActionRegistered.add((Pair<TextRange, String>)Pair.create((Object)highlightInfo.getFixTextRange(), (Object)tool.getShortName()))) {
            EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(tool.getDisplayName());
            QuickFixAction.registerQuickFixAction(highlightInfo, emptyIntentionAction, key);
        }
    }

    @NotNull
    private static List<PsiElement> getElementsFrom(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "getElementsFrom"));
        }
        FileViewProvider viewProvider = file.getViewProvider();
        final LinkedHashSet<PsiFile> result = new LinkedHashSet<PsiFile>();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement child;
                ProgressManager.checkCanceled();
                if (child != null) {
                    for (child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                        child.accept((PsiElementVisitor)this);
                        result.add(child);
                    }
                }
            }
        };
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(file.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            psiRoot.accept((PsiElementVisitor)visitor);
            result.add(psiRoot);
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>(result);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "getElementsFrom"));
        }
        return arrayList;
    }

    @NotNull
    List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "getInspectionTools"));
        }
        ArrayList<LocalInspectionToolWrapper> enabled = new ArrayList<LocalInspectionToolWrapper>();
        InspectionToolWrapper[] toolWrappers = profile.getInspectionTools((PsiElement)this.myFile);
        InspectionProfileWrapper.checkInspectionsDuplicates(toolWrappers);
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            String language;
            ProgressManager.checkCanceled();
            if (!profile.isToolEnabled(HighlightDisplayKey.find((String)toolWrapper.getShortName()), (PsiElement)this.myFile)) continue;
            LocalInspectionToolWrapper wrapper = null;
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                wrapper = (LocalInspectionToolWrapper)toolWrapper;
            } else if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionToolWrapper globalInspectionToolWrapper = (GlobalInspectionToolWrapper)toolWrapper;
                wrapper = globalInspectionToolWrapper.getSharedLocalInspectionToolWrapper();
            }
            if (wrapper == null || (language = wrapper.getLanguage()) != null && Language.findLanguageByID((String)language) == null || this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed((PsiElement)this.myFile, (LocalInspectionTool)wrapper.getTool())) continue;
            enabled.add(wrapper);
        }
        ArrayList<LocalInspectionToolWrapper> arrayList = enabled;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "getInspectionTools"));
        }
        return arrayList;
    }

    private void doInspectInjectedPsi(@NotNull PsiFile injectedPsi, final boolean isOnTheFly, final @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, final boolean inVisibleRange, @NotNull List<LocalInspectionToolWrapper> wrappers, boolean checkDumbAwareness) {
        if (injectedPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "doInspectInjectedPsi"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "doInspectInjectedPsi"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "doInspectInjectedPsi"));
        }
        if (wrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "doInspectInjectedPsi"));
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)injectedPsi.getProject()).getInjectionHost((PsiElement)injectedPsi);
        List<PsiElement> elements = LocalInspectionsPass.getElementsFrom(injectedPsi);
        if (elements.isEmpty()) {
            return;
        }
        MultiMap<LocalInspectionToolWrapper, String> toolToLanguages = InspectionEngine.getToolsForElements(wrappers, checkDumbAwareness, elements, Collections.<PsiElement>emptyList());
        for (Map.Entry pair : toolToLanguages.entrySet()) {
            indicator.checkCanceled();
            final LocalInspectionToolWrapper wrapper = (LocalInspectionToolWrapper)((Object)pair.getKey());
            LocalInspectionTool tool = (LocalInspectionTool)wrapper.getTool();
            if (host != null && this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed((PsiElement)host, tool)) continue;
            ProblemsHolder holder = new ProblemsHolder(iManager, injectedPsi, isOnTheFly){

                public void registerProblem(@NotNull ProblemDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$9", "registerProblem"));
                    }
                    super.registerProblem(descriptor);
                    if (isOnTheFly && inVisibleRange) {
                        LocalInspectionsPass.this.addDescriptorIncrementally(descriptor, wrapper, indicator);
                    }
                }
            };
            LocalInspectionToolSession injSession = new LocalInspectionToolSession(injectedPsi, 0, injectedPsi.getTextLength());
            Collection languages = (Collection)pair.getValue();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, injSession, elements, languages);
            tool.inspectionFinished(injSession, holder);
            List problems = holder.getResults();
            if (problems.isEmpty()) continue;
            this.appendDescriptors(injectedPsi, problems, wrapper);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list = this.myInfos;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass", "getInfos"));
        }
        return list;
    }

    private static class InspectionContext {
        @NotNull
        final LocalInspectionToolWrapper tool;
        @NotNull
        final ProblemsHolder holder;
        @NotNull
        final PsiElementVisitor visitor;
        @Nullable
        final Collection<String> languageIds;

        private InspectionContext(@NotNull LocalInspectionToolWrapper tool, @NotNull ProblemsHolder holder, @NotNull PsiElementVisitor visitor, @Nullable Collection<String> languageIds) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionContext", "<init>"));
            }
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionContext", "<init>"));
            }
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionContext", "<init>"));
            }
            this.tool = tool;
            this.holder = holder;
            this.visitor = visitor;
            this.languageIds = languageIds;
        }
    }

    private static class InspectionResult {
        @NotNull
        public final LocalInspectionToolWrapper tool;
        @NotNull
        public final List<ProblemDescriptor> foundProblems;

        private InspectionResult(@NotNull LocalInspectionToolWrapper tool, @NotNull List<ProblemDescriptor> foundProblems) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionResult", "<init>"));
            }
            if (foundProblems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundProblems", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionResult", "<init>"));
            }
            this.tool = tool;
            this.foundProblems = foundProblems;
        }
    }
}

