/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.ChainCompletionMethodCallLookupElement;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.sub.SubLookupElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.Nullable;

public final class ChainCompletionLookupElementUtil {
    private ChainCompletionLookupElementUtil() {
    }

    public static LookupElement createLookupElement(PsiMethod method, @Nullable TIntObjectHashMap<SubLookupElement> replaceElements) {
        if (method.isConstructor()) {
            return LookupElementBuilder.create((String)String.format("%s %s", "new", method.getContainingClass().getName()));
        }
        if (method.hasModifierProperty("static")) {
            return new ChainCompletionMethodCallLookupElement(method, replaceElements, false, true);
        }
        return new ChainCompletionMethodCallLookupElement(method, replaceElements);
    }

    public static String fillMethodParameters(PsiMethod method, @Nullable TIntObjectHashMap<SubLookupElement> replaceElements) {
        TIntObjectHashMap notNullReplaceElements = replaceElements == null ? new TIntObjectHashMap(0) : replaceElements;
        PsiParameter[] parameters = method.getParameterList().getParameters();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            PsiParameter parameter = parameters[i];
            SubLookupElement replaceElement = (SubLookupElement)notNullReplaceElements.get(i);
            if (replaceElement != null) {
                sb.append(replaceElement.getInsertString());
                continue;
            }
            sb.append(parameter.getName());
        }
        return sb.toString();
    }
}

