/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.psi.PsiExpression;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReferringObjectsValue
extends JavaValue {
    private static final long MAX_REFERRING = 100L;
    private final boolean myIsField;

    private JavaReferringObjectsValue(@Nullable JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean isField) {
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/debugger/actions/JavaReferringObjectsValue", "<init>"));
        }
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/debugger/actions/JavaReferringObjectsValue", "<init>"));
        }
        super(parent, valueDescriptor, evaluationContext, nodeManager, false);
        this.myIsField = isField;
    }

    public JavaReferringObjectsValue(@NotNull JavaValue javaValue, boolean isField) {
        if (javaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaValue", "com/intellij/debugger/actions/JavaReferringObjectsValue", "<init>"));
        }
        super(null, javaValue.getDescriptor(), javaValue.getEvaluationContext(), javaValue.getNodeManager(), false);
        this.myIsField = isField;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @Override
    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/actions/JavaReferringObjectsValue", "computeChildren"));
        }
        JavaReferringObjectsValue.scheduleCommand(this.getEvaluationContext(), node, new SuspendContextCommandImpl(this.getEvaluationContext().getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction() throws Exception {
                XValueChildrenList children = new XValueChildrenList();
                Value value = JavaReferringObjectsValue.this.getDescriptor().getValue();
                List<ObjectReference> references = ((ObjectReference)value).referringObjects(100L);
                int i = 1;
                for (final ObjectReference reference : references) {
                    ValueDescriptorImpl descriptor;
                    Field field = JavaReferringObjectsValue.findField(reference, value);
                    if (field != null) {
                        descriptor = new FieldDescriptorImpl(JavaReferringObjectsValue.this.getProject(), reference, field){

                            @Override
                            public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
                                return reference;
                            }
                        };
                        children.add((XNamedValue)new JavaReferringObjectsValue(null, descriptor, JavaReferringObjectsValue.this.getEvaluationContext(), JavaReferringObjectsValue.this.getNodeManager(), true));
                        ++i;
                        continue;
                    }
                    descriptor = new ValueDescriptorImpl(JavaReferringObjectsValue.this.getProject(), reference){

                        @Override
                        public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
                            return reference;
                        }

                        @Override
                        public String getName() {
                            return "Ref";
                        }

                        @Override
                        public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
                            return null;
                        }
                    };
                    children.add("Referrer " + i++, (XValue)new JavaReferringObjectsValue(null, descriptor, JavaReferringObjectsValue.this.getEvaluationContext(), JavaReferringObjectsValue.this.getNodeManager(), false));
                }
                node.addChildren(children, true);
            }
        });
    }

    @Override
    public void computePresentation(final @NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/actions/JavaReferringObjectsValue", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/debugger/actions/JavaReferringObjectsValue", "computePresentation"));
        }
        if (!this.myIsField) {
            super.computePresentation(node, place);
        } else {
            super.computePresentation(new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){

                @Override
                public void applyPresentation(@Nullable Icon icon, final @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                    if (valuePresenter == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePresenter", "com/intellij/debugger/actions/JavaReferringObjectsValue$2", "applyPresentation"));
                    }
                    node.setPresentation(icon, new XValuePresentation(){

                        @NotNull
                        public String getSeparator() {
                            if (" in " == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JavaReferringObjectsValue$2$1", "getSeparator"));
                            }
                            return " in ";
                        }

                        @Nullable
                        public String getType() {
                            return valuePresenter.getType();
                        }

                        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                            if (renderer == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/actions/JavaReferringObjectsValue$2$1", "renderValue"));
                            }
                            valuePresenter.renderValue(renderer);
                        }
                    }, hasChildren);
                }

                public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                    if (fullValueEvaluator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValueEvaluator", "com/intellij/debugger/actions/JavaReferringObjectsValue$2", "setFullValueEvaluator"));
                    }
                }

                public boolean isObsolete() {
                    return false;
                }
            }, place);
        }
    }

    private static Field findField(ObjectReference reference, Value value) {
        for (Field field : reference.referenceType().allFields()) {
            if (reference.getValue(field) != value) continue;
            return field;
        }
        return null;
    }

    @Override
    @Nullable
    public XValueModifier getModifier() {
        return null;
    }
}

