/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.LoopEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.BooleanValue;
import org.jetbrains.annotations.NotNull;

public class DoWhileStatementEvaluator
extends LoopEvaluator {
    private final Evaluator myConditionEvaluator;

    public DoWhileStatementEvaluator(@NotNull Evaluator conditionEvaluator, Evaluator bodyEvaluator, String labelName) {
        if (conditionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionEvaluator", "com/intellij/debugger/engine/evaluation/expression/DoWhileStatementEvaluator", "<init>"));
        }
        super(labelName, bodyEvaluator);
        this.myConditionEvaluator = new DisableGC(conditionEvaluator);
    }

    @Override
    public Modifier getModifier() {
        return this.myConditionEvaluator.getModifier();
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object value = context.getDebugProcess().getVirtualMachineProxy().mirrorOf();
        while (!this.body(context)) {
            value = this.myConditionEvaluator.evaluate(context);
            if (!(value instanceof BooleanValue)) {
                throw EvaluateExceptionUtil.BOOLEAN_EXPECTED;
            }
            if (((BooleanValue)value).booleanValue()) continue;
            break;
        }
        return value;
    }
}

