/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ClickListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerEditorImpl
extends CompletionEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.DebuggerEditorImpl");
    public static final char SEPARATOR = '\r';
    private final Project myProject;
    private PsiElement myContext;
    private PsiType myThisType;
    private final String myRecentsId;
    private final List<DocumentListener> myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private Document myCurrentDocument;
    private final JLabel myChooseFactory = new JLabel();
    private WeakReference<ListPopup> myPopup;
    private final PsiTreeChangeListener myPsiListener = new PsiTreeChangeAdapter(){

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/ui/DebuggerEditorImpl$1", "childRemoved"));
            }
            this.checkContext();
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/ui/DebuggerEditorImpl$1", "childReplaced"));
            }
            this.checkContext();
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/ui/DebuggerEditorImpl$1", "childMoved"));
            }
            this.checkContext();
        }

        private void checkContext() {
            PsiElement contextElement = DebuggerEditorImpl.this.getContext();
            if (contextElement == null || !contextElement.isValid()) {
                DebuggerContextImpl context;
                PsiElement newContextElement;
                DebuggerManagerEx manager = DebuggerManagerEx.getInstanceEx(DebuggerEditorImpl.this.myProject);
                if (manager == null) {
                    LOG.error("Cannot obtain debugger manager for project " + DebuggerEditorImpl.this.myProject);
                }
                DebuggerEditorImpl.this.setContext((newContextElement = PositionUtil.getContextElement((StackFrameContext)(context = manager.getContextManager().getContext()))) != null && newContextElement.isValid() ? newContextElement : null);
            }
        }
    };
    private CodeFragmentFactory myFactory;
    protected boolean myInitialFactory;

    public DebuggerEditorImpl(Project project, PsiElement context, String recentsId, CodeFragmentFactory factory) {
        this.myProject = project;
        this.myContext = context;
        this.myRecentsId = recentsId;
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener(this.myPsiListener);
        this.setFactory(factory);
        this.myInitialFactory = true;
        this.setFocusable(false);
        this.myChooseFactory.setToolTipText("Click to change the language");
        this.myChooseFactory.setBorder(new EmptyBorder(0, 3, 0, 3));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/ui/DebuggerEditorImpl$2", "onClick"));
                }
                ListPopup oldPopup = (ListPopup)SoftReference.dereference((Reference)DebuggerEditorImpl.this.myPopup);
                if (oldPopup != null && !oldPopup.isDisposed()) {
                    oldPopup.cancel();
                    DebuggerEditorImpl.this.myPopup = null;
                    return true;
                }
                if (DebuggerEditorImpl.this.myContext == null) {
                    return true;
                }
                ListPopup popup = DebuggerEditorImpl.this.createLanguagePopup();
                popup.showUnderneathOf((Component)DebuggerEditorImpl.this.myChooseFactory);
                DebuggerEditorImpl.this.myPopup = new WeakReference<ListPopup>(popup);
                return true;
            }
        }.installOn((Component)this.myChooseFactory);
    }

    private ListPopup createLanguagePopup() {
        DefaultActionGroup actions = new DefaultActionGroup();
        for (final CodeFragmentFactory fragmentFactory : DebuggerUtilsEx.getCodeFragmentFactories(this.myContext)) {
            actions.add(new AnAction(fragmentFactory.getFileType().getLanguage().getDisplayName(), null, fragmentFactory.getFileType().getIcon()){

                public void actionPerformed(AnActionEvent e) {
                    DebuggerEditorImpl.this.setFactory(fragmentFactory);
                    DebuggerEditorImpl.this.setText(DebuggerEditorImpl.this.getText());
                    IdeFocusManager.getInstance((Project)DebuggerEditorImpl.this.getProject()).requestFocus((Component)DebuggerEditorImpl.this, true);
                }
            });
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        return JBPopupFactory.getInstance().createActionGroupPopup("Choose language", (ActionGroup)actions, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myChooseFactory.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    protected TextWithImports createItem(Document document, Project project) {
        if (document != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                return this.createText(psiFile.getText(), ((JavaCodeFragment)psiFile).importsToString());
            }
        }
        return this.createText("");
    }

    protected TextWithImports createText(String text) {
        return this.createText(text, "");
    }

    protected abstract TextWithImports createText(String var1, String var2);

    public abstract JComponent getPreferredFocusedComponent();

    @Override
    public void setContext(@Nullable PsiElement context) {
        boolean many;
        this.myContext = context;
        List<CodeFragmentFactory> factories = DebuggerUtilsEx.getCodeFragmentFactories(context);
        boolean bl = many = factories.size() > 1;
        if (this.myInitialFactory) {
            this.myInitialFactory = false;
            this.setFactory(factories.get(0));
            this.myChooseFactory.setVisible(many);
        }
        this.myChooseFactory.setVisible(this.myChooseFactory.isVisible() || many);
        this.myChooseFactory.setEnabled(many && factories.contains(this.myFactory));
        this.updateEditorUi();
    }

    @Override
    public void setText(TextWithImports text) {
        this.doSetText(text);
        this.updateEditorUi();
    }

    protected abstract void doSetText(TextWithImports var1);

    protected abstract void updateEditorUi();

    @Override
    public PsiElement getContext() {
        return this.myContext;
    }

    protected Project getProject() {
        return this.myProject;
    }

    @Override
    public void requestFocus() {
        this.getPreferredFocusedComponent().requestFocus();
    }

    public void setThisType(PsiType thisType) {
        this.myThisType = thisType;
    }

    @Nullable
    protected Document createDocument(TextWithImports item) {
        PsiClass contextClass;
        LOG.assertTrue(this.myContext == null || this.myContext.isValid());
        if (item == null) {
            item = this.createText("");
        }
        JavaCodeFragment codeFragment = this.getCurrentFactory().createPresentationCodeFragment(item, this.myContext, this.getProject());
        codeFragment.forceResolveScope(GlobalSearchScope.allScope((Project)this.myProject));
        if (this.myThisType != null) {
            codeFragment.setThisType(this.myThisType);
        } else if (this.myContext != null && (contextClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myContext, (Class[])new Class[]{PsiClass.class})) != null) {
            PsiClassType contextType = JavaPsiFacade.getInstance((Project)codeFragment.getProject()).getElementFactory().createType(contextClass);
            codeFragment.setThisType((PsiType)contextType);
        }
        if (this.myCurrentDocument != null) {
            for (DocumentListener documentListener : this.myDocumentListeners) {
                this.myCurrentDocument.removeDocumentListener(documentListener);
            }
        }
        this.myCurrentDocument = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument((PsiFile)codeFragment);
        if (this.myCurrentDocument != null) {
            PsiDocumentManagerBase.cachePsi(this.myCurrentDocument, (PsiFile)codeFragment);
            for (DocumentListener documentListener : this.myDocumentListeners) {
                this.myCurrentDocument.addDocumentListener(documentListener);
            }
        }
        return this.myCurrentDocument;
    }

    @Override
    public String getRecentsId() {
        return this.myRecentsId;
    }

    public void addRecent(TextWithImports text) {
        if (this.getRecentsId() != null && text != null && !text.isEmpty()) {
            XDebuggerHistoryManager.getInstance(this.getProject()).addRecentExpression(this.getRecentsId(), TextWithImportsImpl.toXExpression(text));
        }
    }

    public void addDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.add(listener);
        if (this.myCurrentDocument != null) {
            this.myCurrentDocument.addDocumentListener(listener);
        }
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.remove(listener);
        if (this.myCurrentDocument != null) {
            this.myCurrentDocument.removeDocumentListener(listener);
        }
    }

    @Override
    public void dispose() {
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener(this.myPsiListener);
        this.myCurrentDocument = null;
    }

    @NotNull
    private static CodeFragmentFactory findAppropriateFactory(@NotNull TextWithImports text, @Nullable PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/debugger/ui/DebuggerEditorImpl", "findAppropriateFactory"));
        }
        for (CodeFragmentFactory factory : DebuggerUtilsEx.getCodeFragmentFactories(context)) {
            if (!factory.getFileType().equals(text.getFileType())) continue;
            CodeFragmentFactory codeFragmentFactory = factory;
            if (codeFragmentFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/DebuggerEditorImpl", "findAppropriateFactory"));
            }
            return codeFragmentFactory;
        }
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = DefaultCodeFragmentFactory.getInstance();
        if (defaultCodeFragmentFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/DebuggerEditorImpl", "findAppropriateFactory"));
        }
        return defaultCodeFragmentFactory;
    }

    protected void restoreFactory(TextWithImports text) {
        FileType fileType = text.getFileType();
        if (fileType == null) {
            return;
        }
        if (this.myContext == null) {
            return;
        }
        this.setFactory(DebuggerEditorImpl.findAppropriateFactory(text, this.myContext));
    }

    private void setFactory(@NotNull CodeFragmentFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/debugger/ui/DebuggerEditorImpl", "setFactory"));
        }
        this.myFactory = factory;
        Icon icon = this.getCurrentFactory().getFileType().getIcon();
        this.myChooseFactory.setIcon(icon);
        this.myChooseFactory.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
    }

    protected CodeFragmentFactory getCurrentFactory() {
        return this.myFactory instanceof CodeFragmentFactoryContextWrapper ? this.myFactory : new CodeFragmentFactoryContextWrapper(this.myFactory);
    }

    protected JPanel addChooseFactoryLabel(JComponent component, boolean top) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)component, "Center");
        JPanel factoryPanel = new JPanel(new BorderLayout());
        factoryPanel.add((Component)this.myChooseFactory, top ? "North" : "Center");
        panel.add((Component)factoryPanel, "West");
        return panel;
    }
}

