/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.DebuggerView;
import com.intellij.debugger.ui.FramesPanel;
import com.intellij.debugger.ui.impl.MainWatchPanel;
import com.intellij.debugger.ui.impl.ThreadsPanel;
import com.intellij.debugger.ui.impl.VariablesPanel;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.AlertIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingsManager;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerSessionTab
extends DebuggerSessionTabBase
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DebuggerSessionTab.class);
    private final VariablesPanel myVariablesPanel;
    private final MainWatchPanel myWatchPanel;
    private volatile DebuggerSession myDebuggerSession;
    private final MyDebuggerStateManager myStateManager;
    private final FramesPanel myFramesPanel;
    private final DebugUIEnvironment myDebugUIEnvironment;
    private final ThreadsPanel myThreadsPanel;
    private static final String THREAD_DUMP_CONTENT_PREFIX = "Dump";
    private static int myThreadDumpsCount = 0;
    private static int myCurrentThreadDumpId = 1;

    public DebuggerSessionTab(final Project project, String sessionName, @NotNull DebugUIEnvironment environment, @NotNull DebuggerSession debuggerSession) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/ui/DebuggerSessionTab", "<init>"));
        }
        if (debuggerSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerSession", "com/intellij/debugger/ui/DebuggerSessionTab", "<init>"));
        }
        super(project, "JavaDebugger", sessionName, debuggerSession.getSearchScope());
        this.myStateManager = new MyDebuggerStateManager();
        this.myDebuggerSession = debuggerSession;
        this.myDebugUIEnvironment = environment;
        DefaultActionGroup focus = new DefaultActionGroup();
        focus.add(ActionManager.getInstance().getAction("Debugger.FocusOnBreakpoint"));
        this.myUi.getOptions().setAdditionalFocusActions((ActionGroup)focus);
        DebuggerSettings debuggerSettings = DebuggerSettings.getInstance();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getContextManager().addListener(new DebuggerContextListener(){

                @Override
                public void changeEvent(DebuggerContextImpl newContext, int event) {
                    switch (event) {
                        case 1: {
                            DebuggerSessionTab.this.myUi.updateActionsNow();
                            if (!XDebuggerSettingsManager.getInstanceImpl().getGeneralSettings().isHideDebuggerOnProcessTermination()) break;
                            try {
                                ExecutionManager.getInstance((Project)project).getContentManager().hideRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), DebuggerSessionTab.this.myRunContentDescriptor);
                                break;
                            }
                            catch (NullPointerException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                    }
                }
            });
        }
        DefaultActionGroup topToolbar = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        topToolbar.addAll(DebuggerSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.TopToolbar"));
        topToolbar.add(actionManager.getAction("Debugger.PopFrame"), new Constraints(Anchor.AFTER, "StepOut"));
        topToolbar.add((AnAction)Separator.getInstance(), new Constraints(Anchor.BEFORE, "Debugger.PopFrame"));
        topToolbar.add((AnAction)Separator.getInstance(), new Constraints(Anchor.AFTER, "Debugger.PopFrame"));
        this.myUi.getOptions().setTopToolbar((ActionGroup)topToolbar, "DebuggerToolbar");
        this.myWatchPanel = new MainWatchPanel(project, this.getContextManager());
        this.myFramesPanel = new FramesPanel(project, this.getContextManager());
        AlertIcon breakpointAlert = new AlertIcon(AllIcons.Debugger.BreakpointAlert);
        Content watches = this.myUi.createContent("WatchesContent", (JComponent)this.myWatchPanel, XDebuggerBundle.message((String)"debugger.session.tab.watches.title", (Object[])new Object[0]), AllIcons.Debugger.Watches, null);
        watches.setCloseable(false);
        watches.setAlertIcon(breakpointAlert);
        this.myUi.addContent(watches, 0, PlaceInGrid.right, false);
        Content framesContent = this.myUi.createContent("FrameContent", (JComponent)this.myFramesPanel, XDebuggerBundle.message((String)"debugger.session.tab.frames.title", (Object[])new Object[0]), AllIcons.Debugger.Frame, (JComponent)((Object)this.myFramesPanel.getFramesList()));
        framesContent.setCloseable(false);
        framesContent.setAlertIcon(breakpointAlert);
        this.myUi.addContent(framesContent, 0, PlaceInGrid.left, false);
        this.myVariablesPanel = new VariablesPanel(project, this.myStateManager, this);
        this.myVariablesPanel.getFrameTree().setAutoVariablesMode(debuggerSettings.AUTO_VARIABLES_MODE);
        Content vars = this.myUi.createContent("VariablesContent", (JComponent)this.myVariablesPanel, XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]), AllIcons.Debugger.Value, null);
        vars.setCloseable(false);
        vars.setAlertIcon(breakpointAlert);
        this.myUi.addContent(vars, 0, PlaceInGrid.center, false);
        this.myThreadsPanel = new ThreadsPanel(project, this.getContextManager());
        Content threadsContent = this.myUi.createContent("ThreadsContent", (JComponent)this.myThreadsPanel, XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), AllIcons.Debugger.Threads, null);
        threadsContent.setCloseable(false);
        this.myUi.addContent(threadsContent, 0, PlaceInGrid.left, true);
        for (Content each : this.myUi.getContents()) {
            DebuggerSessionTab.updateStatus(each);
        }
        this.myUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                DebuggerSessionTab.updateStatus(event.getContent());
            }
        }, (Disposable)this);
        debuggerSession.getContextManager().addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(DebuggerContextImpl newContext, int event) {
                if (!DebuggerSessionTab.this.myUi.isDisposed()) {
                    DebuggerSessionTab.this.attractFramesOnPause(event);
                    DebuggerSessionTab.this.myStateManager.fireStateChanged(newContext, event);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!DebuggerSessionTab.this.myUi.isDisposed()) {
                                DebuggerSessionTab.this.myUi.updateActionsNow();
                            }
                        }
                    });
                }
            }
        });
    }

    private static void updateStatus(Content content) {
        if (content.getComponent() instanceof DebuggerView) {
            DebuggerView view = (DebuggerView)((Object)content.getComponent());
            if (content.isSelected()) {
                view.setUpdateEnabled(true);
                if (view.isRefreshNeeded()) {
                    view.rebuildIfVisible(8);
                }
            } else {
                view.setUpdateEnabled(false);
            }
        }
    }

    public MainWatchPanel getWatchPanel() {
        return this.myWatchPanel;
    }

    private void initUI(ExecutionResult executionResult) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myUi.removeContent(this.myUi.findContent("ConsoleContent"), true);
        Content console = null;
        if (this.myConsole instanceof ExecutionConsoleEx) {
            ((ExecutionConsoleEx)this.myConsole).buildUi(this.myUi);
            console = this.myUi.findContent("ConsoleContent");
            if (console == null) {
                LOG.debug("Reuse console created with non-debug runner");
            }
        }
        if (console == null) {
            console = this.myUi.createContent("ConsoleContent", this.myConsole.getComponent(), XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]), AllIcons.Debugger.Console, this.myConsole.getPreferredFocusableComponent());
            console.setCloseable(false);
            this.myUi.addContent(console, 1, PlaceInGrid.bottom, false);
        }
        this.attachNotificationTo(console);
        if (this.myConsole != null) {
            Disposer.register((Disposable)this, (Disposable)this.myConsole);
        }
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (this.myConsole instanceof ConsoleView) {
            AnAction[] actions;
            for (AnAction goAction : actions = ((ConsoleView)this.myConsole).createConsoleActions()) {
                consoleActions.add(goAction);
            }
        }
        console.setActions((ActionGroup)consoleActions, "DebuggerToolbar", this.myConsole.getPreferredFocusableComponent());
        DefaultActionGroup leftToolbar = new DefaultActionGroup();
        if (executionResult instanceof DefaultExecutionResult) {
            AnAction[] actions = ((DefaultExecutionResult)executionResult).getRestartActions();
            leftToolbar.addAll(actions);
            if (actions.length > 0) {
                leftToolbar.addSeparator();
            }
        }
        AnAction[] profileActions = executionResult.getActions();
        leftToolbar.addAll(profileActions);
        leftToolbar.add((AnAction)DebuggerSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.LeftToolbar"));
        if (executionResult instanceof DefaultExecutionResult) {
            AnAction[] actions;
            for (AnAction action : actions = ((DefaultExecutionResult)executionResult).getAdditionalStopActions()) {
                leftToolbar.add(action, new Constraints(Anchor.AFTER, "Stop"));
            }
        }
        leftToolbar.addSeparator();
        DebuggerSessionTab.addAction(leftToolbar, "DumpThreads");
        leftToolbar.addSeparator();
        leftToolbar.add(this.myUi.getOptions().getLayoutActions());
        AnAction[] commonSettings = this.myUi.getOptions().getSettingsActionsList();
        final AnAction commonSettingsList = this.myUi.getOptions().getSettingsActions();
        DefaultActionGroup settings = new DefaultActionGroup("DebuggerSettings", true){

            public void update(AnActionEvent e) {
                e.getPresentation().setText(ActionsBundle.message((String)"group.XDebugger.settings.text", (Object[])new Object[0]));
                e.getPresentation().setIcon(commonSettingsList.getTemplatePresentation().getIcon());
            }

            public boolean isDumbAware() {
                return true;
            }
        };
        for (AnAction each : commonSettings) {
            settings.add(each);
        }
        if (commonSettings.length > 0) {
            settings.addSeparator();
        }
        settings.add((AnAction)new WatchLastMethodReturnValueAction());
        settings.add((AnAction)new AutoVarsSwitchAction());
        settings.addSeparator();
        DebuggerSessionTab.addActionToGroup(settings, "XDebugger.Inline");
        DebuggerSessionTab.addActionToGroup(settings, "XDebugger.AutoTooltip");
        DebuggerSessionTab.addActionToGroup(settings, "XDebugger.AutoTooltipOnSelection");
        leftToolbar.add((AnAction)settings);
        leftToolbar.addSeparator();
        DebuggerSessionTab.addActionToGroup(leftToolbar, "PinToolwindowTab");
        this.myDebugUIEnvironment.initActions(this.myRunContentDescriptor, leftToolbar);
        this.myUi.getOptions().setLeftToolbar((ActionGroup)leftToolbar, "DebuggerToolbar");
    }

    private static void addAction(DefaultActionGroup group, String actionId) {
        group.add(ActionManager.getInstance().getAction(actionId));
    }

    private static void addActionToGroup(DefaultActionGroup group, String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            group.add(action);
        }
    }

    @Override
    public void dispose() {
        this.disposeSession();
        this.myFramesPanel.dispose();
        this.myVariablesPanel.dispose();
        this.myWatchPanel.dispose();
        this.myThreadsPanel.dispose();
        this.myConsole = null;
        super.dispose();
    }

    private void disposeSession() {
        DebuggerSession session = this.myDebuggerSession;
        this.myDebuggerSession = null;
        if (session != null) {
            session.dispose();
        }
    }

    @Nullable
    private DebugProcessImpl getDebugProcess() {
        DebuggerSession session = this.myDebuggerSession;
        return session != null ? session.getProcess() : null;
    }

    public void reuse(DebuggerSessionTab reuseSession) {
        DebuggerTreeNodeImpl[] watches = reuseSession.getWatchPanel().getWatchTree().getWatches();
        WatchDebuggerTree watchTree = this.getWatchPanel().getWatchTree();
        for (DebuggerTreeNodeImpl watch : watches) {
            watchTree.addWatch((WatchItemDescriptor)watch.getDescriptor());
        }
        DebugProcessImpl process = this.getDebugProcess();
        DebugProcessImpl reuseProcess = reuseSession.getDebugProcess();
        if (process == null || reuseProcess != null) {
            // empty if block
        }
    }

    public String getSessionName() {
        return this.myDebugUIEnvironment.getEnvironment().getSessionName();
    }

    public DebuggerStateManager getContextManager() {
        return this.myStateManager;
    }

    @Nullable
    public TextWithImports getSelectedExpression() {
        DebuggerSession session = this.myDebuggerSession;
        if (session == null || session.getState() != 3) {
            return null;
        }
        DebuggerTree tree = this.myVariablesPanel.getFrameTree();
        if (!(tree != null && ((Component)((Object)tree)).hasFocus() || (tree = this.myWatchPanel.getWatchTree()) != null && ((Component)((Object)tree)).hasFocus())) {
            return null;
        }
        TreePath path = ((JTree)((Object)tree)).getSelectionPath();
        if (path == null) {
            return null;
        }
        DebuggerTreeNodeImpl node = (DebuggerTreeNodeImpl)path.getLastPathComponent();
        if (node == null) {
            return null;
        }
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (!(descriptor instanceof ValueDescriptorImpl)) {
            return null;
        }
        if (descriptor instanceof WatchItemDescriptor) {
            return ((WatchItemDescriptor)descriptor).getEvaluationText();
        }
        try {
            return DebuggerTreeNodeExpression.createEvaluationText(node, this.getContextManager().getContext());
        }
        catch (EvaluateException e) {
            return null;
        }
    }

    @Override
    @Nullable
    protected RunProfile getRunProfile() {
        return this.myDebugUIEnvironment.getRunProfile();
    }

    private void attractFramesOnPause(int event) {
        if (6 == event) {
            this.myUi.attractBy("breakpoint");
        } else if (4 == event) {
            this.myUi.clearAttractionBy("breakpoint");
        }
    }

    public DebuggerSession getSession() {
        return this.myDebuggerSession;
    }

    public void showFramePanel() {
        this.myUi.selectAndFocus(this.myUi.findContent("FrameContent"), true, false);
    }

    public static void addThreadDump(Project project, List<ThreadState> threads, RunnerLayoutUi ui, DebuggerSession session) {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)session.getSearchScope()));
        ConsoleView consoleView = consoleBuilder.getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView.allowHeavyFilters();
        ThreadDumpPanel panel = new ThreadDumpPanel(project, consoleView, toolbarActions, threads);
        String id = DebuggerSessionTab.createThreadDumpContentId();
        Content content = ui.createContent(id, (JComponent)panel, id, null, null);
        content.setCloseable(true);
        content.setDescription("Thread Dump");
        ui.addContent(content);
        ui.selectAndFocus(content, true, true);
        ++myThreadDumpsCount;
        ++myCurrentThreadDumpId;
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                myThreadDumpsCount -= 1;
                if (myThreadDumpsCount == 0) {
                    myCurrentThreadDumpId = 1;
                }
            }
        });
        Disposer.register((Disposable)content, (Disposable)consoleView);
        ui.selectAndFocus(content, true, false);
        if (threads.size() > 0) {
            panel.selectStackFrame(0);
        }
    }

    private static String createThreadDumpContentId() {
        return "Dump #" + myCurrentThreadDumpId;
    }

    private class WatchLastMethodReturnValueAction
    extends ToggleAction {
        private volatile boolean myWatchesReturnValues;
        private final String myTextEnable;
        private final String myTextUnavailable;
        private final String myMyTextDisable;

        public WatchLastMethodReturnValueAction() {
            super("", DebuggerBundle.message((String)"action.watch.method.return.value.description", (Object[])new Object[0]), null);
            this.myWatchesReturnValues = DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
            this.myTextEnable = DebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]);
            this.myMyTextDisable = DebuggerBundle.message((String)"action.watches.method.return.value.disable", (Object[])new Object[0]);
            this.myTextUnavailable = DebuggerBundle.message((String)"action.watches.method.return.value.unavailable.reason", (Object[])new Object[0]);
        }

        public void update(@NotNull AnActionEvent e) {
            String actionText;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/ui/DebuggerSessionTab$WatchLastMethodReturnValueAction", "update"));
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            boolean watchValues = Boolean.TRUE.equals(presentation.getClientProperty("selected"));
            DebugProcessImpl process = DebuggerSessionTab.this.getDebugProcess();
            String string = actionText = watchValues ? this.myMyTextDisable : this.myTextEnable;
            if (process != null && process.canGetMethodReturnValue()) {
                presentation.setEnabled(true);
                presentation.setText(actionText);
            } else {
                presentation.setEnabled(false);
                presentation.setText(process == null ? actionText : this.myTextUnavailable);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myWatchesReturnValues;
        }

        public void setSelected(AnActionEvent e, boolean watch) {
            this.myWatchesReturnValues = watch;
            DebuggerSettings.getInstance().WATCH_RETURN_VALUES = watch;
            DebugProcessImpl process = DebuggerSessionTab.this.getDebugProcess();
            if (process != null) {
                process.setWatchMethodReturnValuesEnabled(watch);
            }
        }
    }

    private class AutoVarsSwitchAction
    extends ToggleAction {
        private volatile boolean myAutoModeEnabled;

        public AutoVarsSwitchAction() {
            super("", "", AllIcons.Debugger.AutoVariablesMode);
            this.myAutoModeEnabled = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/ui/DebuggerSessionTab$AutoVarsSwitchAction", "update"));
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            boolean autoModeEnabled = Boolean.TRUE.equals(presentation.getClientProperty("selected"));
            presentation.setText(autoModeEnabled ? "All-Variables Mode" : "Auto-Variables Mode");
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myAutoModeEnabled;
        }

        public void setSelected(AnActionEvent e, boolean enabled) {
            this.myAutoModeEnabled = enabled;
            DebuggerSettings.getInstance().AUTO_VARIABLES_MODE = enabled;
            DebuggerSessionTab.this.myVariablesPanel.getFrameTree().setAutoVariablesMode(enabled);
        }
    }

    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private MyDebuggerStateManager() {
        }

        @Override
        public void fireStateChanged(DebuggerContextImpl newContext, int event) {
            super.fireStateChanged(newContext, event);
        }

        @Override
        public DebuggerContextImpl getContext() {
            DebuggerSession session = DebuggerSessionTab.this.myDebuggerSession;
            return session != null ? session.getContextManager().getContext() : DebuggerContextImpl.EMPTY_CONTEXT;
        }

        @Override
        public void setState(DebuggerContextImpl context, int state, int event, String description) {
            DebuggerSession session = DebuggerSessionTab.this.myDebuggerSession;
            if (session != null) {
                session.getContextManager().setState(context, state, event, description);
            }
        }
    }
}

