/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public abstract class CompilingEvaluator
implements ExpressionEvaluator {
    @NotNull
    protected final PsiElement myPsiContext;
    @NotNull
    protected final ExtractLightMethodObjectHandler.ExtractedData myData;
    private static final String GEN_CLASS_NAME = "GeneratedEvaluationClass";

    public CompilingEvaluator(@NotNull PsiElement context, @NotNull ExtractLightMethodObjectHandler.ExtractedData data) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/ui/impl/watch/CompilingEvaluator", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/debugger/ui/impl/watch/CompilingEvaluator", "<init>"));
        }
        this.myPsiContext = context;
        this.myData = data;
    }

    public Value getValue() {
        return null;
    }

    public Modifier getModifier() {
        return null;
    }

    private TextWithImports getCallCode() {
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, this.myData.getGeneratedCallText());
    }

    public Value evaluate(final EvaluationContext evaluationContext) throws EvaluateException {
        ClassLoaderReference classLoader;
        DebugProcess process = evaluationContext.getDebugProcess();
        try {
            classLoader = CompilingEvaluator.getClassLoader(evaluationContext, process);
        }
        catch (Exception e) {
            throw new EvaluateException("Error creating evaluation class loader: " + e, (Throwable)e);
        }
        String version = ((VirtualMachineProxyImpl)process.getVirtualMachineProxy()).version();
        JavaSdkVersion sdkVersion = JdkVersionUtil.getVersion((String)version);
        Collection<OutputFileObject> classes = this.compile(sdkVersion != null ? sdkVersion.getDescription() : null);
        try {
            this.defineClasses(classes, evaluationContext, process, classLoader);
        }
        catch (Exception e) {
            throw new EvaluateException("Error during classes definition " + e, (Throwable)e);
        }
        try {
            final Project project = (Project)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Project>(){

                public Project compute() {
                    return CompilingEvaluator.this.myPsiContext.getProject();
                }
            });
            ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project, new EvaluatingComputable<ExpressionEvaluator>(){

                @Override
                public ExpressionEvaluator compute() throws EvaluateException {
                    TextWithImports callCode = CompilingEvaluator.this.getCallCode();
                    PsiElement copyContext = CompilingEvaluator.this.myData.getAnchor();
                    CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(callCode, copyContext);
                    return factory.getEvaluatorBuilder().build((PsiElement)factory.createCodeFragment(callCode, copyContext, project), ContextUtil.getSourcePosition((StackFrameContext)evaluationContext));
                }
            });
            ((EvaluationContextImpl)evaluationContext).setClassLoader(classLoader);
            return evaluator.evaluate(evaluationContext);
        }
        catch (Exception e) {
            throw new EvaluateException("Error during generated code invocation " + e, (Throwable)e);
        }
    }

    private static ClassLoaderReference getClassLoader(EvaluationContext context, DebugProcess process) throws EvaluateException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        ClassType loaderClass = (ClassType)process.findClass(context, "java.net.URLClassLoader", context.getClassLoader());
        Method ctorMethod = loaderClass.concreteMethodByName("<init>", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V");
        ClassLoaderReference reference = (ClassLoaderReference)process.newInstance(context, loaderClass, ctorMethod, Arrays.asList(CompilingEvaluator.createURLArray(context), context.getClassLoader()));
        CompilingEvaluator.keep(reference, context);
        return reference;
    }

    private static void keep(ObjectReference reference, EvaluationContext context) {
        ((SuspendContextImpl)context.getSuspendContext()).keep(reference);
    }

    private ClassType defineClasses(Collection<OutputFileObject> classes, EvaluationContext context, DebugProcess process, ClassLoaderReference classLoader) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)process.getVirtualMachineProxy();
        for (OutputFileObject cls : classes) {
            if (!cls.getName().contains(GEN_CLASS_NAME)) continue;
            Method defineMethod = ((ClassType)classLoader.referenceType()).concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            byte[] bytes = CompilingEvaluator.changeSuperToMagicAccessor(cls.toByteArray());
            ArrayList<Value> args = new ArrayList<Value>();
            StringReference name = proxy.mirrorOf(cls.myOrigName);
            CompilingEvaluator.keep(name, context);
            args.add(name);
            args.add(CompilingEvaluator.mirrorOf(bytes, context, process));
            args.add(proxy.mirrorOf(0));
            args.add(proxy.mirrorOf(bytes.length));
            process.invokeMethod(context, (ObjectReference)classLoader, defineMethod, args);
        }
        return (ClassType)process.findClass(context, this.getGenClassQName(), classLoader);
    }

    private static byte[] changeSuperToMagicAccessor(byte[] bytes) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if ("java/lang/Object".equals(superName)) {
                    superName = "sun/reflect/MagicAccessorImpl";
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }
        };
        new ClassReader(bytes).accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    private static ArrayReference mirrorOf(byte[] bytes, EvaluationContext context, DebugProcess process) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        ArrayType arrayClass = (ArrayType)process.findClass(context, "byte[]", context.getClassLoader());
        ArrayReference reference = process.newInstance(arrayClass, bytes.length);
        CompilingEvaluator.keep(reference, context);
        for (int i = 0; i < bytes.length; ++i) {
            reference.setValue(i, (Value)((VirtualMachineProxyImpl)process.getVirtualMachineProxy()).mirrorOf(bytes[i]));
        }
        return reference;
    }

    public static String getGeneratedClassName() {
        return GEN_CLASS_NAME;
    }

    protected String getGenClassQName() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return JVMNameUtil.getNonAnonymousClassName(CompilingEvaluator.this.myData.getGeneratedInnerClass());
            }
        });
    }

    private static ArrayReference createURLArray(EvaluationContext context) throws EvaluateException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        DebugProcess process = context.getDebugProcess();
        ArrayType arrayType = (ArrayType)process.findClass(context, "java.net.URL[]", context.getClassLoader());
        ArrayReference arrayRef = arrayType.newInstance(1);
        CompilingEvaluator.keep(arrayRef, context);
        ClassType classType = (ClassType)process.findClass(context, "java.net.URL", context.getClassLoader());
        VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)process.getVirtualMachineProxy();
        StringReference url = proxy.mirrorOf("file:a");
        CompilingEvaluator.keep(url, context);
        ObjectReference reference = process.newInstance(context, classType, classType.concreteMethodByName("<init>", "(Ljava/lang/String;)V"), Collections.singletonList(url));
        CompilingEvaluator.keep(reference, context);
        arrayRef.setValues(Collections.singletonList(reference));
        return arrayRef;
    }

    @NotNull
    protected abstract Collection<OutputFileObject> compile(String var1) throws EvaluateException;

    private static URI getUri(String name, JavaFileObject.Kind kind) {
        return URI.create("memo:///" + name.replace('.', '/') + kind.extension);
    }

    protected static class MemoryFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        protected final Collection<OutputFileObject> classes = new ArrayList<OutputFileObject>();

        MemoryFileManager(JavaCompiler compiler) {
            super(compiler.getStandardFileManager(null, null, null));
        }

        @Override
        public OutputFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject source) {
            OutputFileObject mc = new OutputFileObject(name, kind);
            this.classes.add(mc);
            return mc;
        }
    }

    protected static class OutputFileObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream myStream = new ByteArrayOutputStream();
        private final String myOrigName;

        OutputFileObject(String name, JavaFileObject.Kind kind) {
            super(CompilingEvaluator.getUri(name, kind), kind);
            this.myOrigName = name;
        }

        byte[] toByteArray() {
            return this.myStream.toByteArray();
        }

        @Override
        public ByteArrayOutputStream openOutputStream() {
            return this.myStream;
        }
    }

    protected static class SourceFileObject
    extends SimpleJavaFileObject {
        private final String myContent;

        SourceFileObject(String name, JavaFileObject.Kind kind, String content) {
            super(CompilingEvaluator.getUri(name, kind), kind);
            this.myContent = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignore) {
            return this.myContent;
        }
    }
}

