/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFilesAction
extends BaseShowDiffAction {
    public static final DataKey<DiffRequest> DIFF_REQUEST = DataKey.create((String)"CompareFilesAction.DiffRequest");
    public static final String LAST_USED_FILE_KEY = "two.files.diff.last.used.file";
    public static final String LAST_USED_FOLDER_KEY = "two.files.diff.last.used.folder";

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFilesAction", "update"));
        }
        super.update(e);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        String text = this.getTemplatePresentation().getText();
        if (files != null && files.length == 1) {
            text = text + "...";
        }
        e.getPresentation().setText(text);
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFilesAction", "isAvailable"));
        }
        DiffRequest request = (DiffRequest)e.getData(DIFF_REQUEST);
        if (request != null) {
            return true;
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            return false;
        }
        if (files.length == 1) {
            return files[0].isValid();
        }
        if (files.length == 2) {
            return files[0].isValid() && files[1].isValid();
        }
        return false;
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFilesAction", "getDiffRequest"));
        }
        Project project = e.getProject();
        DiffRequest diffRequest = (DiffRequest)e.getData(DIFF_REQUEST);
        if (diffRequest != null) {
            return diffRequest;
        }
        VirtualFile[] data = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (data.length == 1) {
            VirtualFile otherFile = CompareFilesAction.getOtherFile(project, data[0]);
            if (otherFile == null) {
                return null;
            }
            return DiffRequestFactory.getInstance().createFromFiles(project, data[0], otherFile);
        }
        return DiffRequestFactory.getInstance().createFromFiles(project, data[0], data[1]);
    }

    @Nullable
    private static VirtualFile getOtherFile(@Nullable Project project, @NotNull VirtualFile file) {
        VirtualFile otherFile;
        String key;
        FileChooserDescriptor descriptor;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/actions/CompareFilesAction", "getOtherFile"));
        }
        if (file.isDirectory() || file.getFileType() instanceof ArchiveFileType) {
            descriptor = new FileChooserDescriptor(false, true, true, false, false, false);
            key = LAST_USED_FOLDER_KEY;
        } else {
            descriptor = new FileChooserDescriptor(true, false, false, true, true, false);
            key = LAST_USED_FILE_KEY;
        }
        VirtualFile selectedFile = CompareFilesAction.getDefaultSelection(project, key, file);
        VirtualFile[] result = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)selectedFile);
        VirtualFile virtualFile = otherFile = result.length == 1 ? result[0] : null;
        if (otherFile != null) {
            CompareFilesAction.updateDefaultSelection(project, key, otherFile);
        }
        return otherFile;
    }

    @NotNull
    private static VirtualFile getDefaultSelection(@Nullable Project project, @NotNull String key, @NotNull VirtualFile file) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
        }
        if (project == null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
            }
            return virtualFile;
        }
        String path = PropertiesComponent.getInstance((Project)project).getValue(key);
        if (path == null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
            }
            return virtualFile;
        }
        VirtualFile lastSelection = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile virtualFile = lastSelection != null ? lastSelection : file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
        }
        return virtualFile;
    }

    private static void updateDefaultSelection(@Nullable Project project, @NotNull String key, @NotNull VirtualFile file) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/actions/CompareFilesAction", "updateDefaultSelection"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/actions/CompareFilesAction", "updateDefaultSelection"));
        }
        if (project == null) {
            return;
        }
        PropertiesComponent.getInstance((Project)project).setValue(key, file.getPath());
    }
}

