/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TrimUtil {
    private static final String PUNCTUATION = "(){}[],./?`~!@#$%^&*-=+|\\;:'\"<>";
    private static final TIntHashSet PUNCTUATION_SET = new TIntHashSet();

    public static boolean isPunctuation(char c) {
        return PUNCTUATION_SET.contains((int)c);
    }

    public static boolean isAlpha(char c) {
        return !StringUtil.isWhiteSpace((char)c) && !PUNCTUATION_SET.contains((int)c);
    }

    @NotNull
    public static DiffIterableUtil.Range trim(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        start1 = TrimUtil.trimStart(text1, start1, end1);
        end1 = TrimUtil.trimEnd(text1, start1, end1);
        start2 = TrimUtil.trimStart(text2, start2, end2);
        end2 = TrimUtil.trimEnd(text2, start2, end2);
        DiffIterableUtil.Range range = new DiffIterableUtil.Range(start1, end1, start2, end2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        return range;
    }

    @NotNull
    public static DiffIterableUtil.IntPair trim(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        start = TrimUtil.trimStart(text, start, end);
        end = TrimUtil.trimEnd(text, start, end);
        DiffIterableUtil.IntPair intPair = new DiffIterableUtil.IntPair(start, end);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        return intPair;
    }

    public static int trimStart(@NotNull CharSequence text, int start, int end) {
        char c;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/TrimUtil", "trimStart"));
        }
        while (start < end && StringUtil.isWhiteSpace((char)(c = text.charAt(start)))) {
            ++start;
        }
        return start;
    }

    public static int trimEnd(@NotNull CharSequence text, int start, int end) {
        char c;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/TrimUtil", "trimEnd"));
        }
        while (start < end && StringUtil.isWhiteSpace((char)(c = text.charAt(end - 1)))) {
            --end;
        }
        return end;
    }

    @NotNull
    public static DiffIterableUtil.Range expand(@NotNull List<? extends Object> text1, @NotNull List<? extends Object> text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        int count1 = TrimUtil.expandForward(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackward(text1, text2, start1 += count1, start2 += count1, end1, end2);
        DiffIterableUtil.Range range = new DiffIterableUtil.Range(start1, end1 -= count2, start2, end2 -= count2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        return range;
    }

    @NotNull
    public static DiffIterableUtil.Range expand(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        int count1 = TrimUtil.expandForward(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackward(text1, text2, start1 += count1, start2 += count1, end1, end2);
        DiffIterableUtil.Range range = new DiffIterableUtil.Range(start1, end1 -= count2, start2, end2 -= count2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        return range;
    }

    @NotNull
    public static DiffIterableUtil.Range expandW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandW"));
        }
        int count1 = TrimUtil.expandForwardW(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackwardW(text1, text2, start1 += count1, start2 += count1, end1, end2);
        DiffIterableUtil.Range range = new DiffIterableUtil.Range(start1, end1 -= count2, start2, end2 -= count2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandW"));
        }
        return range;
    }

    public static int expandForward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForward"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForward"));
        }
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(start1)) == (c2 = text2.charAt(start2))) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandForward(@NotNull List<? extends Object> text1, @NotNull List<? extends Object> text2, int start1, int start2, int end1, int end2) {
        Object c2;
        Object c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForward"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForward"));
        }
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.get(start1)).equals(c2 = text2.get(start2))) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandForwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForwardW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForwardW"));
        }
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(start1)) == (c2 = text2.charAt(start2)) && StringUtil.isWhiteSpace((char)c1)) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandBackward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackward"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackward"));
        }
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(end1 - 1)) == (c2 = text2.charAt(end2 - 1))) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    public static int expandBackward(@NotNull List<? extends Object> text1, @NotNull List<? extends Object> text2, int start1, int start2, int end1, int end2) {
        Object c2;
        Object c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackward"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackward"));
        }
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.get(end1 - 1)).equals(c2 = text2.get(end2 - 1))) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    public static int expandBackwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackwardW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackwardW"));
        }
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(end1 - 1)) == (c2 = text2.charAt(end2 - 1)) && StringUtil.isWhiteSpace((char)c1)) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    @NotNull
    public static DiffIterableUtil.IntPair expandForwardIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForwardIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForwardIW"));
        }
        while (start1 < end1 && start2 < end2) {
            char c22;
            c1 = text1.charAt(start1);
            if (c1 == (c22 = text2.charAt(start2))) {
                ++start1;
                ++start2;
                continue;
            }
            boolean skipped = false;
            if (StringUtil.isWhiteSpace((char)c1)) {
                skipped = true;
                ++start1;
            }
            if (StringUtil.isWhiteSpace((char)c22)) {
                skipped = true;
                ++start2;
            }
            if (skipped) continue;
            break;
        }
        while (start1 < end1 && StringUtil.isWhiteSpace((char)(c1 = text1.charAt(start1)))) {
            ++start1;
        }
        while (start2 < end2 && StringUtil.isWhiteSpace((char)(c2 = text2.charAt(start2)))) {
            ++start2;
        }
        DiffIterableUtil.IntPair intPair = new DiffIterableUtil.IntPair(start1, start2);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandForwardIW"));
        }
        return intPair;
    }

    @NotNull
    public static DiffIterableUtil.IntPair expandBackwardIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackwardIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackwardIW"));
        }
        while (start1 < end1 && start2 < end2) {
            char c22;
            c1 = text1.charAt(end1 - 1);
            if (c1 == (c22 = text2.charAt(end2 - 1))) {
                --end1;
                --end2;
                continue;
            }
            boolean skipped = false;
            if (StringUtil.isWhiteSpace((char)c1)) {
                skipped = true;
                --end1;
            }
            if (StringUtil.isWhiteSpace((char)c22)) {
                skipped = true;
                --end2;
            }
            if (skipped) continue;
            break;
        }
        while (start1 < end1 && StringUtil.isWhiteSpace((char)(c1 = text1.charAt(end1 - 1)))) {
            --end1;
        }
        while (start2 < end2 && StringUtil.isWhiteSpace((char)(c2 = text2.charAt(end2 - 1)))) {
            --end2;
        }
        DiffIterableUtil.IntPair intPair = new DiffIterableUtil.IntPair(end1, end2);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandBackwardIW"));
        }
        return intPair;
    }

    @NotNull
    public static DiffIterableUtil.Range expandIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        DiffIterableUtil.IntPair start = TrimUtil.expandForwardIW(text1, text2, start1, start2, end1, end2);
        start1 = start.val1;
        start2 = start.val2;
        DiffIterableUtil.IntPair end = TrimUtil.expandBackwardIW(text1, text2, start1, start2, end1, end2);
        end1 = end.val1;
        end2 = end.val2;
        DiffIterableUtil.Range range = new DiffIterableUtil.Range(start1, end1, start2, end2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        return range;
    }

    @NotNull
    public static DiffIterableUtil.Range expand(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull DiffIterableUtil.Range range) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        DiffIterableUtil.Range range2 = TrimUtil.expand(text1, text2, range.start1, range.start2, range.end1, range.end2);
        if (range2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        return range2;
    }

    @NotNull
    public static DiffIterableUtil.Range trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull DiffIterableUtil.Range range) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        DiffIterableUtil.Range range2 = TrimUtil.trim(text1, text2, range.start1, range.start2, range.end1, range.end2);
        if (range2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        return range2;
    }

    @NotNull
    public static DiffIterableUtil.Range expandIW(@NotNull CharSequence text1, @NotNull CharSequence text2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        DiffIterableUtil.Range range = TrimUtil.expandIW(text1, text2, 0, 0, text1.length(), text2.length());
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        return range;
    }

    static {
        for (char punctuation : PUNCTUATION.toCharArray()) {
            PUNCTUATION_SET.add((int)punctuation);
        }
    }
}

