/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.dir;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.JarFileDiffElement;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.util.Disposer;
import java.awt.Window;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DifDiffViewer
implements FrameDiffTool.DiffViewer {
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final ContentDiffRequest myRequest;
    @NotNull
    private final DirDiffPanel myPanel;

    public DifDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/dir/DifDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/dir/DifDiffViewer", "<init>"));
        }
        this.myContext = context;
        this.myRequest = request;
        List contents = request.getContents();
        DiffElement element1 = DifDiffViewer.createDiffElement((DiffContent)contents.get(0));
        DiffElement element2 = DifDiffViewer.createDiffElement((DiffContent)contents.get(1));
        DirDiffTableModel model = new DirDiffTableModel(context.getProject(), element1, element2, new DirDiffSettings());
        this.myPanel = new DirDiffPanel(model, new DirDiffWindow(null){

            @Override
            public Window getWindow() {
                return null;
            }

            @Override
            public Disposable getDisposable() {
                return DifDiffViewer.this;
            }

            @Override
            public void setTitle(String title) {
            }
        });
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        this.myPanel.setupSplitter();
        FrameDiffTool.ToolbarComponents toolbarComponents = new FrameDiffTool.ToolbarComponents();
        if (toolbarComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DifDiffViewer", "init"));
        }
        return toolbarComponents;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myPanel);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel.getPanel();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DifDiffViewer", "getComponent"));
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getTable();
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/dir/DifDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/dir/DifDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        if (!DifDiffViewer.canShowContent((DiffContent)contents.get(0))) {
            return false;
        }
        if (!DifDiffViewer.canShowContent((DiffContent)contents.get(1))) {
            return false;
        }
        return !(contents.get(0) instanceof EmptyContent) || !(contents.get(1) instanceof EmptyContent);
    }

    private static boolean canShowContent(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/dir/DifDiffViewer", "canShowContent"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DirectoryContent) {
            return true;
        }
        return content instanceof FileContent && content.getContentType() instanceof ArchiveFileType && ((FileContent)content).getFile().isInLocalFileSystem();
    }

    @NotNull
    private static DiffElement createDiffElement(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/dir/DifDiffViewer", "createDiffElement"));
        }
        if (content instanceof EmptyContent) {
            DiffElement diffElement = new DiffElement(){

                public String getPath() {
                    return "";
                }

                @NotNull
                public String getName() {
                    if ("Nothing" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DifDiffViewer$2", "getName"));
                    }
                    return "Nothing";
                }

                public long getSize() {
                    return -1L;
                }

                public long getTimeStamp() {
                    return -1L;
                }

                public boolean isContainer() {
                    return true;
                }

                public DiffElement[] getChildren() throws IOException {
                    return EMPTY_ARRAY;
                }

                @Nullable
                public byte[] getContent() throws IOException {
                    return null;
                }

                public Object getValue() {
                    return null;
                }
            };
            if (diffElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DifDiffViewer", "createDiffElement"));
            }
            return diffElement;
        }
        if (content instanceof DirectoryContent) {
            VirtualFileDiffElement virtualFileDiffElement = new VirtualFileDiffElement(((DirectoryContent)content).getFile());
            if (virtualFileDiffElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DifDiffViewer", "createDiffElement"));
            }
            return virtualFileDiffElement;
        }
        if (content instanceof FileContent && content.getContentType() instanceof ArchiveFileType) {
            JarFileDiffElement jarFileDiffElement = new JarFileDiffElement(((FileContent)content).getFile());
            if (jarFileDiffElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DifDiffViewer", "createDiffElement"));
            }
            return jarFileDiffElement;
        }
        throw new IllegalArgumentException(content.getClass() + " " + content.getContentType());
    }
}

