/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import gnu.trove.TIntFunction;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class LineNumberConvertor {
    @NotNull
    private final TreeMap<Integer, Integer> myFragments1;
    @NotNull
    private final TreeMap<Integer, Integer> myFragments2;
    @NotNull
    private final TreeMap<Integer, Integer> myInvertedFragments1;
    @NotNull
    private final TreeMap<Integer, Integer> myInvertedFragments2;

    public LineNumberConvertor(@NotNull TreeMap<Integer, Integer> fragments1, @NotNull TreeMap<Integer, Integer> fragments2, @NotNull TreeMap<Integer, Integer> invertedFragments1, @NotNull TreeMap<Integer, Integer> invertedFragments2) {
        if (fragments1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments1", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "<init>"));
        }
        if (fragments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments2", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "<init>"));
        }
        if (invertedFragments1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invertedFragments1", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "<init>"));
        }
        if (invertedFragments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invertedFragments2", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "<init>"));
        }
        this.myFragments1 = fragments1;
        this.myFragments2 = fragments2;
        this.myInvertedFragments1 = invertedFragments1;
        this.myInvertedFragments2 = invertedFragments2;
    }

    public int convert1(int value) {
        return LineNumberConvertor.convert(this.myFragments1, value);
    }

    public int convert2(int value) {
        return LineNumberConvertor.convert(this.myFragments2, value);
    }

    public int convertInv1(int value) {
        return LineNumberConvertor.convert(this.myInvertedFragments1, value);
    }

    public int convertInv2(int value) {
        return LineNumberConvertor.convert(this.myInvertedFragments2, value);
    }

    public int convertApproximate1(int value) {
        return LineNumberConvertor.convertApproximate(this.myFragments1, value);
    }

    public int convertApproximate2(int value) {
        return LineNumberConvertor.convertApproximate(this.myFragments2, value);
    }

    public int convertApproximateInv1(int value) {
        return LineNumberConvertor.convertApproximate(this.myInvertedFragments1, value);
    }

    public int convertApproximateInv2(int value) {
        return LineNumberConvertor.convertApproximate(this.myInvertedFragments2, value);
    }

    @NotNull
    public TIntFunction createConvertor1() {
        TIntFunction tIntFunction = new TIntFunction(){

            public int execute(int value) {
                return LineNumberConvertor.this.convert1(value);
            }
        };
        if (tIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "createConvertor1"));
        }
        return tIntFunction;
    }

    @NotNull
    public TIntFunction createConvertor2() {
        TIntFunction tIntFunction = new TIntFunction(){

            public int execute(int value) {
                return LineNumberConvertor.this.convert2(value);
            }
        };
        if (tIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "createConvertor2"));
        }
        return tIntFunction;
    }

    private static int convert(@NotNull TreeMap<Integer, Integer> fragments, int value) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "convert"));
        }
        Map.Entry<Integer, Integer> floor = fragments.floorEntry(value);
        if (floor == null || floor.getValue() == -1) {
            return -1;
        }
        return floor.getValue() - floor.getKey() + value;
    }

    private static int convertApproximate(@NotNull TreeMap<Integer, Integer> fragments, int value) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "convertApproximate"));
        }
        Map.Entry<Integer, Integer> floor = fragments.floorEntry(value);
        if (floor == null) {
            return 0;
        }
        if (floor.getValue() != -1) {
            return floor.getValue() - floor.getKey() + value;
        }
        Map.Entry<Integer, Integer> floorHead = fragments.floorEntry(floor.getKey() - 1);
        assert (floorHead != null && floorHead.getValue() != -1);
        return floorHead.getValue() - floorHead.getKey() + floor.getKey();
    }

    public static class Builder {
        @NotNull
        private final TreeMap<Integer, Integer> myFragments1 = new TreeMap();
        @NotNull
        private final TreeMap<Integer, Integer> myFragments2 = new TreeMap();
        @NotNull
        private final TreeMap<Integer, Integer> myInvertedFragments1 = new TreeMap();
        @NotNull
        private final TreeMap<Integer, Integer> myInvertedFragments2 = new TreeMap();

        public void put1(int start, int newStart, int length) {
            this.myFragments1.put(start, newStart);
            this.myFragments1.put(start + length, -1);
            this.myInvertedFragments1.put(newStart, start);
            this.myInvertedFragments1.put(newStart + length, -1);
        }

        public void put2(int start, int newStart, int length) {
            this.myFragments2.put(start, newStart);
            this.myFragments2.put(start + length, -1);
            this.myInvertedFragments2.put(newStart, start);
            this.myInvertedFragments2.put(newStart + length, -1);
        }

        @NotNull
        public LineNumberConvertor build() {
            LineNumberConvertor lineNumberConvertor = new LineNumberConvertor(this.myFragments1, this.myFragments2, this.myInvertedFragments1, this.myInvertedFragments2);
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Builder", "build"));
            }
            return lineNumberConvertor;
        }

        @NotNull
        public static LineNumberConvertor createLeft(int lines) {
            Builder builder = new Builder();
            builder.put1(0, 0, lines);
            LineNumberConvertor lineNumberConvertor = builder.build();
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Builder", "createLeft"));
            }
            return lineNumberConvertor;
        }

        @NotNull
        public static LineNumberConvertor createRight(int lines) {
            Builder builder = new Builder();
            builder.put2(0, 0, lines);
            LineNumberConvertor lineNumberConvertor = builder.build();
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Builder", "createRight"));
            }
            return lineNumberConvertor;
        }
    }
}

