/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideDiffChange {
    @NotNull
    private final MergeLineFragment myFragment;
    @NotNull
    private final List<EditorEx> myEditors;
    @NotNull
    private ConflictType myType;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    @NotNull
    private final List<RangeHighlighter> myActionHighlighters;
    private boolean myIsValid;
    private int[] myLineStartShifts;
    private int[] myLineEndShifts;

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull List<EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myActionHighlighters = new ArrayList<RangeHighlighter>();
        this.myIsValid = true;
        this.myLineStartShifts = new int[3];
        this.myLineEndShifts = new int[3];
        this.myFragment = fragment;
        this.myEditors = editors;
        this.myType = SimpleThreesideDiffChange.calcType(fragment, editors, policy);
        this.installHighlighter();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty());
        this.createHighlighter(ThreeSide.BASE);
        if (this.myType.isLeftChange()) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.myType.isRightChange()) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (RangeHighlighter highlighter : this.myActionHighlighters) {
            highlighter.dispose();
        }
        this.myActionHighlighters.clear();
    }

    private void createHighlighter(@NotNull ThreeSide side) {
        int start;
        int end;
        int endLine;
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "createHighlighter"));
        }
        Editor editor = (Editor)side.selectNotNull(this.myEditors);
        Document document = editor.getDocument();
        TextDiffType type = this.getDiffType();
        int startLine = this.myFragment.getStartLine(side);
        if (startLine == (endLine = this.myFragment.getEndLine(side))) {
            end = startLine < DiffUtil.getLineCount(document) ? document.getLineStartOffset(startLine) : document.getTextLength();
            start = end;
        } else {
            start = document.getLineStartOffset(startLine);
            end = document.getLineEndOffset(endLine - 1);
            if (end < document.getTextLength()) {
                ++end;
            }
        }
        this.myHighlighters.add(DiffDrawUtil.createHighlighter(editor, start, end, type));
        if (startLine == endLine) {
            if (startLine != 0) {
                this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM, true));
            }
        } else {
            this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, startLine, type, SeparatorPlacement.TOP));
            this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM));
        }
    }

    private void doInstallActionHighlighters() {
    }

    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getStartLine"));
        }
        return this.myFragment.getStartLine(side) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getEndLine"));
        }
        return this.myFragment.getEndLine(side) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = this.myType.getDiffType();
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public ConflictType getType() {
        ConflictType conflictType = this.myType;
        if (conflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getType"));
        }
        return conflictType;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "processChange"));
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        if (line2 <= oldLine1) {
            return false;
        }
        if (line1 >= oldLine2) {
            int n = side.getIndex();
            this.myLineStartShifts[n] = this.myLineStartShifts[n] + shift;
            int n2 = side.getIndex();
            this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + shift;
            return false;
        }
        if (line1 <= oldLine1 && line2 >= oldLine2) {
            int n = side.getIndex();
            this.myLineEndShifts[n] = this.myLineEndShifts[n] + shift;
            return false;
        }
        for (RangeHighlighter highlighter : this.myActionHighlighters) {
            highlighter.dispose();
        }
        this.myActionHighlighters.clear();
        this.myIsValid = false;
        return true;
    }

    @NotNull
    private static ConflictType calcType(@NotNull MergeLineFragment fragment, @NotNull List<EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
        }
        if (SimpleThreesideDiffChange.compareSubstring(fragment, editors, ThreeSide.LEFT, ThreeSide.RIGHT, policy)) {
            ConflictType conflictType = new ConflictType(SimpleThreesideDiffChange.getDiffType(fragment, ThreeSide.LEFT));
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
            }
            return conflictType;
        }
        if (SimpleThreesideDiffChange.compareSubstring(fragment, editors, ThreeSide.BASE, ThreeSide.LEFT)) {
            ConflictType conflictType = new ConflictType(SimpleThreesideDiffChange.getDiffType(fragment, ThreeSide.RIGHT), false, true);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
            }
            return conflictType;
        }
        if (SimpleThreesideDiffChange.compareSubstring(fragment, editors, ThreeSide.BASE, ThreeSide.RIGHT)) {
            ConflictType conflictType = new ConflictType(SimpleThreesideDiffChange.getDiffType(fragment, ThreeSide.LEFT), true, false);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
            }
            return conflictType;
        }
        ConflictType conflictType = new ConflictType(TextDiffType.CONFLICT);
        if (conflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
        }
        return conflictType;
    }

    private static boolean compareSubstring(@NotNull MergeLineFragment fragment, @NotNull List<EditorEx> editors, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        if (side1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        if (side2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        return SimpleThreesideDiffChange.compareSubstring(fragment, editors, side1, side2, ComparisonPolicy.DEFAULT);
    }

    private static boolean compareSubstring(@NotNull MergeLineFragment fragment, @NotNull List<EditorEx> editors, @NotNull ThreeSide side1, @NotNull ThreeSide side2, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        if (side1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        if (side2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareSubstring"));
        }
        CharSequence content1 = SimpleThreesideDiffChange.getRangeContent(fragment, editors, side1);
        CharSequence content2 = SimpleThreesideDiffChange.getRangeContent(fragment, editors, side2);
        return ComparisonManager.getInstance().isEquals(content1, content2, policy);
    }

    @NotNull
    private static CharSequence getRangeContent(@NotNull MergeLineFragment fragment, @NotNull List<EditorEx> editors, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getRangeContent"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getRangeContent"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getRangeContent"));
        }
        DocumentEx document = ((EditorEx)side.selectNotNull(editors)).getDocument();
        int line1 = fragment.getStartLine(side);
        int line2 = fragment.getEndLine(side);
        CharSequence charSequence = DiffUtil.getLinesContent(document, line1, line2);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getRangeContent"));
        }
        return charSequence;
    }

    @NotNull
    private static TextDiffType getDiffType(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getDiffType"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getDiffType"));
        }
        assert (side != ThreeSide.BASE);
        boolean isBaseEmpty = SimpleThreesideDiffChange.isIntervalEmpty(fragment, ThreeSide.BASE);
        boolean isVersionEmpty = SimpleThreesideDiffChange.isIntervalEmpty(fragment, side);
        if (!isBaseEmpty && !isVersionEmpty) {
            TextDiffType textDiffType = TextDiffType.MODIFIED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getDiffType"));
            }
            return textDiffType;
        }
        if (!isBaseEmpty) {
            TextDiffType textDiffType = TextDiffType.DELETED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getDiffType"));
            }
            return textDiffType;
        }
        if (!isVersionEmpty) {
            TextDiffType textDiffType = TextDiffType.INSERTED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getDiffType"));
            }
            return textDiffType;
        }
        throw new IllegalArgumentException();
    }

    private static boolean isIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "isIntervalEmpty"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "isIntervalEmpty"));
        }
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    public static class ConflictType {
        @NotNull
        private final TextDiffType myType;
        private final boolean myLeftChange;
        private final boolean myRightChange;

        public ConflictType(@NotNull TextDiffType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange$ConflictType", "<init>"));
            }
            this(type, true, true);
        }

        public ConflictType(@NotNull TextDiffType type, boolean leftChange, boolean rightChange) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange$ConflictType", "<init>"));
            }
            this.myType = type;
            this.myLeftChange = leftChange;
            this.myRightChange = rightChange;
        }

        @NotNull
        public TextDiffType getDiffType() {
            TextDiffType textDiffType = this.myType;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange$ConflictType", "getDiffType"));
            }
            return textDiffType;
        }

        public boolean isLeftChange() {
            return this.myLeftChange;
        }

        public boolean isRightChange() {
            return this.myRightChange;
        }

        public boolean isChange(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange$ConflictType", "isChange"));
            }
            return side.isLeft() ? this.myLeftChange : this.myRightChange;
        }
    }
}

