/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.threeside;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.threeside.ThreesideTextContentPanel;
import com.intellij.diff.tools.util.threeside.ThreesideTextDiffPanel;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideTextDiffViewer
extends TextDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(ThreesideTextDiffViewer.class);
    @NotNull
    private final EditorFactory myEditorFactory;
    @NotNull
    protected final ThreesideTextDiffPanel myPanel;
    @NotNull
    protected final ThreesideTextContentPanel myContentPanel;
    @NotNull
    protected final List<EditorEx> myEditors;
    @NotNull
    protected final List<DocumentContent> myActualContents;
    @NotNull
    private final List<MyEditorFocusListener> myEditorFocusListeners;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener1;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener2;
    @NotNull
    protected final TextDiffViewerBase.MySetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final MyScrollToLineHelper myScrollToLineHelper;
    @Nullable
    private SyncScrollSupport.ThreesideSyncScrollSupport mySyncScrollListener;
    @NotNull
    private ThreeSide myCurrentSide;

    public ThreesideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "<init>"));
        }
        super(context, request);
        this.myEditorFactory = EditorFactory.getInstance();
        this.myEditorFocusListeners = ContainerUtil.newArrayList((Object[])new MyEditorFocusListener[]{new MyEditorFocusListener(ThreeSide.LEFT), new MyEditorFocusListener(ThreeSide.BASE), new MyEditorFocusListener(ThreeSide.RIGHT)});
        this.myVisibleAreaListener1 = new MyVisibleAreaListener(Side.LEFT);
        this.myVisibleAreaListener2 = new MyVisibleAreaListener(Side.RIGHT);
        this.myScrollToLineHelper = new MyScrollToLineHelper();
        List contents = this.myRequest.getContents();
        this.myActualContents = ContainerUtil.newArrayList((Object[])new DocumentContent[]{(DocumentContent)contents.get(0), (DocumentContent)contents.get(1), (DocumentContent)contents.get(2)});
        this.myEditors = this.createEditors();
        List<JComponent> titlePanel = DiffUtil.createTextTitles(this.myRequest, this.myEditors);
        this.myCurrentSide = ThreeSide.BASE;
        this.myContentPanel = new ThreesideTextContentPanel((List<? extends Editor>)this.myEditors, titlePanel);
        this.myPanel = new ThreesideTextDiffPanel(this, this.myContentPanel, this, context);
        this.myEditorSettingsAction = new TextDiffViewerBase.MySetEditorSettingsAction();
        this.myEditorSettingsAction.applyDefaults();
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.processContextHints();
    }

    @Override
    protected void onDispose() {
        this.updateContextHints();
        super.onDispose();
    }

    @Override
    protected void onDisposeAwt() {
        this.destroyEditors();
        super.onDisposeAwt();
    }

    protected void processContextHints() {
        ThreeSide side = (ThreeSide)this.myContext.getUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE);
        if (side != null) {
            this.myCurrentSide = side;
        }
        this.myScrollToLineHelper.processContext();
    }

    protected void updateContextHints() {
        this.myContext.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE, (Object)this.myCurrentSide);
        this.myScrollToLineHelper.updateContext();
    }

    @NotNull
    protected List<EditorEx> createEditors() {
        boolean[] forceReadOnly = this.checkForceReadOnly();
        ArrayList<EditorEx> editors = new ArrayList<EditorEx>(3);
        for (int i = 0; i < this.myActualContents.size(); ++i) {
            DocumentContent content = this.myActualContents.get(i);
            EditorEx editor = DiffUtil.createEditor(content.getDocument(), this.myProject, forceReadOnly[i], true);
            DiffUtil.configureEditor(editor, content, this.myProject);
            editors.add(editor);
        }
        ((EditorEx)editors.get(0)).setVerticalScrollbarOrientation(0);
        ((EditorMarkupModel)((Object)((EditorEx)editors.get(1)).getMarkupModel())).setErrorStripeVisible(false);
        ArrayList<EditorEx> arrayList = editors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "createEditors"));
        }
        return arrayList;
    }

    private void destroyEditors() {
        for (EditorEx editor : this.myEditors) {
            this.myEditorFactory.releaseEditor((Editor)editor);
        }
    }

    @Override
    protected void installEditorListeners() {
        super.installEditorListeners();
        for (int i = 0; i < 3; ++i) {
            this.myEditors.get(i).getContentComponent().addFocusListener(this.myEditorFocusListeners.get(i));
        }
        this.myEditors.get(0).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener1);
        this.myEditors.get(1).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener1);
        this.myEditors.get(1).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener2);
        this.myEditors.get(2).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener2);
        SyncScrollSupport.SyncScrollable scrollable1 = this.getSyncScrollable(Side.LEFT);
        SyncScrollSupport.SyncScrollable scrollable2 = this.getSyncScrollable(Side.RIGHT);
        if (scrollable1 != null && scrollable2 != null) {
            this.mySyncScrollListener = new SyncScrollSupport.ThreesideSyncScrollSupport(this.myEditors, scrollable1, scrollable2);
        }
    }

    @Override
    public void destroyEditorListeners() {
        super.destroyEditorListeners();
        for (int i = 0; i < 3; ++i) {
            this.myEditors.get(i).getContentComponent().removeFocusListener(this.myEditorFocusListeners.get(i));
        }
        this.myEditors.get(0).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener1);
        this.myEditors.get(1).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener1);
        this.myEditors.get(1).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener2);
        this.myEditors.get(2).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener2);
        if (this.mySyncScrollListener != null) {
            this.mySyncScrollListener = null;
        }
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollListener != null) {
            this.mySyncScrollListener.myDuringSyncScroll = disable;
        }
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(event);
        this.myContentPanel.repaintDividers();
    }

    protected void scrollOnRediff() {
        this.myScrollToLineHelper.onRediff();
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myScrollToLineHelper.onSlowRediff();
    }

    @NotNull
    public JComponent getComponent() {
        ThreesideTextDiffPanel threesideTextDiffPanel = this.myPanel;
        if (threesideTextDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getComponent"));
        }
        return threesideTextDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = (EditorEx)this.myCurrentSide.selectNotNull(this.myEditors);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getCurrentEditor"));
        }
        return editorEx;
    }

    @Override
    @NotNull
    protected List<? extends EditorEx> getEditors() {
        List<EditorEx> list = this.myEditors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getEditors"));
        }
        return list;
    }

    @NotNull
    public ThreeSide getCurrentSide() {
        ThreeSide threeSide = this.myCurrentSide;
        if (threeSide == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getCurrentSide"));
        }
        return threeSide;
    }

    protected void scrollToLine(@NotNull ThreeSide side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "scrollToLine"));
        }
        Editor editor = (Editor)side.selectNotNull(this.myEditors);
        DiffUtil.scrollEditor(editor, line);
        this.myCurrentSide = side;
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (scrollToChangePolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToChangePolicy", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "doScrollToChange"));
        }
        return false;
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side var1);

    @Override
    protected boolean tryRediffSynchronously() {
        return this.myPanel.isWindowFocused();
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        EditorEx editor = this.getCurrentEditor();
        DocumentContent content = (DocumentContent)this.getCurrentSide().selectNotNull(this.myActualContents);
        int offset = editor.getCaretModel().getOffset();
        return content.getOpenFileDescriptor(offset);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 3) {
            return false;
        }
        if (!ThreesideTextDiffViewer.canShowContent((DiffContent)contents.get(0))) {
            return false;
        }
        if (!ThreesideTextDiffViewer.canShowContent((DiffContent)contents.get(1))) {
            return false;
        }
        return ThreesideTextDiffViewer.canShowContent((DiffContent)contents.get(2));
    }

    public static boolean canShowContent(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "canShowContent"));
        }
        return content instanceof DocumentContent;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getCurrentEditor();
        }
        return super.getData(dataId);
    }

    @NotNull
    protected Graphics2D getDividerGraphics(@NotNull Graphics g, @NotNull Component divider) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getDividerGraphics"));
        }
        if (divider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getDividerGraphics"));
        }
        int width = divider.getWidth();
        int editorHeight = this.myEditors.get(0).getComponent().getHeight();
        int dividerOffset = divider.getLocationOnScreen().y;
        int editorOffset = this.myEditors.get((int)0).getComponent().getLocationOnScreen().y;
        Graphics2D graphics2D = (Graphics2D)g.create(0, editorOffset - dividerOffset, width, editorHeight);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getDividerGraphics"));
        }
        return graphics2D;
    }

    private class MyScrollToLineHelper {
        protected boolean myShouldScroll = true;
        @Nullable
        private DiffUserDataKeysEx.ScrollToPolicy myScrollToChange;
        @Nullable
        private DiffUtil.EditorsVisiblePositions myEditorsPosition;
        @Nullable
        private LogicalPosition[] myCaretPosition;
        @Nullable
        private Pair<ThreeSide, Integer> myScrollToLine;

        private MyScrollToLineHelper() {
        }

        public void processContext() {
            this.myScrollToChange = (DiffUserDataKeysEx.ScrollToPolicy)((Object)ThreesideTextDiffViewer.this.myRequest.getUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE));
            this.myEditorsPosition = (DiffUtil.EditorsVisiblePositions)ThreesideTextDiffViewer.this.myRequest.getUserData(DiffUtil.EditorsVisiblePositions.KEY);
            this.myCaretPosition = (LogicalPosition[])ThreesideTextDiffViewer.this.myRequest.getUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION);
            this.myScrollToLine = (Pair)ThreesideTextDiffViewer.this.myRequest.getUserData(DiffUserDataKeys.SCROLL_TO_LINE_THREESIDE);
        }

        public void updateContext() {
            LogicalPosition[] carets = DiffUtil.getCaretPositions(ThreesideTextDiffViewer.this.myEditors);
            Point[] points = DiffUtil.getScrollingPositions(ThreesideTextDiffViewer.this.myEditors);
            DiffUtil.EditorsVisiblePositions editorsPosition = new DiffUtil.EditorsVisiblePositions(carets, points);
            ThreesideTextDiffViewer.this.myRequest.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, null);
            ThreesideTextDiffViewer.this.myRequest.putUserData(DiffUtil.EditorsVisiblePositions.KEY, (Object)editorsPosition);
            ThreesideTextDiffViewer.this.myRequest.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)carets);
            ThreesideTextDiffViewer.this.myRequest.putUserData(DiffUserDataKeys.SCROLL_TO_LINE_THREESIDE, null);
        }

        public void onSlowRediff() {
            if (this.myScrollToChange != null) {
                return;
            }
            if (this.myShouldScroll && this.myScrollToLine != null) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll && this.myCaretPosition != null) {
                this.myShouldScroll = !this.doScrollToPosition();
            }
        }

        public void onRediff() {
            if (this.myShouldScroll && this.myScrollToChange != null) {
                boolean bl = this.myShouldScroll = !ThreesideTextDiffViewer.this.doScrollToChange(this.myScrollToChange);
            }
            if (this.myShouldScroll && this.myScrollToLine != null) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll && this.myCaretPosition != null) {
                boolean bl = this.myShouldScroll = !this.doScrollToPosition();
            }
            if (this.myShouldScroll) {
                ThreesideTextDiffViewer.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
            }
            this.myShouldScroll = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doScrollToPosition() {
            if (this.myCaretPosition == null || this.myCaretPosition.length != 3) {
                return false;
            }
            ThreesideTextDiffViewer.this.myEditors.get(0).getCaretModel().moveToLogicalPosition(this.myCaretPosition[0]);
            ThreesideTextDiffViewer.this.myEditors.get(1).getCaretModel().moveToLogicalPosition(this.myCaretPosition[1]);
            ThreesideTextDiffViewer.this.myEditors.get(2).getCaretModel().moveToLogicalPosition(this.myCaretPosition[2]);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(this.myCaretPosition)) {
                try {
                    ThreesideTextDiffViewer.this.disableSyncScrollSupport(true);
                    DiffUtil.scrollToPoint(ThreesideTextDiffViewer.this.myEditors.get(0), this.myEditorsPosition.myPoints[0]);
                    DiffUtil.scrollToPoint(ThreesideTextDiffViewer.this.myEditors.get(1), this.myEditorsPosition.myPoints[1]);
                    DiffUtil.scrollToPoint(ThreesideTextDiffViewer.this.myEditors.get(2), this.myEditorsPosition.myPoints[2]);
                }
                finally {
                    ThreesideTextDiffViewer.this.disableSyncScrollSupport(false);
                }
            } else {
                ThreesideTextDiffViewer.this.getCurrentEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
            return true;
        }

        private boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            ThreeSide side = (ThreeSide)this.myScrollToLine.first;
            Integer line = (Integer)this.myScrollToLine.second;
            if (side.select(ThreesideTextDiffViewer.this.getEditors()) == null) {
                return false;
            }
            ThreesideTextDiffViewer.this.myCurrentSide = side;
            DiffUtil.scrollEditor((Editor)ThreesideTextDiffViewer.this.getCurrentEditor(), line);
            return true;
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        @NotNull
        Side mySide;

        public MyVisibleAreaListener(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$MyVisibleAreaListener", "<init>"));
            }
            this.mySide = side;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (ThreesideTextDiffViewer.this.mySyncScrollListener != null) {
                ThreesideTextDiffViewer.this.mySyncScrollListener.visibleAreaChanged(e);
            }
            if (Registry.is((String)"diff.divider.repainting.fix")) {
                ThreesideTextDiffViewer.this.myContentPanel.repaint();
            } else {
                ThreesideTextDiffViewer.this.myContentPanel.repaintDivider(this.mySide);
            }
        }
    }

    private class MyEditorFocusListener
    extends FocusAdapter {
        @NotNull
        private final ThreeSide mySide;

        private MyEditorFocusListener(ThreeSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$MyEditorFocusListener", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public void focusGained(FocusEvent e) {
            ThreesideTextDiffViewer.this.myCurrentSide = this.mySide;
        }
    }

    protected class ShowPartialDiffAction
    extends DumbAwareAction {
        @NotNull
        private final ThreeSide mySide1;
        @NotNull
        private final ThreeSide mySide2;

        public ShowPartialDiffAction(@NotNull ThreeSide side1, @NotNull ThreeSide side2, @Nullable String text, @NotNull String description, Icon icon) {
            if (side1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (side2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            super(text, description, icon);
            this.mySide1 = side1;
            this.mySide2 = side2;
        }

        public void actionPerformed(AnActionEvent e) {
            List contents = ThreesideTextDiffViewer.this.myRequest.getContents();
            List titles = ThreesideTextDiffViewer.this.myRequest.getContentTitles();
            SimpleDiffRequest request = new SimpleDiffRequest(ThreesideTextDiffViewer.this.myRequest.getTitle(), (DiffContent)this.mySide1.selectNotNull(contents), (DiffContent)this.mySide2.selectNotNull(contents), (String)this.mySide1.selectNotNull(titles), (String)this.mySide1.selectNotNull(titles));
            DiffManager.getInstance().showDiff(ThreesideTextDiffViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)ThreesideTextDiffViewer.this.myPanel));
        }
    }

    protected class ShowLeftRightPartialDiffAction
    extends ShowPartialDiffAction {
        public ShowLeftRightPartialDiffAction() {
            super(ThreeSide.LEFT, ThreeSide.RIGHT, DiffBundle.message((String)"merge.partial.diff.action.name", (Object[])new Object[0]), null, AllIcons.Diff.BranchDiff);
        }
    }

    protected class ShowBaseRightPartialDiffAction
    extends ShowPartialDiffAction {
        public ShowBaseRightPartialDiffAction() {
            super(ThreeSide.BASE, ThreeSide.RIGHT, DiffBundle.message((String)"merge.partial.diff.action.name.1.2", (Object[])new Object[0]), null, AllIcons.Diff.RightDiff);
        }
    }

    protected class ShowLeftBasePartialDiffAction
    extends ShowPartialDiffAction {
        public ShowLeftBasePartialDiffAction() {
            super(ThreeSide.LEFT, ThreeSide.BASE, DiffBundle.message((String)"merge.partial.diff.action.name.0.1", (Object[])new Object[0]), null, AllIcons.Diff.LeftDiff);
        }
    }
}

