/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.twoside;

import com.intellij.diff.tools.util.DiffSplitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideContentPanel
extends JPanel {
    @Nullable
    private final DiffSplitter mySplitter;

    public TwosideContentPanel(@NotNull List<JComponent> titleComponents, @Nullable JComponent editor1, @Nullable JComponent editor2) {
        if (titleComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleComponents", "com/intellij/diff/tools/util/twoside/TwosideContentPanel", "<init>"));
        }
        super(new BorderLayout());
        assert (titleComponents.size() == 2);
        if (editor1 != null && editor2 != null) {
            this.mySplitter = new DiffSplitter();
            this.mySplitter.setFirstComponent(new MyPanel(editor1, titleComponents.get(0)));
            this.mySplitter.setSecondComponent(new MyPanel(editor2, titleComponents.get(1)));
            this.mySplitter.setHonorComponentsMinimumSize(false);
            this.add((Component)((Object)this.mySplitter), "Center");
        } else {
            this.mySplitter = null;
            if (editor1 != null) {
                this.add((Component)new MyPanel(editor1, titleComponents.get(0)), "Center");
            } else if (editor2 != null) {
                this.add((Component)new MyPanel(editor2, titleComponents.get(1)), "Center");
            }
        }
    }

    public void setPainter(@Nullable DiffSplitter.Painter painter) {
        if (this.mySplitter != null) {
            this.mySplitter.setPainter(painter);
        }
    }

    public void repaintDivider() {
        if (this.mySplitter != null) {
            this.mySplitter.repaintDivider();
        }
    }

    private static class MyPanel
    extends JPanel {
        public MyPanel(@NotNull JComponent editor, @Nullable JComponent title) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/twoside/TwosideContentPanel$MyPanel", "<init>"));
            }
            super(new BorderLayout());
            this.add((Component)editor, "Center");
            if (title != null) {
                this.add((Component)title, "North");
            }
        }
    }
}

