/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class ConsoleHistoryModel
extends SimpleModificationTracker {
    private final ConsoleHistoryModel myMasterModel;
    private int myHistoryCursor = -1;
    private final LinkedList<String> myHistory;

    ConsoleHistoryModel(ConsoleHistoryModel masterModel) {
        this.myMasterModel = masterModel;
        this.myHistory = this.myMasterModel == null ? new LinkedList() : this.myMasterModel.myHistory;
    }

    ConsoleHistoryModel copy() {
        return new ConsoleHistoryModel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToHistory(@Nullable String statement) {
        if (StringUtil.isEmptyOrSpaces((String)statement)) {
            return;
        }
        int maxHistorySize = this.getMaxHistorySize();
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            this.incModificationCount();
            this.myHistoryCursor = -1;
            this.myHistory.remove(statement);
            int size = this.myHistory.size();
            if (size >= maxHistorySize && size > 0) {
                this.myHistory.removeLast();
            }
            this.myHistory.addFirst(statement);
        }
    }

    public int getMaxHistorySize() {
        return UISettings.getInstance().CONSOLE_COMMAND_HISTORY_LIMIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromHistory(String statement) {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            this.incModificationCount();
            this.myHistoryCursor = -1;
            this.myHistory.remove(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHistory() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return new ArrayList<String>(this.myHistory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistorySize() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return this.myHistory.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getHistoryNext() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            if (this.myHistoryCursor < this.myHistory.size() - 1) {
                return this.myHistory.get(++this.myHistoryCursor);
            }
            if (this.myHistoryCursor == this.myHistory.size() - 1) {
                ++this.myHistoryCursor;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getHistoryPrev() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            if (this.myHistoryCursor > 0) {
                return this.myHistory.get(--this.myHistoryCursor);
            }
            if (this.myHistoryCursor == 0) {
                --this.myHistoryCursor;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHistory(boolean next) {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return next ? this.myHistoryCursor <= this.myHistory.size() - 1 : this.myHistoryCursor >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryCursor() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return this.myHistoryCursor;
        }
    }
}

