/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageConsoleImpl
extends ConsoleViewImpl
implements LanguageConsoleView,
DataProvider {
    private final Project myProject;
    private final EditorEx myConsoleEditor;
    private final EditorEx myHistoryViewer;
    private final Document myEditorDocument;
    private final VirtualFile myVirtualFile;
    protected PsiFile myFile;
    private final JPanel myPanel;
    private String myTitle;
    @Nullable
    private String myPrompt;
    private ConsoleViewContentType myPromptAttributes;
    private Editor myCurrentEditor;
    private final AtomicBoolean myForceScrollToEnd;
    private final FocusChangeListener myFocusListener;

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        this(project, title, (VirtualFile)new LightVirtualFile(title, language, (CharSequence)""));
    }

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        this(project, title, virtualFile, null);
    }

    LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile lightFile, @Nullable PairFunction<VirtualFile, Project, PsiFile> psiFileFactory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (lightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lightFile", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        super(project, GlobalSearchScope.allScope((Project)project), true, true);
        this.myPanel = new JPanel((LayoutManager)((Object)new MyLayout()));
        this.myPrompt = "> ";
        this.myPromptAttributes = ConsoleViewContentType.USER_INPUT;
        this.myForceScrollToEnd = new AtomicBoolean(false);
        this.myFocusListener = new FocusChangeListener(){

            @Override
            public void focusGained(Editor editor) {
                LanguageConsoleImpl.this.myCurrentEditor = editor;
                if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
            }

            @Override
            public void focusLost(Editor editor) {
            }
        };
        this.myProject = project;
        this.myTitle = title;
        this.myVirtualFile = lightFile;
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myEditorDocument = FileDocumentManager.getInstance().getDocument(lightFile);
        if (this.myEditorDocument == null) {
            throw new AssertionError((Object)("no document for: " + lightFile));
        }
        this.myFile = psiFileFactory == null ? this.createFile(this.myProject, this.myVirtualFile) : (PsiFile)psiFileFactory.fun((Object)this.myVirtualFile, (Object)this.myProject);
        this.myConsoleEditor = (EditorEx)editorFactory.createEditor(this.myEditorDocument, this.myProject);
        this.myConsoleEditor.addFocusListener(this.myFocusListener);
        this.myCurrentEditor = this.myConsoleEditor;
        this.myHistoryViewer = (EditorEx)editorFactory.createViewer(((EditorFactoryImpl)editorFactory).createDocument(true), this.myProject);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LanguageConsoleImpl.this.installEditorFactoryListener();
            }
        }, this.myProject.getDisposed());
    }

    @Override
    protected EditorEx doCreateConsoleEditor() {
        return this.myHistoryViewer;
    }

    @Override
    protected void disposeEditor() {
    }

    @Override
    protected JComponent createCenterComponent() {
        this.initComponents();
        return this.myPanel;
    }

    @Override
    public JComponent getPreferredFocusableComponent() {
        return this.getConsoleEditor().getContentComponent();
    }

    private void initComponents() {
        this.setupComponents();
        this.myPanel.add(this.myHistoryViewer.getComponent());
        this.myPanel.add(this.myConsoleEditor.getComponent());
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)this);
        this.myHistoryViewer.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (LanguageConsoleImpl.this.myForceScrollToEnd.compareAndSet(true, false)) {
                    LanguageConsoleImpl.this.scrollToEnd();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.componentResized(e);
            }
        });
        this.setPromptInner(this.myPrompt);
    }

    @Override
    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        if (consoleEditorEnabled) {
            FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.myVirtualFile);
            this.myPanel.removeAll();
            this.myPanel.add(this.myHistoryViewer.getComponent());
            this.myPanel.add(this.myConsoleEditor.getComponent());
            this.myHistoryViewer.setHorizontalScrollbarVisible(false);
            this.myCurrentEditor = this.myConsoleEditor;
        } else {
            this.myPanel.removeAll();
            this.myPanel.add((Component)this.myHistoryViewer.getComponent(), "Center");
            this.myHistoryViewer.setHorizontalScrollbarVisible(true);
        }
    }

    private void setupComponents() {
        this.setupEditorDefault(this.myConsoleEditor);
        this.setupEditorDefault(this.myHistoryViewer);
        this.myHistoryViewer.getComponent().setMinimumSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.getComponent().setPreferredSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.setCaretEnabled(false);
        this.myConsoleEditor.setHorizontalScrollbarVisible(true);
        this.myConsoleEditor.addEditorMouseListener((EditorMouseListener)EditorActionUtil.createEditorPopupHandler("ConsoleEditorPopupMenu"));
        this.myConsoleEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myVirtualFile, this.myConsoleEditor.getColorsScheme(), this.myProject));
        this.myConsoleEditor.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visibleAreaChanged(VisibleAreaEvent e) {
                int offset = LanguageConsoleImpl.this.myConsoleEditor.getScrollingModel().getHorizontalScrollOffset();
                ScrollingModelEx model = LanguageConsoleImpl.this.myHistoryViewer.getScrollingModel();
                int historyOffset = model.getHorizontalScrollOffset();
                if (historyOffset != offset) {
                    try {
                        model.disableAnimation();
                        model.scrollHorizontally(offset);
                    }
                    finally {
                        model.enableAnimation();
                    }
                }
            }
        });
        this.myHistoryViewer.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (LanguageConsoleImpl.this.isConsoleEditorEnabled() && UIUtil.isReallyTypedEvent((KeyEvent)event)) {
                    LanguageConsoleImpl.this.myConsoleEditor.getContentComponent().requestFocus();
                    LanguageConsoleImpl.this.myConsoleEditor.processKeyTyped(event);
                }
            }
        });
        EmptyAction.registerActionShortcuts((JComponent)this.myHistoryViewer.getComponent(), (JComponent)this.myConsoleEditor.getComponent());
    }

    @Override
    public boolean isConsoleEditorEnabled() {
        return this.myPanel.getComponentCount() > 1;
    }

    protected void setupEditorDefault(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl", "setupEditorDefault"));
        }
        ConsoleViewUtil.setupConsoleEditor(editor, false, false);
        editor.getContentComponent().setFocusCycleRoot(false);
        editor.setHorizontalScrollbarVisible(false);
        editor.setVerticalScrollbarVisible(true);
        editor.setBorder(null);
        EditorSettings editorSettings = editor.getSettings();
        if (this.myHistoryViewer != editor) {
            editorSettings.setAdditionalLinesCount(1);
        }
        editorSettings.setAdditionalColumnsCount(1);
    }

    @Override
    @Nullable
    public String getPrompt() {
        return this.myPrompt;
    }

    @Override
    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/intellij/execution/console/LanguageConsoleImpl", "setPromptAttributes"));
        }
        this.myPromptAttributes = textAttributes;
    }

    @Override
    public void setPrompt(@Nullable String prompt) {
        this.myPrompt = prompt != null && !prompt.endsWith(" ") ? prompt + " " : prompt;
        this.setPromptInner(this.myPrompt);
    }

    private void setPromptInner(final @Nullable String prompt) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                LanguageConsoleImpl.this.myConsoleEditor.setPrefixTextAndAttributes(prompt, LanguageConsoleImpl.this.myPromptAttributes.getAttributes());
            }
        });
    }

    @Override
    public void setEditable(boolean editable) {
        this.myConsoleEditor.setRendererMode(!editable);
        this.setPromptInner(editable ? this.myPrompt : "");
    }

    @Override
    public boolean isEditable() {
        return !this.myConsoleEditor.isRendererMode();
    }

    @Override
    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public EditorEx getHistoryViewer() {
        EditorEx editorEx = this.myHistoryViewer;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getHistoryViewer"));
        }
        return editorEx;
    }

    @Override
    @NotNull
    public Document getEditorDocument() {
        Document document = this.myEditorDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getEditorDocument"));
        }
        return document;
    }

    @Override
    @NotNull
    public EditorEx getConsoleEditor() {
        EditorEx editorEx = this.myConsoleEditor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getConsoleEditor"));
        }
        return editorEx;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getTitle"));
        }
        return string;
    }

    @Override
    public void setTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/console/LanguageConsoleImpl", "setTitle"));
        }
        this.myTitle = title;
    }

    public String addToHistory(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistory"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistory"));
        }
        return this.addToHistoryInner(textRange, editor, false, preserveMarkup);
    }

    @NotNull
    public String prepareExecuteAction(boolean addToHistory, boolean preserveMarkup, boolean clearInput) {
        EditorEx editor = (EditorEx)this.getCurrentEditor();
        DocumentEx document = editor.getDocument();
        String text = document.getText();
        TextRange range = new TextRange(0, document.getTextLength());
        if (!clearInput) {
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
        if (addToHistory) {
            this.addToHistoryInner(range, editor, clearInput, preserveMarkup);
        } else if (clearInput) {
            this.setInputText("");
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "prepareExecuteAction"));
        }
        return string;
    }

    @NotNull
    protected String addToHistoryInner(final @NotNull TextRange textRange, final @NotNull EditorEx editor, boolean erase, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String result = this.addTextRangeToHistory(textRange, editor, preserveMarkup);
        if (erase) {
            DocumentUtil.writeInRunUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                }
            });
        }
        this.scrollToEnd();
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        return string;
    }

    public boolean shouldScrollHistoryToEnd() {
        Rectangle visibleArea = this.myHistoryViewer.getScrollingModel().getVisibleArea();
        Dimension contentSize = this.myHistoryViewer.getContentSize();
        return contentSize.getHeight() - visibleArea.getMaxY() < (double)(this.getMinHistoryLineCount() * this.myHistoryViewer.getLineHeight());
    }

    public static String printWithHighlighting(@NotNull LanguageConsoleView console, @NotNull Editor inputEditor, @NotNull TextRange textRange) {
        String text;
        EditorHighlighter highlighter;
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/LanguageConsoleImpl", "printWithHighlighting"));
        }
        if (inputEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputEditor", "com/intellij/execution/console/LanguageConsoleImpl", "printWithHighlighting"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "printWithHighlighting"));
        }
        if (inputEditor instanceof EditorWindow) {
            PsiFile file = ((EditorWindow)inputEditor).getInjectedFile();
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)console.getProject());
            String fullText = InjectedLanguageUtil.getUnescapedText(file, null, null);
            highlighter.setText((CharSequence)fullText);
            text = textRange.substring(fullText);
        } else {
            text = inputEditor.getDocument().getText(textRange);
            highlighter = ((EditorEx)inputEditor).getHighlighter();
        }
        SyntaxHighlighter syntax = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
        ((LanguageConsoleImpl)console).doAddPromptToHistory();
        if (syntax != null) {
            ConsoleViewUtil.printWithHighlighting(console, text, syntax);
        } else {
            console.print(text, ConsoleViewContentType.USER_INPUT);
        }
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        return text;
    }

    @NotNull
    protected String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        if (inputEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputEditor", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        String string = LanguageConsoleImpl.printWithHighlighting(this, inputEditor, textRange);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        return string;
    }

    protected void doAddPromptToHistory() {
        if (this.myPrompt != null) {
            this.print(this.myPrompt, this.myPromptAttributes);
        }
    }

    @Override
    public void dispose() {
        FileEditorManager editorManager;
        super.dispose();
        if (this.myHistoryViewer.isDisposed()) {
            return;
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myConsoleEditor);
        editorFactory.releaseEditor((Editor)this.myHistoryViewer);
        if (this.getProject().isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.getProject())).isFileOpen(this.myVirtualFile)) {
            editorManager.closeFile(this.myVirtualFile);
        }
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
            return this.myConsoleEditor;
        }
        if (this.getProject().isInitialized()) {
            Caret caret = this.myConsoleEditor.getCaretModel().getCurrentCaret();
            return FileEditorManagerEx.getInstanceEx(this.getProject()).getData(dataId, this.myConsoleEditor, caret);
        }
        return null;
    }

    private void installEditorFactoryListener() {
        FileEditorManagerAdapter fileEditorListener = new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/LanguageConsoleImpl$8", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/LanguageConsoleImpl$8", "fileOpened"));
                }
                if (LanguageConsoleImpl.this.myConsoleEditor == null || !Comparing.equal((Object)file, (Object)LanguageConsoleImpl.this.myVirtualFile)) {
                    return;
                }
                Editor selectedTextEditor = source.getSelectedTextEditor();
                for (FileEditor fileEditor : source.getAllEditors(file)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    EditorEx editor = (EditorEx)((TextEditor)fileEditor).getEditor();
                    editor.addFocusListener(LanguageConsoleImpl.this.myFocusListener);
                    if (selectedTextEditor == editor) {
                        LanguageConsoleImpl.this.myCurrentEditor = editor;
                    }
                    EmptyAction.registerActionShortcuts((JComponent)editor.getComponent(), (JComponent)LanguageConsoleImpl.this.myConsoleEditor.getComponent());
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/LanguageConsoleImpl$8", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/LanguageConsoleImpl$8", "fileClosed"));
                }
                if (!Comparing.equal((Object)file, (Object)LanguageConsoleImpl.this.myVirtualFile)) {
                    return;
                }
                if (!Boolean.TRUE.equals(file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN)) && LanguageConsoleImpl.this.myCurrentEditor != null && LanguageConsoleImpl.this.myCurrentEditor.isDisposed()) {
                    LanguageConsoleImpl.this.myCurrentEditor = null;
                }
            }
        };
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorListener);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
        if (editorManager.isFileOpen(this.myVirtualFile)) {
            fileEditorListener.fileOpened(editorManager, this.myVirtualFile);
        }
    }

    @Override
    @NotNull
    public Editor getCurrentEditor() {
        Editor editor = (Editor)ObjectUtils.notNull((Object)this.myCurrentEditor, (Object)this.myConsoleEditor);
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getCurrentEditor"));
        }
        return editor;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myFile.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getLanguage"));
        }
        return language;
    }

    @Override
    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/execution/console/LanguageConsoleImpl", "setLanguage"));
        }
        if (!(this.myVirtualFile instanceof LightVirtualFile)) {
            throw new UnsupportedOperationException();
        }
        LightVirtualFile virtualFile = (LightVirtualFile)this.myVirtualFile;
        virtualFile.setLanguage(language);
        virtualFile.setContent((Object)this.myEditorDocument, (CharSequence)this.myEditorDocument.getText(), false);
        FileContentUtil.reparseFiles((Project)this.myProject, Collections.singletonList(virtualFile), (boolean)false);
        this.myFile = this.createFile(this.myProject, (VirtualFile)virtualFile);
    }

    @Override
    public void setInputText(final @NotNull String query) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/execution/console/LanguageConsoleImpl", "setInputText"));
        }
        DocumentUtil.writeInRunUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                LanguageConsoleImpl.this.myConsoleEditor.getDocument().setText(query);
            }
        });
    }

    @NotNull
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleImpl", "createFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/execution/console/LanguageConsoleImpl", "createFile"));
        }
        PsiFile psiFile = (PsiFile)ObjectUtils.assertNotNull((Object)PsiManager.getInstance((Project)project).findFile(virtualFile));
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "createFile"));
        }
        return psiFile;
    }

    boolean isHistoryViewerForceAdditionalColumnsUsage() {
        return true;
    }

    int getMinHistoryLineCount() {
        return 2;
    }

    private class MyLayout
    extends AbstractLayoutManager {
        private MyLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public void layoutContainer(@NotNull Container parent) {
            EditorEx input;
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/console/LanguageConsoleImpl$MyLayout", "layoutContainer"));
            }
            int componentCount = parent.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            EditorEx history = LanguageConsoleImpl.this.myHistoryViewer;
            EditorEx editorEx = input = componentCount == 2 ? LanguageConsoleImpl.this.myConsoleEditor : null;
            if (input == null) {
                parent.getComponent(0).setBounds(parent.getBounds());
                return;
            }
            Dimension panelSize = parent.getSize();
            if (panelSize.getHeight() <= 0.0) {
                return;
            }
            Dimension historySize = history.getContentSize();
            Dimension inputSize = input.getContentSize();
            int width = Math.max(inputSize.width, historySize.width);
            if (LanguageConsoleImpl.this.isHistoryViewerForceAdditionalColumnsUsage()) {
                history.getSoftWrapModel().forceAdditionalColumnsUsage();
                input.getSettings().setAdditionalColumnsCount(2 + (width - inputSize.width) / EditorUtil.getSpaceWidth(0, input));
                history.getSettings().setAdditionalColumnsCount(2 + (width - historySize.width) / EditorUtil.getSpaceWidth(0, history));
            }
            if (history.getDocument().getLineCount() == 0) {
                historySize.height = 0;
            }
            int minHistoryHeight = historySize.height > 0 ? LanguageConsoleImpl.this.getMinHistoryLineCount() * history.getLineHeight() : 0;
            int minInputHeight = input.isViewer() ? 0 : input.getLineHeight();
            int inputPreferredHeight = input.isViewer() ? 0 : Math.max(minInputHeight, inputSize.height);
            int historyPreferredHeight = Math.max(minHistoryHeight, historySize.height);
            int newInputHeight = panelSize.height < minInputHeight ? panelSize.height : (panelSize.height < inputPreferredHeight ? panelSize.height - minHistoryHeight : (panelSize.height < inputPreferredHeight + historyPreferredHeight || inputPreferredHeight == 0 ? inputPreferredHeight : panelSize.height - historyPreferredHeight));
            int newHistoryHeight = panelSize.height - newInputHeight;
            input.getComponent().setBounds(0, newHistoryHeight, panelSize.width, newInputHeight);
            LanguageConsoleImpl.this.myForceScrollToEnd.compareAndSet(false, LanguageConsoleImpl.this.shouldScrollHistoryToEnd());
            history.getComponent().setBounds(0, 0, panelSize.width, newHistoryHeight);
        }
    }
}

