/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.StoringPropertyContainer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.Storage;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class TestConsoleProperties
extends StoringPropertyContainer
implements Disposable {
    public static final BooleanProperty SCROLL_TO_STACK_TRACE = new BooleanProperty("scrollToStackTrace", false);
    public static final BooleanProperty SORT_ALPHABETICALLY = new BooleanProperty("sortTestsAlphabetically", false);
    public static final BooleanProperty SELECT_FIRST_DEFECT = new BooleanProperty("selectFirtsDefect", false);
    public static final BooleanProperty TRACK_RUNNING_TEST = new BooleanProperty("trackRunningTest", true);
    public static final BooleanProperty HIDE_IGNORED_TEST = new BooleanProperty("hideIgnoredTests", false);
    public static final BooleanProperty HIDE_PASSED_TESTS = new BooleanProperty("hidePassedTests", true);
    public static final BooleanProperty SCROLL_TO_SOURCE = new BooleanProperty("scrollToSource", false);
    public static final BooleanProperty OPEN_FAILURE_LINE = new BooleanProperty("openFailureLine", true);
    public static final BooleanProperty TRACK_CODE_COVERAGE = new BooleanProperty("trackCodeCoverage", false);
    public static final BooleanProperty SHOW_STATISTICS = new BooleanProperty("showStatistics", false);
    public static final BooleanProperty INCLUDE_NON_STARTED_IN_RERUN_FAILED = new BooleanProperty("includeNonStarted", true);
    private final Project myProject;
    private final Executor myExecutor;
    private ConsoleView myConsole;
    private boolean myUsePredefinedMessageFilter = true;
    private GlobalSearchScope myScope;
    protected final HashMap<AbstractProperty, ArrayList<TestFrameworkPropertyListener>> myListeners = new HashMap();

    public TestConsoleProperties(Storage storage, Project project, Executor executor) {
        super(storage);
        this.myProject = project;
        this.myExecutor = executor;
    }

    public Project getProject() {
        return this.myProject;
    }

    public GlobalSearchScope getScope() {
        if (this.myScope == null) {
            this.myScope = this.initScope();
        }
        return this.myScope;
    }

    protected GlobalSearchScope initScope() {
        RunConfiguration configuration = this.getConfiguration();
        if (!(configuration instanceof ModuleRunProfile)) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        Module[] modules = ((ModuleRunProfile)configuration).getModules();
        if (modules.length == 0) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        GlobalSearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
        for (Module each : modules) {
            scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope((Module)each, (boolean)true));
        }
        return scope;
    }

    public <T> void addListener(AbstractProperty<T> property, TestFrameworkPropertyListener<T> listener) {
        ArrayList<TestFrameworkPropertyListener<Object>> listeners = this.myListeners.get(property);
        if (listeners == null) {
            listeners = new ArrayList();
            this.myListeners.put(property, listeners);
        }
        listeners.add(listener);
    }

    public <T> void addListenerAndSendValue(AbstractProperty<T> property, TestFrameworkPropertyListener<T> listener) {
        this.addListener(property, listener);
        listener.onChanged(property.get((AbstractProperty.AbstractPropertyContainer)this));
    }

    public <T> void removeListener(AbstractProperty<T> property, TestFrameworkPropertyListener listener) {
        ArrayList<TestFrameworkPropertyListener> listeners = this.myListeners.get(property);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    public boolean isDebug() {
        return this.myExecutor.getId() == DefaultDebugExecutor.EXECUTOR_ID;
    }

    public boolean isPaused() {
        XDebugSession debuggerSession = XDebuggerManager.getInstance((Project)this.myProject).getDebugSession(this.getConsole());
        return debuggerSession != null && debuggerSession.isPaused();
    }

    @Override
    protected <T> void onPropertyChanged(AbstractProperty<T> property, T value) {
        Object[] propertyListeners;
        ArrayList<TestFrameworkPropertyListener> listeners = this.myListeners.get(property);
        if (listeners == null) {
            return;
        }
        for (Object propertyListener : propertyListeners = listeners.toArray()) {
            TestFrameworkPropertyListener listener = (TestFrameworkPropertyListener)propertyListener;
            listener.onChanged(value);
        }
    }

    public void setConsole(ConsoleView console) {
        this.myConsole = console;
    }

    public void dispose() {
        this.myListeners.clear();
    }

    public abstract RunConfiguration getConfiguration();

    public boolean isEditable() {
        return false;
    }

    protected ExecutionConsole getConsole() {
        return this.myConsole;
    }

    public boolean isUsePredefinedMessageFilter() {
        return this.myUsePredefinedMessageFilter;
    }

    public void setUsePredefinedMessageFilter(boolean usePredefinedMessageFilter) {
        this.myUsePredefinedMessageFilter = usePredefinedMessageFilter;
    }
}

