/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.FileIconProvider;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.scratch.LightDirectoryIndex;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.scratch.ScratchWidget;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.WindowManagerListener;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ScratchFileService", storages={@Storage(file="$APP_CONFIG$/scratches.xml")})
public class ScratchFileServiceImpl
extends ScratchFileService
implements PersistentStateComponent<Element> {
    private static final RootType NULL_TYPE = new RootType("", null){};
    private final LightDirectoryIndex<RootType> myIndex;
    private final MyLanguages myScratchMapping = new MyLanguages();

    protected ScratchFileServiceImpl(WindowManager windowManager, MessageBus messageBus) {
        this.myIndex = new LightDirectoryIndex<RootType>(messageBus.connect(), NULL_TYPE){

            @Override
            protected void collectRoots(@NotNull PairConsumer<VirtualFile, RootType> consumer) {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/scratch/ScratchFileServiceImpl$2", "collectRoots"));
                }
                LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                for (RootType r : RootType.getAllRootIds()) {
                    String root = ScratchFileServiceImpl.this.getRootPath(r);
                    VirtualFile rootFile = fileSystem.findFileByPath(root);
                    if (rootFile == null) continue;
                    consumer.consume((Object)rootFile, (Object)r);
                }
            }
        };
        ScratchFileServiceImpl.initScratchWidget(windowManager);
        this.initFileOpenedListener(messageBus);
    }

    @Override
    @NotNull
    public String getRootPath(@NotNull RootType rootId) {
        if (rootId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootId", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getRootPath"));
        }
        String string = this.getRootPath() + "/" + rootId.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getRootPath"));
        }
        return string;
    }

    @Override
    @Nullable
    public RootType getRootType(@NotNull VirtualFile file) {
        VirtualFile directory;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getRootType"));
        }
        VirtualFile virtualFile = directory = file.isDirectory() ? file : file.getParent();
        if (!(directory instanceof VirtualFileWithId)) {
            return null;
        }
        RootType result = this.myIndex.getInfoForFile(directory);
        return result == NULL_TYPE ? null : result;
    }

    private void initFileOpenedListener(MessageBus messageBus) {
        final FileEditorManagerAdapter editorListener = new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/ScratchFileServiceImpl$3", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$3", "fileOpened"));
                }
                RootType rootType = ScratchFileServiceImpl.this.getRootType(file);
                if (rootType != null) {
                    rootType.fileOpened(file, source);
                }
            }
        };
        ProjectManagerAdapter projectListener = new ProjectManagerAdapter(){

            public void projectOpened(Project project) {
                project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)editorListener);
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                for (VirtualFile virtualFile : editorManager.getOpenFiles()) {
                    editorListener.fileOpened(editorManager, virtualFile);
                }
            }
        };
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            projectListener.projectOpened(project);
        }
        messageBus.connect().subscribe(ProjectManager.TOPIC, (Object)projectListener);
    }

    private static void initScratchWidget(WindowManager windowManager) {
        WindowManagerListener windowListener = new WindowManagerListener(){

            public void frameCreated(IdeFrame frame) {
                Project project = frame.getProject();
                StatusBar statusBar = frame.getStatusBar();
                if (project == null || statusBar == null || statusBar.getWidget("Scratch") != null) {
                    return;
                }
                ScratchWidget widget = new ScratchWidget(project);
                statusBar.addWidget((StatusBarWidget)widget, "before Encoding", (Disposable)project);
                statusBar.updateWidget("Scratch");
            }

            public void beforeFrameReleased(IdeFrame frame) {
            }
        };
        for (IdeFrame frame : windowManager.getAllProjectFrames()) {
            windowListener.frameCreated(frame);
        }
        windowManager.addListener(windowListener);
    }

    @NotNull
    protected String getRootPath() {
        String string = FileUtil.toSystemIndependentName((String)PathManager.getConfigPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getRootPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public PerFileMappings<Language> getScratchesMapping() {
        MyLanguages myLanguages = this.myScratchMapping;
        if (myLanguages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getScratchesMapping"));
        }
        return myLanguages;
    }

    @Nullable
    public Element getState() {
        return this.myScratchMapping.getState();
    }

    public void loadState(Element state) {
        this.myScratchMapping.loadState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualFile findFile(@NotNull RootType rootType, @NotNull String pathName, ScratchFileService.Option option) throws IOException {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/ide/scratch/ScratchFileServiceImpl", "findFile"));
        }
        if (pathName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathName", "com/intellij/ide/scratch/ScratchFileServiceImpl", "findFile"));
        }
        String fullPath = this.getRootPath(rootType) + "/" + pathName;
        if (option != ScratchFileService.Option.create_new_always) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fullPath);
            if (file != null && !file.isDirectory()) {
                return file;
            }
            if (option == ScratchFileService.Option.existing_only) {
                return null;
            }
        }
        String ext = PathUtil.getFileExtension((String)pathName);
        String fileNameExt = PathUtil.getFileName((String)pathName);
        String fileName = StringUtil.trimEnd((String)fileNameExt, (String)(ext == null ? "" : "." + ext));
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());
        try {
            VirtualFile dir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)fullPath));
            if (option == ScratchFileService.Option.create_new_always) {
                VirtualFile virtualFile = VfsUtil.createChildSequent((Object)LocalFileSystem.getInstance(), (VirtualFile)dir, (String)fileName, (String)StringUtil.notNullize((String)ext));
                return virtualFile;
            }
            VirtualFile virtualFile = dir.createChildData((Object)LocalFileSystem.getInstance(), fileNameExt);
            return virtualFile;
        }
        finally {
            token.finish();
        }
    }

    public static class NavBarExtension
    extends AbstractNavBarModelExtension {
        @Override
        @Nullable
        public String getPresentableText(Object object) {
            if (!(object instanceof PsiElement)) {
                return null;
            }
            Project project = ((PsiElement)object).getProject();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)object));
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(virtualFile);
            if (rootType == null) {
                return null;
            }
            if (virtualFile.isDirectory()) {
                return this.additionalRoots(project).contains(virtualFile) ? rootType.getDisplayName() : null;
            }
            return rootType.substituteName(project, virtualFile);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> additionalRoots(Project project) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            ScratchFileService app = ScratchFileService.getInstance();
            for (RootType r : RootType.getAllRootIds()) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)fileSystem.findFileByPath(app.getRootPath(r)));
            }
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl$NavBarExtension", "additionalRoots"));
            }
            return linkedHashSet;
        }
    }

    public static class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        @Override
        public boolean isWritable(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$AccessExtension", "isWritable"));
            }
            return file.getFileType() == ScratchFileType.INSTANCE;
        }
    }

    public static class FilePresentation
    implements FileIconProvider,
    EditorTabTitleProvider {
        @Nullable
        public Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$FilePresentation", "getIcon"));
            }
            if (project == null || file.isDirectory()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file);
            if (rootType == null) {
                return null;
            }
            return rootType.substituteIcon(project, file);
        }

        @Override
        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileServiceImpl$FilePresentation", "getEditorTabTitle"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$FilePresentation", "getEditorTabTitle"));
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file);
            if (rootType == null) {
                return null;
            }
            return rootType.substituteName(project, file);
        }
    }

    public static class Highlighter
    implements SyntaxHighlighterProvider {
        @Nullable
        public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile file) {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/scratch/ScratchFileServiceImpl$Highlighter", "create"));
            }
            if (project == null || file == null) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file);
            if (rootType == null) {
                return null;
            }
            Language language = rootType.substituteLanguage(project, file);
            return language == null ? null : SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)file);
        }
    }

    public static class Substitutor
    extends LanguageSubstitutor {
        @Nullable
        public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$Substitutor", "getLanguage"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileServiceImpl$Substitutor", "getLanguage"));
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file);
            if (rootType == null) {
                return null;
            }
            return rootType.substituteLanguage(project, file);
        }
    }

    public static class TypeFactory
    extends FileTypeFactory {
        public void createFileTypes(@NotNull FileTypeConsumer consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/scratch/ScratchFileServiceImpl$TypeFactory", "createFileTypes"));
            }
            consumer.consume((FileType)ScratchFileType.INSTANCE);
        }
    }

    private static class MyLanguages
    extends PerFileMappingsBase<Language> {
        private MyLanguages() {
        }

        protected List<Language> getAvailableValues() {
            return LanguageUtil.getFileLanguages();
        }

        @Nullable
        protected String serialize(Language language) {
            return language.getID();
        }

        @Nullable
        protected Language handleUnknownMapping(VirtualFile file, String value) {
            return PlainTextLanguage.INSTANCE;
        }

        @Nullable
        public Language getMapping(@Nullable VirtualFile file) {
            Language language = (Language)super.getMapping(file);
            if (language == null && file != null && file.getFileType() == ScratchFileType.INSTANCE) {
                String extension = file.getExtension();
                FileType fileType = extension == null ? null : FileTypeManager.getInstance().getFileTypeByExtension(extension);
                language = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
            }
            return language;
        }
    }
}

