/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.beans;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class ConvertUsagesUtil {
    private static final char GROUP_SEPARATOR = ':';
    private static final char GROUPS_SEPARATOR = ';';
    private static final char GROUP_VALUE_SEPARATOR = ',';

    private ConvertUsagesUtil() {
    }

    public static <T extends UsageDescriptor> String convertUsages(Map<GroupDescriptor, Set<T>> map) {
        assert (map != null);
        Map<GroupDescriptor, Set<T>> sortedMap = ConvertUsagesUtil.sortDescriptorsByPriority(map);
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<GroupDescriptor, Set<T>> entry : sortedMap.entrySet()) {
            String value = ConvertUsagesUtil.convertValueMap(entry.getValue());
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            buffer.append(entry.getKey().getId());
            buffer.append(':');
            buffer.append(value);
            buffer.append(';');
        }
        return buffer.toString();
    }

    public static String convertValueMap(Set<? extends UsageDescriptor> descriptors) {
        assert (descriptors != null);
        if (descriptors.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (UsageDescriptor usageDescriptor : descriptors) {
            int value = usageDescriptor.getValue();
            if (value == 0) continue;
            buffer.append(usageDescriptor.getKey());
            buffer.append("=");
            buffer.append(value);
            buffer.append(',');
        }
        if (buffer.length() == 0) {
            return "";
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String cutDataString(String patchStr, int maxSize) {
        assert (patchStr != null);
        for (int i = maxSize - 1; i >= 0; --i) {
            char c = patchStr.charAt(i);
            if (c != ';' && c != ',') continue;
            return patchStr.substring(0, i);
        }
        return "";
    }

    public static Map<GroupDescriptor, Set<UsageDescriptor>> convertString(String usages) {
        assert (usages != null);
        HashMap<GroupDescriptor, Set<UsageDescriptor>> descriptors = new HashMap<GroupDescriptor, Set<UsageDescriptor>>();
        for (String groupStr : usages.split(Character.toString(';'))) {
            StringPair group;
            if (ConvertUsagesUtil.isEmptyOrSpaces(groupStr) || (group = ConvertUsagesUtil.getPair(groupStr, Character.toString(':'))) == null) continue;
            String groupId = group.first;
            assert (groupId != null);
            if (groupId.length() >= 30) continue;
            descriptors.putAll(ConvertUsagesUtil.convertValueString(GroupDescriptor.create(groupId), group.second));
        }
        return descriptors;
    }

    public static Map<GroupDescriptor, Set<UsageDescriptor>> convertValueString(GroupDescriptor groupId, String valueData) {
        assert (groupId != null);
        HashMap<GroupDescriptor, Set<UsageDescriptor>> descriptors = new HashMap<GroupDescriptor, Set<UsageDescriptor>>();
        for (String value : valueData.split(Character.toString(','))) {
            String count;
            StringPair pair;
            if (ConvertUsagesUtil.isEmptyOrSpaces(value) || (pair = ConvertUsagesUtil.getPair(value, "=")) == null || ConvertUsagesUtil.isEmptyOrSpaces(count = pair.second)) continue;
            try {
                int i = Integer.parseInt(count);
                if (!descriptors.containsKey(groupId)) {
                    descriptors.put(groupId, new LinkedHashSet());
                }
                ((Set)descriptors.get(groupId)).add(new UsageDescriptor(pair.first, i));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return descriptors;
    }

    public static StringPair getPair(String str, String separator) {
        assert (str != null);
        assert (separator != null);
        int i = str.indexOf(separator);
        if (i > 0 && i < str.length() - 1) {
            String key = str.substring(0, i).trim();
            String value = str.substring(i + 1).trim();
            if (!ConvertUsagesUtil.isEmptyOrSpaces(key) && !ConvertUsagesUtil.isEmptyOrSpaces(value)) {
                return new StringPair(key, value);
            }
        }
        return null;
    }

    public static <T extends UsageDescriptor> Map<GroupDescriptor, Set<T>> sortDescriptorsByPriority(Map<GroupDescriptor, Set<T>> descriptors) {
        assert (descriptors != null);
        TreeMap<GroupDescriptor, Set<T>> map = new TreeMap<GroupDescriptor, Set<T>>(new Comparator<GroupDescriptor>(){

            @Override
            public int compare(GroupDescriptor g1, GroupDescriptor g2) {
                int priority = (int)(g2.getPriority() - g1.getPriority());
                return priority == 0 ? g1.getId().compareTo(g2.getId()) : priority;
            }
        });
        map.putAll(descriptors);
        return map;
    }

    @NotNull
    public static String escapeDescriptorName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/internal/statistic/beans/ConvertUsagesUtil", "escapeDescriptorName"));
        }
        String string = name.replace(" ", "_").replace(':', '_').replace(';', '_').replace(',', '_').replace("'", " ").replace("\"", " ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/beans/ConvertUsagesUtil", "escapeDescriptorName"));
        }
        return string;
    }

    public static boolean isEmptyOrSpaces(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void assertDescriptorName(String key) {
        assert (key != null);
        assert (key.indexOf(58) == -1) : key + " contains invalid chars";
        assert (key.indexOf(59) == -1) : key + " contains invalid chars";
        assert (key.indexOf(44) == -1) : key + " contains invalid chars";
        assert (!key.contains("=")) : key + " contains invalid chars";
        assert (!key.contains("'")) : key + " contains invalid chars";
        assert (!key.contains("\"")) : key + " contains invalid chars";
    }

    public static String ensureProperKey(String input) {
        StringBuilder escaped = new StringBuilder();
        block3: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    escaped.append(' ');
                    continue block3;
                }
                default: {
                    escaped.append(ch);
                }
            }
        }
        return escaped.toString();
    }

    private static class StringPair {
        public final String first;
        public final String second;

        public StringPair(String first, String second) {
            this.first = first;
            this.second = second;
        }
    }
}

