/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.connect.StatisticsServiceEP;
import com.intellij.internal.statistic.updater.StatisticsNotificationManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Alarm;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class SendStatisticsComponent
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(SendStatisticsComponent.class);
    private static final int DELAY_IN_MIN = 10;
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());

    public SendStatisticsComponent() {
        NotificationsConfigurationImpl.remove("SendUsagesStatistics");
        NotificationsConfiguration.getNotificationsConfiguration().register("IDE Usage Statistics", NotificationDisplayType.STICKY_BALLOON, false);
    }

    private void runStatisticsService() {
        StatisticsService statisticsService = StatisticsUploadAssistant.getStatisticsService();
        if (StatisticsUploadAssistant.showNotification()) {
            StatisticsNotificationManager.showNotification(statisticsService);
        } else if (StatisticsUploadAssistant.isSendAllowed() && StatisticsUploadAssistant.isTimeToSend()) {
            StatisticsService serviceToUse = null;
            StatisticsServiceEP[] extensions = (StatisticsServiceEP[])StatisticsService.EP_NAME.getExtensions();
            if (extensions.length > 1) {
                LOG.warn(String.format("More than one stats service detected (%s). Falling back to the built-in one", Arrays.toString((Object[])extensions)));
            } else if (extensions.length == 1) {
                serviceToUse = extensions[0].getInstance();
            }
            if (serviceToUse == null) {
                serviceToUse = statisticsService;
            }
            this.runWithDelay(serviceToUse);
        }
    }

    private void runWithDelay(final @NotNull StatisticsService statisticsService) {
        if (statisticsService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statisticsService", "com/intellij/internal/statistic/updater/SendStatisticsComponent", "runWithDelay"));
        }
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                statisticsService.send();
            }
        }, 600000);
    }

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.runStatisticsService();
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        String string = SendStatisticsComponent.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/updater/SendStatisticsComponent", "getComponentName"));
        }
        return string;
    }
}

