/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.InplaceActionButtonLook;
import com.intellij.openapi.actionSystem.impl.MacToolbarDecoratorButtonLook;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ToolbarUpdater;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class ActionToolbarImpl
extends JPanel
implements ActionToolbar {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.ActionToolbarImpl");
    private static final List<ActionToolbarImpl> ourToolbars = new LinkedList<ActionToolbarImpl>();
    private static final String RIGHT_ALIGN_KEY = "RIGHT_ALIGN";
    private final List<Rectangle> myComponentBounds;
    private Dimension myMinimumButtonSize;
    private int myLayoutPolicy;
    private int myOrientation;
    private final ActionGroup myActionGroup;
    private final String myPlace;
    protected List<AnAction> myVisibleActions;
    private final PresentationFactory myPresentationFactory;
    private final boolean myDecorateButtons;
    private final ToolbarUpdater myUpdater;
    private boolean myAdjustTheSameSize;
    private final ActionButtonLook myButtonLook;
    private final ActionButtonLook myMinimalButtonLook;
    private final DataManager myDataManager;
    protected final ActionManagerEx myActionManager;
    private Rectangle myAutoPopupRec;
    private final DefaultActionGroup mySecondaryActions;
    private boolean myMinimalMode;
    private boolean myForceUseMacEnhancements;
    private ActionButton mySecondaryActionsButton;
    private int myFirstOutsideIndex;
    private JBPopup myPopup;
    private JComponent myTargetComponent;
    private boolean myReservePlaceAutoPopupIcon;
    private boolean myAddSeparatorFirst;

    public static void updateAllToolbarsImmediately() {
        for (ActionToolbarImpl toolbar : new ArrayList<ActionToolbarImpl>(ourToolbars)) {
            toolbar.updateActionsImmediately();
            for (Component c : toolbar.getComponents()) {
                if (!(c instanceof ActionButton)) continue;
                ((ActionButton)c).updateToolTipText();
                ((ActionButton)c).updateIcon();
            }
        }
    }

    public ActionButton getSecondaryActionsButton() {
        return this.mySecondaryActionsButton;
    }

    public ActionToolbarImpl(String place, @NotNull ActionGroup actionGroup, boolean horizontal, @NotNull DataManager dataManager, @NotNull ActionManagerEx actionManager, @NotNull KeymapManagerEx keymapManager) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (dataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (keymapManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymapManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        this(place, actionGroup, horizontal, false, dataManager, actionManager, keymapManager, false);
    }

    public ActionToolbarImpl(String place, @NotNull ActionGroup actionGroup, boolean horizontal, boolean decorateButtons, @NotNull DataManager dataManager, @NotNull ActionManagerEx actionManager, @NotNull KeymapManagerEx keymapManager) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (dataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (keymapManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymapManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        this(place, actionGroup, horizontal, decorateButtons, dataManager, actionManager, keymapManager, false);
    }

    public ActionToolbarImpl(String place, @NotNull ActionGroup actionGroup, boolean horizontal, boolean decorateButtons, @NotNull DataManager dataManager, @NotNull ActionManagerEx actionManager, @NotNull KeymapManagerEx keymapManager, boolean updateActionsNow) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (dataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        if (keymapManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymapManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "<init>"));
        }
        super(null);
        this.myComponentBounds = new ArrayList<Rectangle>();
        this.myMinimumButtonSize = JBUI.emptySize();
        this.myPresentationFactory = new PresentationFactory();
        this.myButtonLook = null;
        this.myMinimalButtonLook = new InplaceActionButtonLook();
        this.mySecondaryActions = new DefaultActionGroup();
        this.myFirstOutsideIndex = -1;
        this.myReservePlaceAutoPopupIcon = true;
        this.myActionManager = actionManager;
        this.myPlace = place;
        this.myActionGroup = actionGroup;
        this.myVisibleActions = new ArrayList<AnAction>();
        this.myDataManager = dataManager;
        this.myDecorateButtons = decorateButtons;
        this.myUpdater = new ToolbarUpdater(actionManager, keymapManager, this){

            @Override
            protected void updateActionsImpl(boolean transparentOnly, boolean forced) {
                ActionToolbarImpl.this.updateActionsImpl(transparentOnly, forced);
            }
        };
        this.setLayout(new BorderLayout());
        this.setOrientation(horizontal ? 0 : 1);
        this.mySecondaryActions.getTemplatePresentation().setIcon(AllIcons.General.SecondaryGroup);
        this.mySecondaryActions.setPopup(true);
        this.myUpdater.updateActions(updateActionsNow, false);
        this.enableEvents(51L);
        this.setMiniMode(false);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        for (Component component : this.getComponents()) {
            this.tweakActionComponentUI(component);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ourToolbars.add(this);
        this.updateActionsImmediately();
    }

    private boolean doMacEnhancementsForMainToolbar() {
        return UIUtil.isUnderAquaLookAndFeel() && ("MainToolbar".equals(this.myPlace) || this.myForceUseMacEnhancements);
    }

    public void setForceUseMacEnhancements(boolean useMacEnhancements) {
        this.myForceUseMacEnhancements = useMacEnhancements;
    }

    private boolean isInsideNavBar() {
        return "NavBarToolbar".equals(this.myPlace);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ourToolbars.remove(this);
    }

    public JComponent getComponent() {
        return this;
    }

    public int getLayoutPolicy() {
        return this.myLayoutPolicy;
    }

    public void setLayoutPolicy(int layoutPolicy) {
        if (layoutPolicy != 0 && layoutPolicy != 1 && layoutPolicy != 2) {
            throw new IllegalArgumentException("wrong layoutPolicy: " + layoutPolicy);
        }
        this.myLayoutPolicy = layoutPolicy;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.doMacEnhancementsForMainToolbar()) {
            Rectangle r = this.getBounds();
            UIUtil.drawGradientHToolbarBackground((Graphics)g, (int)r.width, (int)r.height);
        } else {
            super.paintComponent(g);
        }
        if (this.myLayoutPolicy == 2 && this.myAutoPopupRec != null) {
            if (this.myOrientation == 0) {
                int dy = this.myAutoPopupRec.height / 2 - AllIcons.Ide.Link.getIconHeight() / 2;
                AllIcons.Ide.Link.paintIcon(this, g, (int)this.myAutoPopupRec.getMaxX() - AllIcons.Ide.Link.getIconWidth() - 1, this.myAutoPopupRec.y + dy);
            } else {
                int dx = this.myAutoPopupRec.width / 2 - AllIcons.Ide.Link.getIconWidth() / 2;
                AllIcons.Ide.Link.paintIcon(this, g, this.myAutoPopupRec.x + dx, (int)this.myAutoPopupRec.getMaxY() - AllIcons.Ide.Link.getIconWidth() - 1);
            }
        }
    }

    private void fillToolBar(List<AnAction> actions, boolean layoutSecondaries) {
        ArrayList<AnAction> rightAligned = new ArrayList<AnAction>();
        if (this.myAddSeparatorFirst) {
            this.add(new MySeparator());
        }
        for (int i = 0; i < actions.size(); ++i) {
            AnAction action = actions.get(i);
            if (action instanceof RightAlignedToolbarAction) {
                rightAligned.add(action);
                continue;
            }
            if (layoutSecondaries && !this.myActionGroup.isPrimary(action)) {
                this.mySecondaryActions.add(action);
                continue;
            }
            if (action instanceof Separator) {
                if (i <= 0 || i >= actions.size() - 1) continue;
                this.add(new MySeparator());
                continue;
            }
            if (action instanceof CustomComponentAction) {
                this.add(this.getCustomComponent(action));
                continue;
            }
            this.add(this.createToolbarButton(action));
        }
        if (this.mySecondaryActions.getChildrenCount() > 0) {
            this.mySecondaryActionsButton = new ActionButton((AnAction)this.mySecondaryActions, this.myPresentationFactory.getPresentation((AnAction)this.mySecondaryActions), this.myPlace, this.getMinimumButtonSize());
            this.mySecondaryActionsButton.setNoIconsInPopup(true);
            this.add(this.mySecondaryActionsButton);
        }
        for (AnAction action : rightAligned) {
            JComponent button = action instanceof CustomComponentAction ? this.getCustomComponent(action) : this.createToolbarButton(action);
            button.putClientProperty(RIGHT_ALIGN_KEY, Boolean.TRUE);
            this.add(button);
        }
    }

    private JComponent getCustomComponent(AnAction action) {
        Presentation presentation = this.myPresentationFactory.getPresentation(action);
        JComponent customComponent = ((CustomComponentAction)action).createCustomComponent(presentation);
        this.tweakActionComponentUI(customComponent);
        presentation.putClientProperty("customComponent", (Object)customComponent);
        return customComponent;
    }

    private void tweakActionComponentUI(@NotNull Component actionComponent) {
        if (actionComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionComponent", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "tweakActionComponentUI"));
        }
        if ("EditorToolbar".equals(this.myPlace)) {
            actionComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            actionComponent.setForeground(ColorUtil.dimmer((Color)JBColor.BLACK));
        }
    }

    private Dimension getMinimumButtonSize() {
        return this.isInsideNavBar() ? NAVBAR_MINIMUM_BUTTON_SIZE : DEFAULT_MINIMUM_BUTTON_SIZE;
    }

    public ActionButton createToolbarButton(AnAction action, ActionButtonLook look, String place, Presentation presentation, Dimension minimumSize) {
        if (action.displayTextInToolbar()) {
            return new ActionButtonWithText(action, presentation, place, minimumSize);
        }
        ActionButton actionButton = new ActionButton(action, presentation, place, minimumSize){

            @Override
            protected DataContext getDataContext() {
                return ActionToolbarImpl.this.getToolbarDataContext();
            }
        };
        actionButton.setLook(look);
        return actionButton;
    }

    private ActionButton createToolbarButton(AnAction action) {
        return this.createToolbarButton(action, this.myMinimalMode ? this.myMinimalButtonLook : (this.myDecorateButtons ? new MacToolbarDecoratorButtonLook() : this.myButtonLook), this.myPlace, this.myPresentationFactory.getPresentation(action), this.myMinimumButtonSize);
    }

    @Override
    public void doLayout() {
        int componentCount;
        if (!this.isValid()) {
            this.calculateBounds(this.getSize(), this.myComponentBounds);
        }
        LOG.assertTrue((componentCount = this.getComponentCount()) <= this.myComponentBounds.size());
        for (int i = componentCount - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            component.setBounds(this.myComponentBounds.get(i));
        }
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            this.calculateBounds(this.getSize(), this.myComponentBounds);
            super.validate();
        }
    }

    private Dimension getChildPreferredSize(int index) {
        Component component = this.getComponent(index);
        return component.isVisible() ? component.getPreferredSize() : new Dimension();
    }

    private int getMaxButtonWidth() {
        int width = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Dimension dimension = this.getChildPreferredSize(i);
            width = Math.max(width, dimension.width);
        }
        return width;
    }

    public int getMaxButtonHeight() {
        int height = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Dimension dimension = this.getChildPreferredSize(i);
            height = Math.max(height, dimension.height);
        }
        return height;
    }

    private void calculateBoundsNowrapImpl(List<Rectangle> bounds) {
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        if (this.myAdjustTheSameSize) {
            int maxWidth = this.getMaxButtonWidth();
            int maxHeight = this.getMaxButtonHeight();
            if (this.myOrientation == 0) {
                int xOffset = insets.left;
                for (int i = 0; i < componentCount; ++i) {
                    Rectangle r = bounds.get(i);
                    r.setBounds(xOffset, (height - maxHeight) / 2, maxWidth, maxHeight);
                    xOffset += maxWidth;
                }
            } else {
                int yOffset = insets.top;
                for (int i = 0; i < componentCount; ++i) {
                    Rectangle r = bounds.get(i);
                    r.setBounds((width - maxWidth) / 2, yOffset, maxWidth, maxHeight);
                    yOffset += maxHeight;
                }
            }
        } else if (this.myOrientation == 0) {
            int maxHeight = this.getMaxButtonHeight();
            int xOffset = insets.left;
            int yOffset = insets.top;
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = this.getChildPreferredSize(i);
                Rectangle r = bounds.get(i);
                r.setBounds(xOffset, yOffset + (maxHeight - d.height) / 2, d.width, d.height);
                xOffset += d.width;
            }
        } else {
            int maxWidth = this.getMaxButtonWidth();
            int xOffset = insets.left;
            int yOffset = insets.top;
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = this.getChildPreferredSize(i);
                Rectangle r = bounds.get(i);
                r.setBounds(xOffset + (maxWidth - d.width) / 2, yOffset, d.width, d.height);
                yOffset += d.height;
            }
        }
    }

    private void calculateBoundsAutoImp(Dimension sizeToFit, List<Rectangle> bounds) {
        boolean actualLayout;
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        boolean bl = actualLayout = bounds == this.myComponentBounds;
        if (actualLayout) {
            this.myAutoPopupRec = null;
        }
        int autoButtonSize = AllIcons.Ide.Link.getIconWidth();
        boolean full = false;
        Insets insets = this.getInsets();
        if (this.myOrientation == 0) {
            int eachX = insets.left;
            int eachY = insets.top;
            int maxHeight = 0;
            for (int i = 0; i < componentCount; ++i) {
                Component eachComp = this.getComponent(i);
                boolean isLast = i == componentCount - 1;
                Rectangle eachBound = new Rectangle(this.getChildPreferredSize(i));
                maxHeight = Math.max(eachBound.height, maxHeight);
                if (!full) {
                    boolean inside;
                    if (isLast) {
                        inside = eachX + eachBound.width <= sizeToFit.width;
                    } else {
                        boolean bl2 = inside = eachX + eachBound.width + autoButtonSize <= sizeToFit.width;
                    }
                    if (inside) {
                        if (eachComp == this.mySecondaryActionsButton) {
                            assert (isLast);
                            if (sizeToFit.width != Integer.MAX_VALUE) {
                                eachBound.x = sizeToFit.width - eachBound.width;
                                eachX = (int)eachBound.getMaxX();
                            } else {
                                eachBound.x = eachX;
                            }
                        } else {
                            eachBound.x = eachX;
                            eachX += eachBound.width;
                        }
                        eachBound.y = eachY;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    if (this.myAutoPopupRec == null) {
                        this.myAutoPopupRec = new Rectangle(eachX, eachY, sizeToFit.width - eachX - 1, sizeToFit.height - 1);
                        this.myFirstOutsideIndex = i;
                    }
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                bounds.get(i).setBounds(eachBound);
            }
            for (Rectangle r : bounds) {
                if (r.height >= maxHeight) continue;
                r.y += (maxHeight - r.height) / 2;
            }
        } else {
            int eachX = insets.left;
            int eachY = insets.top;
            for (int i = 0; i < componentCount; ++i) {
                Rectangle eachBound = new Rectangle(this.getChildPreferredSize(i));
                if (!full) {
                    boolean outside;
                    if (i < componentCount - 1) {
                        outside = eachY + eachBound.height + autoButtonSize < sizeToFit.height;
                    } else {
                        boolean bl3 = outside = eachY + eachBound.height < sizeToFit.height;
                    }
                    if (outside) {
                        eachBound.x = eachX;
                        eachBound.y = eachY;
                        eachY += eachBound.height;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    if (this.myAutoPopupRec == null) {
                        this.myAutoPopupRec = new Rectangle(eachX, eachY, sizeToFit.width - 1, sizeToFit.height - eachY - 1);
                        this.myFirstOutsideIndex = i;
                    }
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                bounds.get(i).setBounds(eachBound);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateBoundsWrapImpl(Dimension sizeToFit, List<Rectangle> bounds) {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            try {
                this.setLayoutPolicy(0);
                this.calculateBoundsNowrapImpl(bounds);
            }
            finally {
                this.setLayoutPolicy(1);
            }
            return;
        }
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        Insets insets = this.getInsets();
        if (this.myAdjustTheSameSize) {
            if (this.myOrientation == 0) {
                int maxWidth = this.getMaxButtonWidth();
                int maxHeight = this.getMaxButtonHeight();
                int xOffset = insets.left;
                int yOffset = insets.top;
                int maxRowWidth = Math.max(sizeToFit.width, componentCount * maxWidth / 3);
                for (int i = 0; i < componentCount; ++i) {
                    if (xOffset + maxWidth > maxRowWidth) {
                        xOffset = insets.left;
                        yOffset += maxHeight;
                    }
                    Rectangle each = bounds.get(i);
                    each.setBounds(xOffset, yOffset, maxWidth, maxHeight);
                    xOffset += maxWidth;
                }
            } else {
                int maxWidth = this.getMaxButtonWidth();
                int maxHeight = this.getMaxButtonHeight();
                int xOffset = insets.left;
                int yOffset = insets.top;
                int maxRowHeight = Math.max(sizeToFit.height, componentCount * this.myMinimumButtonSize.height / 3);
                for (int i = 0; i < componentCount; ++i) {
                    if (yOffset + maxHeight > maxRowHeight) {
                        yOffset = insets.top;
                        xOffset += maxWidth;
                    }
                    Rectangle each = bounds.get(i);
                    each.setBounds(xOffset, yOffset, maxWidth, maxHeight);
                    yOffset += maxHeight;
                }
            }
        } else if (this.myOrientation == 0) {
            int rowHeight = 0;
            Dimension[] dims = new Dimension[componentCount];
            for (int i = 0; i < componentCount; ++i) {
                dims[i] = this.getChildPreferredSize(i);
                int height = dims[i].height;
                rowHeight = Math.max(rowHeight, height);
            }
            int xOffset = insets.left;
            int yOffset = insets.top;
            int maxRowWidth = Math.max(this.getWidth(), componentCount * this.myMinimumButtonSize.width / 3);
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = dims[i];
                if (xOffset + d.width > maxRowWidth) {
                    xOffset = insets.left;
                    yOffset += rowHeight;
                }
                Rectangle each = bounds.get(i);
                each.setBounds(xOffset, yOffset + (rowHeight - d.height) / 2, d.width, d.height);
                xOffset += d.width;
            }
        } else {
            int rowWidth = 0;
            Dimension[] dims = new Dimension[componentCount];
            for (int i = 0; i < componentCount; ++i) {
                dims[i] = this.getChildPreferredSize(i);
                int width = dims[i].width;
                rowWidth = Math.max(rowWidth, width);
            }
            int xOffset = insets.left;
            int yOffset = insets.top;
            int maxRowHeight = Math.max(this.getHeight(), componentCount * this.myMinimumButtonSize.height / 3);
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = dims[i];
                if (yOffset + d.height > maxRowHeight) {
                    yOffset = insets.top;
                    xOffset += rowWidth;
                }
                Rectangle each = bounds.get(i);
                each.setBounds(xOffset + (rowWidth - d.width) / 2, yOffset, d.width, d.height);
                yOffset += d.height;
            }
        }
    }

    private void calculateBounds(Dimension size2Fit, List<Rectangle> bounds) {
        bounds.clear();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            bounds.add(new Rectangle());
        }
        if (this.myLayoutPolicy == 0) {
            this.calculateBoundsNowrapImpl(bounds);
        } else if (this.myLayoutPolicy == 1) {
            this.calculateBoundsWrapImpl(size2Fit, bounds);
        } else if (this.myLayoutPolicy == 2) {
            this.calculateBoundsAutoImp(size2Fit, bounds);
        } else {
            throw new IllegalStateException("unknown layoutPolicy: " + this.myLayoutPolicy);
        }
        if (this.getComponentCount() > 0 && size2Fit.width < Integer.MAX_VALUE) {
            int i;
            int maxHeight = 0;
            for (i = 0; i < bounds.size() - 2; ++i) {
                maxHeight = Math.max(maxHeight, bounds.get((int)i).height);
            }
            i = this.getComponentCount() - 1;
            int j = 1;
            while (i > 0) {
                Component component = this.getComponent(i);
                if (component instanceof JComponent && ((JComponent)component).getClientProperty(RIGHT_ALIGN_KEY) == Boolean.TRUE) {
                    bounds.set(bounds.size() - j, new Rectangle(size2Fit.width - j * JBUI.scale((int)25), 0, JBUI.scale((int)25), maxHeight));
                }
                --i;
                ++j;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        ArrayList<Rectangle> bounds = new ArrayList<Rectangle>();
        this.calculateBounds(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE), bounds);
        if (bounds.isEmpty()) {
            return JBUI.emptySize();
        }
        int xLeft = Integer.MAX_VALUE;
        int yTop = Integer.MAX_VALUE;
        int xRight = Integer.MIN_VALUE;
        int yBottom = Integer.MIN_VALUE;
        for (int i = bounds.size() - 1; i >= 0; --i) {
            Rectangle each = bounds.get(i);
            if (each.x == Integer.MAX_VALUE) continue;
            xLeft = Math.min(xLeft, each.x);
            yTop = Math.min(yTop, each.y);
            xRight = Math.max(xRight, each.x + each.width);
            yBottom = Math.max(yBottom, each.y + each.height);
        }
        Dimension dimension = new Dimension(xRight - xLeft, yBottom - yTop);
        if (this.myLayoutPolicy == 2 && this.myReservePlaceAutoPopupIcon) {
            if (this.myOrientation == 0) {
                dimension.width += AllIcons.Ide.Link.getIconWidth();
            } else {
                dimension.height += AllIcons.Ide.Link.getIconHeight();
            }
        }
        Insets i = this.getInsets();
        return new Dimension(dimension.width + i.left + i.right, dimension.height + i.top + i.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.myLayoutPolicy == 2) {
            Insets i = this.getInsets();
            return new Dimension(AllIcons.Ide.Link.getIconWidth() + i.left + i.right, this.myMinimumButtonSize.height + i.top + i.bottom);
        }
        return super.getMinimumSize();
    }

    public void adjustTheSameSize(boolean value) {
        if (this.myAdjustTheSameSize == value) {
            return;
        }
        this.myAdjustTheSameSize = value;
        this.revalidate();
    }

    public void setMinimumButtonSize(@NotNull Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl", "setMinimumButtonSize"));
        }
        this.myMinimumButtonSize = size;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ActionButton)) continue;
            ActionButton button = (ActionButton)component;
            button.setMinimumButtonSize(size);
        }
        this.revalidate();
    }

    public void setOrientation(int orientation) {
        if (0 != orientation && 1 != orientation) {
            throw new IllegalArgumentException("wrong orientation: " + orientation);
        }
        this.myOrientation = orientation;
    }

    public void updateActionsImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdater.updateActions(true, false);
    }

    private void updateActionsImpl(boolean transparentOnly, boolean forced) {
        ArrayList newVisibleActions = ContainerUtil.newArrayListWithCapacity((int)this.myVisibleActions.size());
        DataContext dataContext = this.getDataContext();
        Utils.expandActionGroup(this.myActionGroup, newVisibleActions, this.myPresentationFactory, dataContext, this.myPlace, (ActionManager)this.myActionManager, transparentOnly);
        if (forced || !((Object)newVisibleActions).equals(this.myVisibleActions)) {
            boolean shouldRebuildUI = newVisibleActions.isEmpty() || this.myVisibleActions.isEmpty();
            this.myVisibleActions = newVisibleActions;
            Dimension oldSize = this.getPreferredSize();
            this.removeAll();
            this.mySecondaryActions.removeAll();
            this.mySecondaryActionsButton = null;
            this.fillToolBar(this.myVisibleActions, this.getLayoutPolicy() == 2 && this.myOrientation == 0);
            Dimension newSize = this.getPreferredSize();
            ((WindowManagerEx)WindowManager.getInstance()).adjustContainerWindow(this, oldSize, newSize);
            if (shouldRebuildUI) {
                this.revalidate();
            } else {
                Container parent = this.getParent();
                if (parent != null) {
                    parent.invalidate();
                    parent.validate();
                }
            }
            this.repaint();
        }
    }

    public boolean hasVisibleActions() {
        return !this.myVisibleActions.isEmpty();
    }

    public void setTargetComponent(JComponent component) {
        this.myTargetComponent = component;
        if (this.myTargetComponent != null) {
            UiNotifyConnector.doWhenFirstShown((JComponent)this.myTargetComponent, (Runnable)new DumbAwareRunnable(){

                public void run() {
                    ActionToolbarImpl.this.myUpdater.updateActions(false, false);
                }
            });
        }
    }

    public DataContext getToolbarDataContext() {
        return this.getDataContext();
    }

    protected DataContext getDataContext() {
        return this.myTargetComponent != null ? this.myDataManager.getDataContext((Component)this.myTargetComponent) : ((DataManagerImpl)this.myDataManager).getDataContextTest(this);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (this.getLayoutPolicy() != 2) {
            return;
        }
        if (this.myAutoPopupRec != null && this.myAutoPopupRec.contains(e.getPoint())) {
            IdeFocusManager.getInstance(null).doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    ActionToolbarImpl.this.showAutoPopup();
                }
            });
        }
    }

    private void showAutoPopup() {
        Point location;
        ActionGroup group;
        if (this.isPopupShowing()) {
            return;
        }
        if (this.myOrientation == 0) {
            group = this.myActionGroup;
        } else {
            DefaultActionGroup outside = new DefaultActionGroup();
            for (int i = this.myFirstOutsideIndex; i < this.myVisibleActions.size(); ++i) {
                outside.add(this.myVisibleActions.get(i));
            }
            group = outside;
        }
        PopupToolbar popupToolbar = new PopupToolbar(this.myPlace, group, true, this.myDataManager, this.myActionManager, this.myUpdater.getKeymapManager(), this){

            @Override
            protected void onOtherActionPerformed() {
                ActionToolbarImpl.this.hidePopup();
            }

            @Override
            protected DataContext getDataContext() {
                return ActionToolbarImpl.this.getDataContext();
            }
        };
        popupToolbar.setLayoutPolicy(0);
        popupToolbar.updateActionsImmediately();
        if (this.myOrientation == 0) {
            location = this.getLocationOnScreen();
        } else {
            location = this.getLocationOnScreen();
            location.y = location.y + this.getHeight() - popupToolbar.getPreferredSize().height;
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupToolbar, null);
        builder.setResizable(false).setMovable(true).setMayBeParent(true).setRequestFocus(false).setTitle(null).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                boolean toClose = ActionToolbarImpl.this.myActionManager.isActionPopupStackEmpty();
                if (toClose) {
                    ActionToolbarImpl.this.myUpdater.updateActions(false, true);
                }
                return toClose;
            }
        }).setCancelOnMouseOutCallback(new MouseChecker(){

            public boolean check(MouseEvent event) {
                return ActionToolbarImpl.this.myAutoPopupRec != null && ActionToolbarImpl.this.myActionManager.isActionPopupStackEmpty() && !new RelativeRectangle((Component)ActionToolbarImpl.this, ActionToolbarImpl.this.myAutoPopupRec).contains(new RelativePoint(event));
            }
        });
        builder.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                ActionToolbarImpl.this.processClosed();
            }
        });
        this.myPopup = builder.createPopup();
        final AnActionListener.Adapter listener = new AnActionListener.Adapter(){

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                JBPopup popup = ActionToolbarImpl.this.myPopup;
                if (popup != null && !popup.isDisposed() && popup.isVisible()) {
                    popup.cancel();
                }
            }
        };
        ActionManager.getInstance().addAnActionListener((AnActionListener)listener);
        Disposer.register((Disposable)this.myPopup, (Disposable)popupToolbar);
        Disposer.register((Disposable)popupToolbar, (Disposable)new Disposable(){

            public void dispose() {
                ActionManager.getInstance().removeAnActionListener((AnActionListener)listener);
            }
        });
        this.myPopup.showInScreenCoordinates((Component)this, location);
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            final ComponentAdapter componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }
            };
            window.addComponentListener(componentAdapter);
            Disposer.register((Disposable)popupToolbar, (Disposable)new Disposable(){

                public void dispose() {
                    window.removeComponentListener(componentAdapter);
                }
            });
        }
    }

    private boolean isPopupShowing() {
        return this.myPopup != null && this.myPopup.getContent() != null;
    }

    private void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.processClosed();
        }
    }

    private void processClosed() {
        if (this.myPopup == null) {
            return;
        }
        Disposer.dispose((Disposable)this.myPopup);
        this.myPopup = null;
        this.myUpdater.updateActions(false, false);
    }

    public void setReservePlaceAutoPopupIcon(boolean reserve) {
        this.myReservePlaceAutoPopupIcon = reserve;
    }

    public void setSecondaryActionsTooltip(String secondaryActionsTooltip) {
        this.mySecondaryActions.getTemplatePresentation().setDescription(secondaryActionsTooltip);
    }

    public List<SwitchTarget> getTargets(boolean onlyVisible, boolean originalProvider) {
        ArrayList<SwitchTarget> result = new ArrayList<SwitchTarget>();
        if (this.getBounds().width * this.getBounds().height <= 0) {
            return result;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component each = this.getComponent(i);
            if (!(each instanceof ActionButton)) continue;
            result.add(new ActionTarget((ActionButton)each));
        }
        return result;
    }

    public SwitchTarget getCurrentTarget() {
        return null;
    }

    public boolean isCycleRoot() {
        return false;
    }

    public List<AnAction> getActions(boolean originalProvider) {
        AnAction[] kids;
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        ArrayList<AnAction> secondary = new ArrayList<AnAction>();
        for (AnAction each : kids = this.myActionGroup.getChildren(null)) {
            if (this.myActionGroup.isPrimary(each)) {
                result.add(each);
                continue;
            }
            secondary.add(each);
        }
        result.add((AnAction)new Separator());
        result.addAll(secondary);
        return result;
    }

    public void setMiniMode(boolean minimalMode) {
        this.myMinimalMode = minimalMode;
        if (this.myMinimalMode) {
            this.setMinimumButtonSize((Dimension)JBUI.emptySize());
            this.setLayoutPolicy(0);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.setOpaque(false);
        } else {
            if (this.isInsideNavBar()) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
            this.setMinimumButtonSize(this.myDecorateButtons ? new Dimension(30, 20) : DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setOpaque(true);
            this.setLayoutPolicy(2);
        }
        this.myUpdater.updateActions(false, true);
    }

    public void setAddSeparatorFirst(boolean addSeparatorFirst) {
        this.myAddSeparatorFirst = addSeparatorFirst;
        this.myUpdater.updateActions(false, true);
    }

    private static class ActionTarget
    implements SwitchTarget {
        private final ActionButton myButton;

        private ActionTarget(ActionButton button) {
            this.myButton = button;
        }

        public ActionCallback switchTo(boolean requestFocus) {
            this.myButton.click();
            return new ActionCallback.Done();
        }

        public boolean isVisible() {
            return this.myButton.isVisible();
        }

        public RelativeRectangle getRectangle() {
            return new RelativeRectangle((Component)this.myButton.getParent(), this.myButton.getBounds());
        }

        public Component getComponent() {
            return this.myButton;
        }

        public String toString() {
            return this.myButton.getAction().toString();
        }
    }

    static abstract class PopupToolbar
    extends ActionToolbarImpl
    implements AnActionListener,
    Disposable {
        private final JComponent myParent;

        public PopupToolbar(String place, ActionGroup actionGroup, boolean horizontal, DataManager dataManager, @NotNull ActionManagerEx actionManager, KeymapManagerEx keymapManager, JComponent parent) {
            if (actionManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$PopupToolbar", "<init>"));
            }
            super(place, actionGroup, horizontal, false, dataManager, actionManager, keymapManager, true);
            this.myActionManager.addAnActionListener((AnActionListener)this);
            this.myParent = parent;
        }

        @Override
        public Container getParent() {
            Container parent = super.getParent();
            return parent != null ? parent : this.myParent;
        }

        public void dispose() {
            this.myActionManager.removeAnActionListener((AnActionListener)this);
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            if (!this.myVisibleActions.contains(action)) {
                this.onOtherActionPerformed();
            }
        }

        protected abstract void onOtherActionPerformed();

        public void beforeEditorTyping(char c, DataContext dataContext) {
        }
    }

    private final class MySeparator
    extends JComponent {
        private final Dimension mySize;

        public MySeparator() {
            this.mySize = ActionToolbarImpl.this.myOrientation == 0 ? JBUI.size((int)6, (int)24) : JBUI.size((int)24, (int)6);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.mySize;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Insets i = this.getInsets();
            if (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula()) {
                if (this.getParent() != null) {
                    JBColor col = new JBColor((Color)Gray._128, (Color)Gray._111);
                    Graphics2D g2 = (Graphics2D)g;
                    if (ActionToolbarImpl.this.myOrientation == 0) {
                        UIUtil.drawDoubleSpaceDottedLine((Graphics2D)g2, (int)(i.top + 2), (int)(this.getParent().getSize().height - 2 - i.top - i.bottom), (int)3, (Color)col, (boolean)false);
                    } else {
                        UIUtil.drawDoubleSpaceDottedLine((Graphics2D)g2, (int)(i.left + 2), (int)(this.getParent().getSize().width - 2 - i.left - i.right), (int)3, (Color)col, (boolean)true);
                    }
                }
            } else {
                g.setColor(UIUtil.getSeparatorColor());
                if (this.getParent() != null) {
                    if (ActionToolbarImpl.this.myOrientation == 0) {
                        UIUtil.drawLine((Graphics)g, (int)3, (int)2, (int)3, (int)(this.getParent().getSize().height - 2));
                    } else {
                        UIUtil.drawLine((Graphics)g, (int)2, (int)3, (int)(this.getParent().getSize().width - 2), (int)3);
                    }
                }
            }
        }
    }
}

