/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UndoableGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.impl.UndoableGroup");
    private final String myCommandName;
    private final boolean myGlobal;
    private final int myCommandTimestamp;
    private final boolean myTransparent;
    private final List<UndoableAction> myActions;
    private EditorAndState myStateBefore;
    private EditorAndState myStateAfter;
    private final Project myProject;
    private final UndoConfirmationPolicy myConfirmationPolicy;
    private boolean myValid;

    public UndoableGroup(String commandName, boolean isGlobal, UndoManagerImpl manager, EditorAndState stateBefore, EditorAndState stateAfter, List<UndoableAction> actions, UndoConfirmationPolicy confirmationPolicy, boolean transparent, boolean valid) {
        this.myCommandName = commandName;
        this.myGlobal = isGlobal;
        this.myCommandTimestamp = manager.nextCommandTimestamp();
        this.myActions = actions;
        this.myProject = manager.getProject();
        this.myStateBefore = stateBefore;
        this.myStateAfter = stateAfter;
        this.myConfirmationPolicy = confirmationPolicy;
        this.myTransparent = transparent;
        this.myValid = valid;
        this.composeStartFinishGroup(manager.getUndoStacksHolder());
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public boolean isTransparent() {
        return this.myTransparent;
    }

    public boolean isUndoable() {
        for (UndoableAction action : this.myActions) {
            if (!(action instanceof NonUndoableAction)) continue;
            return false;
        }
        return true;
    }

    public void undo() {
        this.undoOrRedo(true);
    }

    public void redo() {
        this.undoOrRedo(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoOrRedo(boolean isUndo) {
        LocalHistoryAction action;
        if (this.myProject != null && this.isGlobal()) {
            String actionName = CommonBundle.message((String)(isUndo ? "local.vcs.action.name.undo.command" : "local.vcs.action.name.redo.command"), (Object[])new Object[]{this.myCommandName});
            action = LocalHistory.getInstance().startAction(actionName);
        } else {
            action = LocalHistoryAction.NULL;
        }
        try {
            this.doUndoOrRedo(isUndo);
        }
        finally {
            action.finish();
        }
    }

    private void doUndoOrRedo(final boolean isUndo) {
        final boolean wrapInBulkUpdate = this.myActions.size() > 50;
        THashSet bulkDocuments = new THashSet();
        ApplicationManager.getApplication().runWriteAction(new Runnable((Set)bulkDocuments){
            final /* synthetic */ Set val$bulkDocuments;
            {
                this.val$bulkDocuments = set;
            }

            @Override
            public void run() {
                try {
                    for (UndoableAction action : isUndo ? ContainerUtil.iterateBackward((List)UndoableGroup.this.myActions) : UndoableGroup.this.myActions) {
                        THashSet newDocuments;
                        if (wrapInBulkUpdate) {
                            newDocuments = new THashSet();
                            THashSet documentsToRemoveFromBulk = new THashSet((Collection)this.val$bulkDocuments);
                            DocumentReference[] affectedDocuments = action.getAffectedDocuments();
                            if (affectedDocuments != null) {
                                for (DocumentReference affectedDocument : affectedDocuments) {
                                    DocumentEx document;
                                    VirtualFile file = affectedDocument.getFile();
                                    if (file != null && !file.isValid() || (document = (DocumentEx)affectedDocument.getDocument()) == null) continue;
                                    documentsToRemoveFromBulk.remove(document);
                                    if (this.val$bulkDocuments.contains(document)) continue;
                                    newDocuments.add(document);
                                    document.setInBulkUpdate(true);
                                }
                            }
                            for (DocumentEx document : documentsToRemoveFromBulk) {
                                document.setInBulkUpdate(false);
                            }
                            this.val$bulkDocuments.removeAll((Collection<?>)documentsToRemoveFromBulk);
                            this.val$bulkDocuments.addAll(newDocuments);
                        } else {
                            newDocuments = Collections.emptyList();
                        }
                        if (isUndo) {
                            action.undo();
                            continue;
                        }
                        action.redo();
                    }
                    for (DocumentEx bulkDocument : this.val$bulkDocuments) {
                        bulkDocument.setInBulkUpdate(false);
                    }
                }
                catch (UnexpectedUndoException e) {
                    UndoableGroup.this.reportUndoProblem(e, isUndo);
                }
            }
        });
        UndoableGroup.commitAllDocuments();
    }

    boolean isInsideStartFinishGroup(boolean isUndo, boolean isInsideStartFinishGroup) {
        int finishNmb;
        ArrayList<FinishMarkAction> finishMarks = new ArrayList<FinishMarkAction>();
        ArrayList<StartMarkAction> startMarks = new ArrayList<StartMarkAction>();
        for (UndoableAction action : this.myActions) {
            if (action instanceof StartMarkAction) {
                startMarks.add((StartMarkAction)action);
                continue;
            }
            if (!(action instanceof FinishMarkAction)) continue;
            finishMarks.add((FinishMarkAction)action);
        }
        int startNmb = startMarks.size();
        if (startNmb != (finishNmb = finishMarks.size())) {
            if (isUndo) {
                return finishNmb > startNmb;
            }
            return startNmb > finishNmb;
        }
        return isInsideStartFinishGroup;
    }

    void composeStartFinishGroup(UndoRedoStacksHolder holder) {
        FinishMarkAction finishMark = this.getFinishMark();
        if (finishMark != null) {
            boolean global = false;
            String commandName = null;
            LinkedList<UndoableGroup> stack = holder.getStack(finishMark.getAffectedDocument());
            Iterator<UndoableGroup> iterator = stack.descendingIterator();
            while (iterator.hasNext()) {
                UndoableGroup group = iterator.next();
                if (group.isGlobal()) {
                    global = true;
                    commandName = group.getCommandName();
                    break;
                }
                if (group.getStartMark() == null) continue;
                break;
            }
            if (global) {
                finishMark.setGlobal(global);
                finishMark.setCommandName(commandName);
            }
        }
    }

    private boolean shouldAskConfirmationForStartFinishGroup(boolean redo) {
        if (redo) {
            StartMarkAction mark = this.getStartMark();
            if (mark != null) {
                return mark.isGlobal();
            }
        } else {
            FinishMarkAction finishMark = this.getFinishMark();
            if (finishMark != null) {
                return finishMark.isGlobal();
            }
        }
        return false;
    }

    private static void commitAllDocuments() {
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            PsiDocumentManager.getInstance((Project)p).commitAllDocuments();
        }
    }

    private void reportUndoProblem(UnexpectedUndoException e, boolean isUndo) {
        String message;
        String title;
        if (isUndo) {
            title = CommonBundle.message((String)"cannot.undo.dialog.title", (Object[])new Object[0]);
            message = CommonBundle.message((String)"cannot.undo.message", (Object[])new Object[0]);
        } else {
            title = CommonBundle.message((String)"cannot.redo.dialog.title", (Object[])new Object[0]);
            message = CommonBundle.message((String)"cannot.redo.message", (Object[])new Object[0]);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (e.getMessage() != null) {
                message = message + ".\n" + e.getMessage();
            }
            Messages.showMessageDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getErrorIcon());
        } else {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public Collection<DocumentReference> getAffectedDocuments() {
        THashSet result = new THashSet();
        for (UndoableAction action : this.myActions) {
            DocumentReference[] refs = action.getAffectedDocuments();
            if (refs == null) continue;
            Collections.addAll(result, refs);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoableGroup", "getAffectedDocuments"));
        }
        return tHashSet;
    }

    public EditorAndState getStateBefore() {
        return this.myStateBefore;
    }

    public EditorAndState getStateAfter() {
        return this.myStateAfter;
    }

    public void setStateBefore(EditorAndState stateBefore) {
        this.myStateBefore = stateBefore;
    }

    public void setStateAfter(EditorAndState stateAfter) {
        this.myStateAfter = stateAfter;
    }

    public String getCommandName() {
        for (UndoableAction action : this.myActions) {
            String commandName;
            if (!(action instanceof StartMarkAction ? (commandName = ((StartMarkAction)action).getCommandName()) != null : action instanceof FinishMarkAction && (commandName = ((FinishMarkAction)action).getCommandName()) != null)) continue;
            return commandName;
        }
        return this.myCommandName;
    }

    public int getCommandTimestamp() {
        return this.myCommandTimestamp;
    }

    @Nullable
    public StartMarkAction getStartMark() {
        for (UndoableAction action : this.myActions) {
            if (!(action instanceof StartMarkAction)) continue;
            return (StartMarkAction)action;
        }
        return null;
    }

    @Nullable
    public FinishMarkAction getFinishMark() {
        for (UndoableAction action : this.myActions) {
            if (!(action instanceof FinishMarkAction)) continue;
            return (FinishMarkAction)action;
        }
        return null;
    }

    public boolean shouldAskConfirmation(boolean redo) {
        if (this.shouldAskConfirmationForStartFinishGroup(redo)) {
            return true;
        }
        return this.myConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION || this.myConfirmationPolicy != UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && this.myGlobal;
    }

    public void invalidateActionsFor(DocumentReference ref) {
        if (this.getAffectedDocuments().contains(ref)) {
            this.myValid = false;
        }
    }

    public boolean isValid() {
        return this.myValid;
    }

    public String toString() {
        boolean multiline;
        StringBuilder result = new StringBuilder("UndoableGroup[");
        boolean bl = multiline = this.myActions.size() > 1;
        if (multiline) {
            result.append("\n");
        }
        result.append(StringUtil.join(this.myActions, (Function)new Function<UndoableAction, String>(){

            public String fun(UndoableAction each) {
                return (multiline ? "  " : "") + each.toString();
            }
        }, (String)",\n"));
        if (multiline) {
            result.append("\n");
        }
        result.append("]");
        return result.toString();
    }
}

