/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultStateSerializer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.DefaultStateSerializer");

    private DefaultStateSerializer() {
    }

    @Nullable
    static Element serializeState(@NotNull Object state, final @Nullable Storage storage) throws WriteExternalException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/DefaultStateSerializer", "serializeState"));
        }
        if (state instanceof Element) {
            return (Element)state;
        }
        if (state instanceof JDOMExternalizable) {
            Element element = new Element("temp_element");
            ((JDOMExternalizable)state).writeExternal(element);
            return element;
        }
        return XmlSerializer.serializeIfNotDefault((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters(){

            protected boolean accepts(@NotNull Accessor accessor, @NotNull Object bean, @Nullable Object beanValue) {
                if (accessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/openapi/components/impl/stores/DefaultStateSerializer$1", "accepts"));
                }
                if (bean == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/components/impl/stores/DefaultStateSerializer$1", "accepts"));
                }
                if (!super.accepts(accessor, bean, beanValue)) {
                    return false;
                }
                if (storage != null) {
                    StorageId storageId = (StorageId)accessor.getAnnotation(StorageId.class);
                    if (storageId != null && !storageId.value().equals(storage.id())) {
                        return false;
                    }
                    return storage.isDefault();
                }
                return true;
            }
        });
    }

    @Nullable
    public static <T> T deserializeState(@Nullable Element stateElement, Class<T> stateClass, @Nullable T mergeInto) throws XmlSerializationException {
        if (stateElement == null) {
            return mergeInto;
        }
        if (stateClass.equals(Element.class)) {
            return (T)stateElement;
        }
        if (JDOMExternalizable.class.isAssignableFrom(stateClass)) {
            if (mergeInto != null) {
                String elementText = JDOMUtil.writeElement((Element)stateElement, (String)"\n");
                LOG.error("State is " + stateClass.getName() + ", merge into is " + mergeInto.toString() + ", state element text is " + elementText);
            }
            Object t = ReflectionUtil.newInstance(stateClass, (Class[])new Class[0]);
            try {
                ((JDOMExternalizable)t).readExternal(stateElement);
                return (T)t;
            }
            catch (InvalidDataException e) {
                throw new StateStorageException((Throwable)e);
            }
        }
        if (mergeInto == null) {
            return (T)XmlSerializer.deserialize((Element)stateElement, stateClass);
        }
        XmlSerializer.deserializeInto(mergeInto, (Element)stateElement);
        return mergeInto;
    }
}

