/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.iq80.snappy.SnappyInputStream;
import org.iq80.snappy.SnappyOutputStream;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StateMap {
    private static final Logger LOG = Logger.getInstance(StateMap.class);
    private static final Format XML_FORMAT = Format.getRawFormat().setTextMode(Format.TextMode.TRIM).setOmitEncoding(true).setOmitDeclaration(true);
    private final THashMap<String, Object> states;

    public StateMap() {
        this.states = new THashMap();
    }

    public StateMap(StateMap stateMap) {
        this.states = new THashMap(stateMap.states);
    }

    @NotNull
    public Set<String> keys() {
        Set set = this.states.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "keys"));
        }
        return set;
    }

    @NotNull
    public Collection<Object> values() {
        Collection collection = this.states.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "values"));
        }
        return collection;
    }

    @Nullable
    public Object get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "get"));
        }
        return this.states.get((Object)key);
    }

    @NotNull
    public Element getElement(@NotNull String key, @NotNull Map<String, Element> newLiveStates) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "getElement"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/StateMap", "getElement"));
        }
        Object state = this.states.get((Object)key);
        Element element = StateMap.stateToElement(key, state, newLiveStates);
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "getElement"));
        }
        return element;
    }

    @NotNull
    static Element stateToElement(@NotNull String key, @Nullable Object state, @NotNull Map<String, Element> newLiveStates) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "stateToElement"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/StateMap", "stateToElement"));
        }
        if (state instanceof Element) {
            Element element = ((Element)state).clone();
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "stateToElement"));
            }
            return element;
        }
        Element element = newLiveStates.get(key);
        if (element == null) {
            assert (state != null);
            element = StateMap.unarchiveState((byte[])state);
        }
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "stateToElement"));
        }
        return element2;
    }

    public void put(@NotNull String key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/components/impl/stores/StateMap", "put"));
        }
        this.states.put((Object)key, value);
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    @Nullable
    public Element getState(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "getState"));
        }
        Object state = this.states.get((Object)key);
        return state instanceof Element ? (Element)state : null;
    }

    public boolean hasState(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "hasState"));
        }
        return this.states.get((Object)key) instanceof Element;
    }

    public boolean hasStates() {
        if (this.states.isEmpty()) {
            return false;
        }
        for (Object value : this.states.values()) {
            if (!(value instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public void compare(@NotNull String key, @NotNull StateMap newStates, @NotNull Set<String> diffs) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "compare"));
        }
        if (newStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStates", "com/intellij/openapi/components/impl/stores/StateMap", "compare"));
        }
        if (diffs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffs", "com/intellij/openapi/components/impl/stores/StateMap", "compare"));
        }
        Object oldState = this.states.get((Object)key);
        Object newState = newStates.get(key);
        if (oldState instanceof Element) {
            if (!JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)((Element)newState))) {
                diffs.add(key);
            }
        } else {
            assert (newState != null);
            if (StateMap.getNewByteIfDiffers(key, newState, (byte[])oldState) != null) {
                diffs.add(key);
            }
        }
    }

    @Nullable
    public static byte[] getNewByteIfDiffers(@NotNull String key, @NotNull Object newState, @NotNull byte[] oldState) {
        byte[] newBytes;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "getNewByteIfDiffers"));
        }
        if (newState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newState", "com/intellij/openapi/components/impl/stores/StateMap", "getNewByteIfDiffers"));
        }
        if (oldState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldState", "com/intellij/openapi/components/impl/stores/StateMap", "getNewByteIfDiffers"));
        }
        byte[] byArray = newBytes = newState instanceof Element ? StateMap.archiveState((Element)newState) : (byte[])newState;
        if (Arrays.equals(newBytes, oldState)) {
            return null;
        }
        if (LOG.isDebugEnabled() && SystemProperties.getBooleanProperty((String)"idea.log.changed.components", (boolean)false)) {
            String after;
            String before = StateMap.stateToString(oldState);
            if (before.equals(after = StateMap.stateToString(newState))) {
                LOG.debug("Serialization error: serialized are different, but unserialized are equal");
            } else {
                LOG.debug(key + " " + StringUtil.repeat((String)"=", (int)(80 - key.length())) + "\nBefore:\n" + before + "\nAfter:\n" + after);
            }
        }
        return newBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static byte[] archiveState(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StateMap", "archiveState"));
        }
        BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new SnappyOutputStream((OutputStream)byteOut), CharsetToolkit.UTF8_CHARSET);
            try {
                JDOMUtil.MyXMLOutputter xmlOutputter = new JDOMUtil.MyXMLOutputter();
                xmlOutputter.setFormat(XML_FORMAT);
                xmlOutputter.output(state, (Writer)writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new StateStorageException((Throwable)e);
        }
        byte[] byArray = ArrayUtil.realloc((byte[])byteOut.getInternalBuffer(), (int)byteOut.size());
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "archiveState"));
        }
        return byArray;
    }

    @Nullable
    public Element getStateAndArchive(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "getStateAndArchive"));
        }
        Object state = this.states.get((Object)key);
        if (!(state instanceof Element)) {
            return null;
        }
        this.states.put((Object)key, (Object)StateMap.archiveState((Element)state));
        return (Element)state;
    }

    @NotNull
    public static Element unarchiveState(@NotNull byte[] state) {
        Element element;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StateMap", "unarchiveState"));
        }
        try {
            element = JDOMUtil.load((InputStream)new SnappyInputStream((InputStream)new ByteArrayInputStream(state)));
        }
        catch (IOException e) {
            throw new StateStorageException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new StateStorageException((Throwable)e);
        }
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "unarchiveState"));
        }
        return element;
    }

    @NotNull
    public static String stateToString(@NotNull Object state) {
        Element element;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StateMap", "stateToString"));
        }
        if (state instanceof Element) {
            element = (Element)state;
        } else {
            try {
                element = StateMap.unarchiveState((byte[])state);
            }
            catch (Throwable e) {
                LOG.error(e);
                if ("internal error" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "stateToString"));
                }
                return "internal error";
            }
        }
        String string = JDOMUtil.writeParent((Parent)element, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateMap", "stateToString"));
        }
        return string;
    }

    @Nullable
    public Object remove(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/StateMap", "remove"));
        }
        return this.states.remove((Object)key);
    }

    public int size() {
        return this.states.size();
    }

    public void forEachEntry(@NotNull TObjectObjectProcedure<String, Object> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/components/impl/stores/StateMap", "forEachEntry"));
        }
        this.states.forEachEntry(consumer);
    }
}

