/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskActivator {
    public static final String RUN_CONFIGURATION_TASK_PREFIX = "run: ";
    @NotNull
    private final Project myProject;
    private final List<Listener> myListeners;

    public ExternalSystemTaskActivator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    @NotNull
    public static String getRunConfigurationActivationTaskName(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "getRunConfigurationActivationTaskName"));
        }
        String string = RUN_CONFIGURATION_TASK_PREFIX + settings.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "getRunConfigurationActivationTaskName"));
        }
        return string;
    }

    public void init() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        class MyCompileTask
        implements CompileTask {
            private final boolean myBefore;

            MyCompileTask(boolean before) {
                this.myBefore = before;
            }

            public boolean execute(CompileContext context) {
                return ExternalSystemTaskActivator.this.doExecuteCompileTasks(this.myBefore, context);
            }
        }
        compilerManager.addBeforeTask((CompileTask)new MyCompileTask(true));
        compilerManager.addAfterTask((CompileTask)new MyCompileTask(false));
        this.fireTasksChanged();
    }

    public String getDescription(ProjectSystemId systemId, String projectPath, String taskName) {
        ArrayList<String> result = new ArrayList<String>();
        ExternalProjectsManager.ExternalProjectsStateProvider stateProvider = ExternalProjectsManager.getInstance(this.myProject).getStateProvider();
        TaskActivationState taskActivationState = stateProvider.getTasksActivation(systemId, projectPath);
        if (taskActivationState == null) {
            return null;
        }
        for (Phase phase : Phase.values()) {
            if (!taskActivationState.getTasks(phase).contains(taskName)) continue;
            result.add(ExternalSystemBundle.message((String)phase.myMessageKey, (Object[])new Object[0]));
        }
        return StringUtil.join(result, (String)", ");
    }

    private boolean doExecuteCompileTasks(boolean myBefore, @NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "doExecuteCompileTasks"));
        }
        List modules = ContainerUtil.map((Object[])context.getCompileScope().getAffectedModules(), (Function)new Function<Module, String>(){

            public String fun(Module module) {
                return ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            }
        });
        ArrayList phases = ContainerUtil.newArrayList();
        if (myBefore) {
            if (context.isRebuild()) {
                phases.add(Phase.BEFORE_REBUILD);
            }
            phases.add(Phase.BEFORE_COMPILE);
        } else {
            phases.add(Phase.AFTER_COMPILE);
            if (context.isRebuild()) {
                phases.add(Phase.AFTER_REBUILD);
            }
        }
        return this.runTasks(modules, (Phase[])ArrayUtil.toObjectArray((Collection)phases, Phase.class));
    }

    public boolean runTasks(@NotNull String modulePath, Phase ... phases) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "runTasks"));
        }
        if (phases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phases", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "runTasks"));
        }
        return this.runTasks(Collections.singleton(modulePath), phases);
    }

    public boolean runTasks(@NotNull Collection<String> modules, Phase ... phases) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "runTasks"));
        }
        if (phases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phases", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "runTasks"));
        }
        ExternalProjectsManager.ExternalProjectsStateProvider stateProvider = ExternalProjectsManager.getInstance(this.myProject).getStateProvider();
        LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> tasksQueue = new LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>>();
        FactoryMap<ProjectSystemId, Map<String, RunnerAndConfigurationSettings>> lazyConfigurationsMap = new FactoryMap<ProjectSystemId, Map<String, RunnerAndConfigurationSettings>>(){

            @Nullable
            protected Map<String, RunnerAndConfigurationSettings> create(ProjectSystemId key) {
                AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(key);
                if (configurationType == null) {
                    return null;
                }
                return ContainerUtil.map2Map((Collection)RunManager.getInstance((Project)ExternalSystemTaskActivator.this.myProject).getConfigurationSettingsList((ConfigurationType)configurationType), (Function)new Function<RunnerAndConfigurationSettings, Pair<String, RunnerAndConfigurationSettings>>(){

                    public Pair<String, RunnerAndConfigurationSettings> fun(RunnerAndConfigurationSettings configurationSettings) {
                        return Pair.create((Object)configurationSettings.getName(), (Object)configurationSettings);
                    }
                });
            }
        };
        for (ExternalProjectsManager.ExternalProjectsStateProvider.TasksActivation activation : stateProvider.getAllTasksActivation()) {
            boolean hashPath = modules.contains(activation.projectPath);
            LinkedHashSet tasks = ContainerUtil.newLinkedHashSet();
            for (Phase phase : phases) {
                if (!hashPath && !phase.isSyncPhase()) continue;
                ContainerUtil.addAll((Collection)tasks, activation.state.getTasks(phase));
            }
            if (tasks.isEmpty()) continue;
            Iterator iterator = tasks.iterator();
            while (iterator.hasNext()) {
                RunnerAndConfigurationSettings configurationSettings;
                String task = (String)iterator.next();
                if (task.length() <= RUN_CONFIGURATION_TASK_PREFIX.length() || !task.startsWith(RUN_CONFIGURATION_TASK_PREFIX)) continue;
                iterator.remove();
                String configurationName = task.substring(RUN_CONFIGURATION_TASK_PREFIX.length());
                Map settings = (Map)lazyConfigurationsMap.get(activation.systemId);
                if (settings == null || (configurationSettings = (RunnerAndConfigurationSettings)settings.get(configurationName)) == null) continue;
                RunConfiguration runConfiguration = configurationSettings.getConfiguration();
                if (!configurationName.equals(configurationSettings.getName()) || !(runConfiguration instanceof ExternalSystemRunConfiguration)) continue;
                tasksQueue.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)activation.systemId, (Object)((ExternalSystemRunConfiguration)runConfiguration).getSettings()));
            }
            if (tasks.isEmpty()) continue;
            ExternalSystemTaskExecutionSettings executionSettings = new ExternalSystemTaskExecutionSettings();
            executionSettings.setExternalSystemIdString(activation.systemId.toString());
            executionSettings.setExternalProjectPath(activation.projectPath);
            executionSettings.getTaskNames().addAll(tasks);
            tasksQueue.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)activation.systemId, (Object)executionSettings));
        }
        return this.runTasksQueue(tasksQueue);
    }

    private boolean runTasksQueue(final Queue<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> tasksQueue) {
        Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings> pair = tasksQueue.poll();
        if (pair == null) {
            return true;
        }
        ProjectSystemId systemId = (ProjectSystemId)pair.first;
        ExternalSystemTaskExecutionSettings executionSettings = (ExternalSystemTaskExecutionSettings)pair.getSecond();
        final Semaphore targetDone = new Semaphore();
        targetDone.down();
        final Ref result = new Ref((Object)false);
        ExternalSystemUtil.runTask(executionSettings, DefaultRunExecutor.EXECUTOR_ID, this.myProject, systemId, new TaskCallback(){

            public void onSuccess() {
                result.set((Object)ExternalSystemTaskActivator.this.runTasksQueue(tasksQueue));
                targetDone.up();
            }

            public void onFailure() {
                targetDone.up();
            }
        }, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
        targetDone.waitFor();
        return (Boolean)result.get();
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public boolean isTaskOfPhase(@NotNull TaskData taskData, @NotNull Phase phase) {
        if (taskData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskData", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "isTaskOfPhase"));
        }
        if (phase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phase", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator", "isTaskOfPhase"));
        }
        ExternalProjectsManager.ExternalProjectsStateProvider stateProvider = ExternalProjectsManager.getInstance(this.myProject).getStateProvider();
        TaskActivationState taskActivationState = stateProvider.getTasksActivation(taskData.getOwner(), taskData.getLinkedExternalProjectPath());
        if (taskActivationState == null) {
            return false;
        }
        return taskActivationState.getTasks(phase).contains(taskData.getName());
    }

    public void addTasks(List<TaskData> tasks, Phase phase) {
        if (tasks.isEmpty()) {
            return;
        }
        ExternalProjectsManager.ExternalProjectsStateProvider stateProvider = ExternalProjectsManager.getInstance(this.myProject).getStateProvider();
        for (TaskData task : tasks) {
            TaskActivationState taskActivationState = stateProvider.getTasksActivation(task.getOwner(), task.getLinkedExternalProjectPath());
            taskActivationState.getTasks(phase).add(task.getName());
        }
        this.fireTasksChanged();
    }

    public void removeTasks(List<TaskData> tasks, Phase phase) {
        if (tasks.isEmpty()) {
            return;
        }
        ExternalProjectsManager.ExternalProjectsStateProvider stateProvider = ExternalProjectsManager.getInstance(this.myProject).getStateProvider();
        for (TaskData task : tasks) {
            TaskActivationState taskActivationState = stateProvider.getTasksActivation(task.getOwner(), task.getLinkedExternalProjectPath());
            taskActivationState.getTasks(phase).remove(task.getName());
        }
        this.fireTasksChanged();
    }

    public void fireTasksChanged() {
        for (Listener each : this.myListeners) {
            each.tasksActivationChanged();
        }
    }

    public static interface Listener {
        public void tasksActivationChanged();
    }

    public static enum Phase {
        BEFORE_SYNC("external.system.task.before.sync"),
        AFTER_SYNC("external.system.task.after.sync"),
        BEFORE_COMPILE("external.system.task.before.compile"),
        AFTER_COMPILE("external.system.task.after.compile"),
        BEFORE_REBUILD("external.system.task.before.rebuild"),
        AFTER_REBUILD("external.system.task.after.rebuild");

        public final String myMessageKey;

        private Phase(String messageKey) {
            this.myMessageKey = messageKey;
        }

        public boolean isSyncPhase() {
            return this == BEFORE_SYNC || this == AFTER_SYNC;
        }
    }
}

