/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.OptionsEditorContext;
import com.intellij.openapi.options.newEditor.OptionsTree;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsSearch;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.LightColors;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsEditor
extends JPanel
implements DataProvider,
Place.Navigator,
Disposable,
AWTEventListener {
    public static DataKey<OptionsEditor> KEY = DataKey.create((String)"options.editor");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.newEditor.OptionsEditor");
    @NonNls
    private static final String MAIN_SPLITTER_PROPORTION = "options.splitter.main.proportions";
    @NonNls
    private static final String DETAILS_SPLITTER_PROPORTION = "options.splitter.details.proportions";
    @NonNls
    private static final String NOT_A_NEW_COMPONENT = "component.was.already.instantiated";
    private final History myHistory = new History((Place.Navigator)this);
    private final OptionsTree myTree;
    private final SettingsTreeView myTreeView;
    private final SettingsSearch mySearch;
    private final Splitter myMainSplitter;
    private final DetailsComponent myOwnDetails = new DetailsComponent().setEmptyContentText("Select configuration element in the tree to edit its settings");
    private final ContentWrapper myContentWrapper = new ContentWrapper();
    private final Map<Configurable, ConfigurableContent> myConfigurable2Content = new HashMap<Configurable, ConfigurableContent>();
    private final Map<Configurable, ActionCallback> myConfigurable2LoadCallback = new HashMap<Configurable, ActionCallback>();
    private final MergingUpdateQueue myModificationChecker;
    private final SpotlightPainter mySpotlightPainter = new SpotlightPainter(this.myOwnDetails.getContentGutter(), this){

        @Override
        void updateNow() {
            Configurable configurable = OptionsEditor.this.getContext().getCurrentConfigurable();
            this.update(OptionsEditor.this.myFilter, configurable, (JComponent)((Object)(OptionsEditor.this.myConfigurable2Content.containsKey(configurable) ? OptionsEditor.this.myContentWrapper : null)));
        }
    };
    private final LoadingDecorator myLoadingDecorator;
    private final SettingsFilter myFilter;
    private final Wrapper mySearchWrapper = new Wrapper();
    private final JPanel myLeftSide;
    private Window myWindow;
    private final PropertiesComponent myProperties;
    private volatile boolean myDisposed;
    final Settings mySettings;

    public OptionsEditor(Project project, ConfigurableGroup[] groups, Configurable preselectedConfigurable) {
        this.myProperties = PropertiesComponent.getInstance((Project)project);
        this.mySettings = new Settings(groups){

            @Override
            protected ActionCallback selectImpl(Configurable configurable) {
                return OptionsEditor.this.select(configurable, "");
            }
        };
        this.mySearch = new SettingsSearch(){

            @Override
            protected void onTextKeyEvent(KeyEvent e) {
                if (OptionsEditor.this.myTreeView != null) {
                    ((OptionsEditor)OptionsEditor.this).myTreeView.myTree.processKeyEvent(e);
                } else {
                    OptionsEditor.this.myTree.processTextEvent(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void delegateKeyEvent(KeyEvent event) {
                ((OptionsEditor)OptionsEditor.this).myFilter.myDocumentWasChanged = false;
                try {
                    super.delegateKeyEvent(event);
                }
                finally {
                    if (((OptionsEditor)OptionsEditor.this).myFilter.myDocumentWasChanged && !OptionsEditor.this.isFilterFieldVisible()) {
                        OptionsEditor.this.setFilterFieldVisible(true, false, false);
                    }
                }
            }
        };
        if (Registry.is((String)"ide.new.settings.dialog")) {
            this.mySearch.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
            this.mySearch.setBorder(new EmptyBorder(5, 10, 2, 10));
        }
        this.myFilter = new SettingsFilter(project, groups, this.mySearch){

            @Override
            Configurable getConfigurable(SimpleNode node) {
                if (node instanceof OptionsTree.EditorNode) {
                    return ((OptionsTree.EditorNode)node).getConfigurable();
                }
                return SettingsTreeView.getConfigurable(node);
            }

            @Override
            SimpleNode findNode(Configurable configurable) {
                return OptionsEditor.this.myTreeView != null ? OptionsEditor.this.myTreeView.findNode(configurable) : OptionsEditor.this.myTree.findNodeFor(configurable);
            }

            @Override
            void updateSpotlight(boolean now) {
                if (!now) {
                    OptionsEditor.this.mySpotlightPainter.updateLater();
                } else {
                    OptionsEditor.this.mySpotlightPainter.updateNow();
                }
            }
        };
        if (Registry.is((String)"ide.new.settings.dialog")) {
            this.myTreeView = new SettingsTreeView(this.myFilter, groups);
            this.myTreeView.myTree.addKeyListener((KeyListener)this.mySearch);
            this.myTree = null;
        } else {
            this.myTreeView = null;
            this.myTree = new OptionsTree(this.myFilter, groups);
            this.myTree.addKeyListener(this.mySearch);
        }
        this.getContext().addColleague((OptionsEditorColleague)((Object)(this.myTreeView != null ? this.myTreeView : this.myTree)));
        Disposer.register((Disposable)this, (Disposable)((Disposable)(this.myTreeView != null ? this.myTreeView : this.myTree)));
        this.myLeftSide = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                JComponent component = OptionsEditor.this.myTreeView != null ? OptionsEditor.this.myTreeView : OptionsEditor.this.myTree;
                dimension.width = Math.max(component.getMinimumSize().width, ((OptionsEditor)OptionsEditor.this).mySearchWrapper.getPreferredSize().width);
                return dimension;
            }
        };
        this.myLeftSide.add((Component)this.mySearchWrapper, "North");
        this.myLeftSide.add((Component)(this.myTreeView != null ? this.myTreeView : this.myTree), "Center");
        this.setLayout(new BorderLayout());
        this.myMainSplitter = Registry.is((String)"ide.new.settings.dialog") ? new OnePixelSplitter(false) : new Splitter(false);
        this.myMainSplitter.setFirstComponent((JComponent)this.myLeftSide);
        this.myLoadingDecorator = new LoadingDecorator(this.myOwnDetails.getComponent(), (Disposable)this, 150);
        this.myMainSplitter.setSecondComponent(this.myLoadingDecorator.getComponent());
        this.myMainSplitter.setProportion(this.readProportion(0.3f, MAIN_SPLITTER_PROPORTION));
        this.myContentWrapper.mySplitter.setProportion(this.readProportion(0.2f, DETAILS_SPLITTER_PROPORTION));
        this.add((Component)this.myMainSplitter, "Center");
        MyColleague colleague = new MyColleague();
        this.getContext().addColleague(colleague);
        if (preselectedConfigurable != null) {
            this.selectInTree(preselectedConfigurable);
        } else if (this.myTreeView != null) {
            this.myTreeView.selectFirst();
        } else {
            this.myTree.selectFirst();
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 56L);
        ActionManager.getInstance().addAnActionListener(new AnActionListener(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            }

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                OptionsEditor.this.queueModificationCheck();
            }

            public void beforeEditorTyping(char c, DataContext dataContext) {
            }
        }, (Disposable)this);
        this.myModificationChecker = new MergingUpdateQueue("OptionsModificationChecker", 1000, false, (JComponent)this, (Disposable)this, (JComponent)this);
        this.setFilterFieldVisible(true, false, false);
        new UiNotifyConnector.Once((Component)this, new Activatable(){

            public void showNotify() {
                OptionsEditor.this.myWindow = SwingUtilities.getWindowAncestor(OptionsEditor.this);
            }

            public void hideNotify() {
            }
        });
    }

    private ActionCallback selectInTree(Configurable configurable) {
        return this.myTreeView != null ? this.myTreeView.select(configurable) : this.myTree.select(configurable);
    }

    @Deprecated
    public ActionCallback select(Class<? extends Configurable> configurableClass) {
        Configurable configurable = this.findConfigurable(configurableClass);
        if (configurable == null) {
            return new ActionCallback.Rejected();
        }
        return this.select(configurable);
    }

    @Deprecated
    @Nullable
    public <T extends Configurable> T findConfigurable(Class<T> configurableClass) {
        return (T)(this.myTreeView != null ? (Configurable)this.myTreeView.findConfigurable(configurableClass) : this.myTree.findConfigurable(configurableClass));
    }

    @Nullable
    public SearchableConfigurable findConfigurableById(@NotNull String configurableId) {
        if (configurableId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableId", "com/intellij/openapi/options/newEditor/OptionsEditor", "findConfigurableById"));
        }
        return this.myTreeView != null ? this.myTreeView.findConfigurableById(configurableId) : this.myTree.findConfigurableById(configurableId);
    }

    public ActionCallback clearSearchAndSelect(Configurable configurable) {
        this.clearFilter();
        return this.select(configurable, "");
    }

    public ActionCallback select(Configurable configurable) {
        if (this.myFilter.getFilterText().isEmpty()) {
            return this.select(configurable, "");
        }
        return this.myFilter.update(true, true);
    }

    public ActionCallback select(Configurable configurable, String text) {
        this.myFilter.update(text, false, true);
        return this.selectInTree(configurable);
    }

    private float readProportion(float defaultValue, String propertyName) {
        float proportion = defaultValue;
        try {
            String p = this.myProperties.getValue(propertyName);
            if (p != null) {
                proportion = Float.valueOf(p).floatValue();
            }
        }
        catch (NumberFormatException e) {
            LOG.debug((Throwable)e);
        }
        return proportion;
    }

    private ActionCallback processSelected(final Configurable configurable, final Configurable oldConfigurable) {
        if (this.isShowing(configurable)) {
            return new ActionCallback.Done();
        }
        final ActionCallback result = new ActionCallback();
        if (configurable == null) {
            this.myOwnDetails.setContent(null);
            this.myFilter.updateSpotlight(true);
            this.checkModified(oldConfigurable);
            result.setDone();
        } else {
            this.getUiFor(configurable).doWhenDone((Runnable)new EdtRunnable(){

                public void runEdt() {
                    FilteringTreeBuilder builder;
                    if (OptionsEditor.this.myDisposed) {
                        return;
                    }
                    Configurable current = OptionsEditor.this.getContext().getCurrentConfigurable();
                    if (current != configurable) {
                        result.setRejected();
                        return;
                    }
                    OptionsEditor.this.myHistory.pushQueryPlace();
                    OptionsEditor.this.updateDetails();
                    OptionsEditor.this.myOwnDetails.setContent((JComponent)((Object)OptionsEditor.this.myContentWrapper));
                    OptionsEditor.this.myOwnDetails.setBannerMinHeight(OptionsEditor.this.mySearchWrapper.getHeight());
                    OptionsEditor.this.myOwnDetails.setText(OptionsEditor.this.getBannerText(configurable));
                    if (OptionsEditor.this.myTreeView != null) {
                        OptionsEditor.this.myOwnDetails.forProject(OptionsEditor.this.myTreeView.findConfigurableProject(configurable));
                    } else if (Registry.is((String)"ide.new.settings.dialog")) {
                        OptionsEditor.this.myOwnDetails.forProject(OptionsEditor.this.myTree.getConfigurableProject(configurable));
                    }
                    ConfigurableContent content = (ConfigurableContent)OptionsEditor.this.myConfigurable2Content.get(current);
                    content.setText(OptionsEditor.this.getBannerText(configurable));
                    content.setBannerActions(new Action[]{new ResetAction(configurable)});
                    content.updateBannerActions();
                    OptionsEditor.this.myLoadingDecorator.stopLoading();
                    OptionsEditor.this.myFilter.updateSpotlight(false);
                    OptionsEditor.this.checkModified(oldConfigurable);
                    OptionsEditor.this.checkModified(configurable);
                    FilteringTreeBuilder filteringTreeBuilder = builder = OptionsEditor.this.myTreeView != null ? ((OptionsEditor)OptionsEditor.this).myTreeView.myBuilder : ((OptionsEditor)OptionsEditor.this).myTree.myBuilder;
                    if (builder.getSelectedElements().size() == 0) {
                        OptionsEditor.this.select(configurable).notify(result);
                    } else {
                        result.setDone();
                    }
                }
            });
        }
        return result;
    }

    private static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private ActionCallback getUiFor(final Configurable configurable) {
        OptionsEditor.assertIsDispatchThread();
        if (this.myDisposed) {
            return new ActionCallback.Rejected();
        }
        final ActionCallback result = new ActionCallback();
        if (!this.myConfigurable2Content.containsKey(configurable)) {
            ActionCallback readyCallback = this.myConfigurable2LoadCallback.get(configurable);
            if (readyCallback != null) {
                return readyCallback;
            }
            this.myConfigurable2LoadCallback.put(configurable, result);
            this.myLoadingDecorator.startLoading(false);
            final Application app = ApplicationManager.getApplication();
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    app.runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            ((ApplicationEx)app).runEdtSafeAction(new Runnable(){

                                @Override
                                public void run() {
                                    if (((OptionsEditor)OptionsEditor.this).myFilter.myProject.isDisposed()) {
                                        result.setRejected();
                                    } else {
                                        OptionsEditor.this.initConfigurable(configurable).notifyWhenDone(result);
                                    }
                                }
                            });
                        }
                    });
                }
            };
            if (app.isUnitTestMode()) {
                action.run();
            } else {
                app.executeOnPooledThread(action);
            }
        } else {
            result.setDone();
        }
        return result;
    }

    private ActionCallback initConfigurable(final @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/openapi/options/newEditor/OptionsEditor", "initConfigurable"));
        }
        final ActionCallback result = new ActionCallback();
        final Simple content = new Simple(configurable);
        if (!this.myConfigurable2Content.containsKey(configurable)) {
            if (configurable instanceof Place.Navigator) {
                ((Place.Navigator)configurable).setHistory(this.myHistory);
            }
            configurable.reset();
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (OptionsEditor.this.myDisposed) {
                    return;
                }
                OptionsEditor.this.myConfigurable2Content.put(configurable, content);
                result.setDone();
            }
        });
        return result;
    }

    private String[] getBannerText(Configurable configurable) {
        if (this.myTreeView != null) {
            return this.myTreeView.getPathNames(configurable);
        }
        List<Configurable> list = this.myTree.getPathToRoot(configurable);
        String[] result = new String[list.size()];
        int add = 0;
        for (int i = list.size() - 1; i >= 0; --i) {
            result[add++] = list.get(i).getDisplayName().replace('\n', ' ');
        }
        return result;
    }

    private void checkModified(Configurable configurable) {
        this.fireModification(configurable);
    }

    private void fireModification(Configurable actual) {
        Collection<Configurable> toCheck = this.collectAllParentsAndSiblings(actual);
        for (Configurable configurable : toCheck) {
            this.fireModificationForItem(configurable);
        }
    }

    private Collection<Configurable> collectAllParentsAndSiblings(Configurable actual) {
        ArrayList<Configurable> result = new ArrayList<Configurable>();
        Configurable nearestParent = this.getContext().getParentConfigurable(actual);
        if (nearestParent != null) {
            Configurable parent = nearestParent;
            while (parent != null) {
                result.add(parent);
                parent = this.getContext().getParentConfigurable(parent);
            }
            result.addAll(this.getContext().getChildren(nearestParent));
        } else {
            result.add(actual);
        }
        return result;
    }

    private void fireModificationForItem(final Configurable configurable) {
        if (configurable != null) {
            if (!this.myConfigurable2Content.containsKey(configurable) && ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)configurable)) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                if (OptionsEditor.this.myDisposed) {
                                    return;
                                }
                                OptionsEditor.this.initConfigurable(configurable).doWhenDone(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (OptionsEditor.this.myDisposed) {
                                            return;
                                        }
                                        OptionsEditor.this.fireModificationInt(configurable);
                                    }
                                });
                            }
                        });
                    }
                });
            } else if (this.myConfigurable2Content.containsKey(configurable)) {
                this.fireModificationInt(configurable);
            }
        }
    }

    private void fireModificationInt(Configurable configurable) {
        if (configurable.isModified()) {
            this.getContext().fireModifiedAdded(configurable, null);
        } else if (!configurable.isModified() && !this.getContext().getErrors().containsKey(configurable)) {
            this.getContext().fireModifiedRemoved(configurable, null);
        }
    }

    private void updateDetails() {
        Configurable current = this.getContext().getCurrentConfigurable();
        assert (current != null);
        ConfigurableContent content = this.myConfigurable2Content.get(current);
        content.set(this.myContentWrapper);
    }

    private boolean isShowing(Configurable configurable) {
        ConfigurableContent content = this.myConfigurable2Content.get(configurable);
        return content != null && content.isShowing();
    }

    @Nullable
    public String getHelpTopic() {
        Configurable current = this.getContext().getCurrentConfigurable();
        while (current != null) {
            String topic = current.getHelpTopic();
            if (topic != null) {
                return topic;
            }
            current = this.getContext().getParentConfigurable(current);
        }
        return null;
    }

    public boolean isFilterFieldVisible() {
        return this.mySearch.getParent() == this.mySearchWrapper;
    }

    public void setFilterFieldVisible(boolean visible, boolean requestFocus, boolean checkFocus) {
        if (this.isFilterFieldVisible() && checkFocus && requestFocus && !this.isSearchFieldFocused()) {
            UIUtil.requestFocus((JComponent)((Object)this.mySearch));
            return;
        }
        this.mySearchWrapper.setContent((JComponent)((Object)(visible ? this.mySearch : null)));
        this.myLeftSide.revalidate();
        this.myLeftSide.repaint();
        if (visible && requestFocus) {
            UIUtil.requestFocus((JComponent)((Object)this.mySearch));
        }
    }

    public boolean isSearchFieldFocused() {
        return this.mySearch.getTextEditor().isFocusOwner();
    }

    public void reset(Configurable configurable, boolean notify) {
        configurable.reset();
        if (notify) {
            this.getContext().fireReset(configurable);
        }
    }

    public void apply() {
        LinkedHashMap<Configurable, ConfigurationException> errors = new LinkedHashMap<Configurable, ConfigurationException>();
        Set<Configurable> modified = this.getContext().getModified();
        for (Configurable each : modified) {
            try {
                each.apply();
                UsageTrigger.trigger("ide.settings." + ConvertUsagesUtil.escapeDescriptorName(each.getDisplayName()));
                if (each.isModified()) continue;
                this.getContext().fireModifiedRemoved(each, null);
            }
            catch (ConfigurationException e) {
                errors.put(each, e);
                LOG.debug((Throwable)e);
            }
        }
        this.getContext().fireErrorsChanged(errors, null);
        if (!errors.isEmpty()) {
            this.selectInTree((Configurable)errors.keySet().iterator().next());
        }
    }

    public Object getData(@NonNls String dataId) {
        if (Settings.KEY.is(dataId)) {
            return this.mySettings;
        }
        if (KEY.is(dataId)) {
            return this;
        }
        return History.KEY.is(dataId) ? this.myHistory : null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeView != null ? this.myTreeView.myTree : this.mySearch;
    }

    @Override
    public Dimension getPreferredSize() {
        return JBUI.size((int)1200, (int)768);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        final Configurable config = (Configurable)place.getPath("configurable");
        String filter = (String)place.getPath("filter");
        final ActionCallback result = new ActionCallback();
        this.myFilter.update(filter, false, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                OptionsEditor.this.selectInTree(config).notifyWhenDone(result);
            }
        });
        return result;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/options/newEditor/OptionsEditor", "queryPlace"));
        }
        Configurable current = this.getContext().getCurrentConfigurable();
        place.putPath("configurable", (Object)current);
        place.putPath("filter", (Object)this.myFilter.getFilterText());
        if (current instanceof Place.Navigator) {
            ((Place.Navigator)current).queryPlace(place);
        }
    }

    public void dispose() {
        OptionsEditor.assertIsDispatchThread();
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myProperties.setValue(MAIN_SPLITTER_PROPORTION, String.valueOf(this.myMainSplitter.getProportion()));
        this.myProperties.setValue(DETAILS_SPLITTER_PROPORTION, String.valueOf(this.myContentWrapper.myLastSplitterProportion));
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        HashSet<Configurable> configurables = new HashSet<Configurable>();
        configurables.addAll(this.myConfigurable2Content.keySet());
        configurables.addAll(this.myConfigurable2LoadCallback.keySet());
        for (final Configurable each : configurables) {
            ActionCallback loadCb = this.myConfigurable2LoadCallback.get(each);
            if (loadCb != null) {
                loadCb.doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        OptionsEditor.assertIsDispatchThread();
                        each.disposeUIResources();
                    }
                });
                continue;
            }
            each.disposeUIResources();
        }
        Disposer.clearOwnFields((Object)this);
    }

    public OptionsEditorContext getContext() {
        return this.myFilter.myContext;
    }

    public void flushModifications() {
        this.fireModification(this.getContext().getCurrentConfigurable());
    }

    public boolean canApply() {
        return !this.getContext().getModified().isEmpty();
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent ke;
        if (event.getID() == 501 || event.getID() == 502 || event.getID() == 506) {
            MouseEvent me = (MouseEvent)event;
            if (SwingUtilities.isDescendingFrom(me.getComponent(), SwingUtilities.getWindowAncestor((Component)((Object)this.myContentWrapper))) || this.isPopupOverEditor(me.getComponent())) {
                this.queueModificationCheck();
            }
        } else if ((event.getID() == 401 || event.getID() == 402) && SwingUtilities.isDescendingFrom((ke = (KeyEvent)event).getComponent(), (Component)((Object)this.myContentWrapper))) {
            this.queueModificationCheck();
        }
    }

    private void queueModificationCheck() {
        final Configurable configurable = this.getContext().getCurrentConfigurable();
        this.myModificationChecker.queue(new Update(this){

            public void run() {
                OptionsEditor.this.checkModified(configurable);
            }

            public boolean isExpired() {
                return OptionsEditor.this.getContext().getCurrentConfigurable() != configurable;
            }
        });
    }

    private boolean isPopupOverEditor(Component c) {
        Window wnd = SwingUtilities.getWindowAncestor(c);
        return (wnd instanceof JWindow || wnd instanceof JDialog && ((JDialog)wnd).getModalityType() == Dialog.ModalityType.MODELESS) && this.myWindow != null && wnd.getParent() == this.myWindow;
    }

    private JComponent createDefaultComponent(SearchableConfigurable searchable) {
        JPanel panel = new JPanel(new BorderLayout(0, 9));
        try {
            panel.add("North", new JLabel(OptionsEditor.getDefaultDescription(searchable)));
        }
        catch (AssertionError error) {
            return null;
        }
        if (searchable instanceof Configurable.Composite) {
            JPanel box = new JPanel();
            box.setLayout(new BoxLayout(box, 1));
            panel.add("Center", box);
            Configurable.Composite composite = (Configurable.Composite)searchable;
            for (final Configurable configurable : composite.getConfigurables()) {
                LinkLabel label = new LinkLabel(configurable.getDisplayName(), null){

                    public void doClick() {
                        OptionsEditor.this.select(configurable, null);
                    }
                };
                label.setBorder(BorderFactory.createEmptyBorder(1, 17, 3, 1));
                box.add((Component)label);
            }
        }
        return panel;
    }

    @NotNull
    private static String getDefaultDescription(SearchableConfigurable configurable) {
        String key = configurable.getId() + ".settings.description";
        if (configurable instanceof ConfigurableWrapper) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
            ConfigurableEP ep = wrapper.getExtensionPoint();
            ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)ep.bundle, (ClassLoader)ep.getPluginDescriptor().getPluginClassLoader());
            String string = CommonBundle.message((ResourceBundle)resourceBundle, (String)key, (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/OptionsEditor", "getDefaultDescription"));
            }
            return string;
        }
        String string = OptionsBundle.message((String)key, (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/OptionsEditor", "getDefaultDescription"));
        }
        return string;
    }

    public void clearFilter() {
        this.mySearch.setText("");
    }

    public void setHistory(History history) {
    }

    private class Details
    extends ConfigurableContent {
        MasterDetails myConfigurable;
        DetailsComponent myDetails;
        JComponent myMaster;
        JComponent myToolbar;

        Details(MasterDetails configurable) {
            this.myConfigurable = configurable;
            this.myConfigurable.initUi();
            this.myDetails = this.myConfigurable.getDetails();
            this.myMaster = this.myConfigurable.getMaster();
            this.myToolbar = this.myConfigurable.getToolbar();
        }

        @Override
        void set(ContentWrapper wrapper) {
            OptionsEditor.this.myOwnDetails.setDetailsModeEnabled(false);
            this.myDetails.setPrefix(OptionsEditor.this.getBannerText((Configurable)this.myConfigurable));
            wrapper.setContent(this.myMaster, this.myToolbar, this.myDetails, OptionsEditor.this.getContext().getErrors().get(this.myConfigurable));
        }

        @Override
        void setBannerActions(Action[] actions) {
            this.myDetails.setBannerActions(actions);
        }

        @Override
        boolean isShowing() {
            return this.myDetails.getComponent().isShowing();
        }

        @Override
        void updateBannerActions() {
            this.myDetails.updateBannerActions();
        }

        @Override
        void setText(String[] bannerText) {
            this.myDetails.update();
        }
    }

    private class Simple
    extends ConfigurableContent {
        JComponent myComponent;
        Configurable myConfigurable;

        Simple(Configurable configurable) {
            this.myConfigurable = configurable;
            this.myComponent = configurable.createComponent();
            if (this.myComponent == null && configurable instanceof SearchableConfigurable) {
                this.myComponent = OptionsEditor.this.createDefaultComponent((SearchableConfigurable)configurable);
            }
            if (this.myComponent != null) {
                Object clientProperty = this.myComponent.getClientProperty(OptionsEditor.NOT_A_NEW_COMPONENT);
                if (clientProperty != null && ApplicationManager.getApplication().isInternal()) {
                    LOG.warn("Settings component for " + configurable.getClass() + " must be created anew, not reused, in createComponent() and destroyed in disposeUIResources()");
                } else {
                    this.myComponent.putClientProperty(OptionsEditor.NOT_A_NEW_COMPONENT, Boolean.TRUE);
                }
            }
        }

        @Override
        void set(ContentWrapper wrapper) {
            OptionsEditor.this.myOwnDetails.setDetailsModeEnabled(true);
            boolean noScroll = ConfigurableWrapper.isNoScroll(this.myConfigurable) || ConfigurableWrapper.cast(MasterDetails.class, (UnnamedConfigurable)this.myConfigurable) != null;
            wrapper.setContent(this.myComponent, OptionsEditor.this.getContext().getErrors().get(this.myConfigurable), !noScroll);
        }

        @Override
        boolean isShowing() {
            return this.myComponent != null && this.myComponent.isShowing();
        }

        @Override
        void setBannerActions(Action[] actions) {
            OptionsEditor.this.myOwnDetails.setBannerActions(actions);
        }

        @Override
        void updateBannerActions() {
            OptionsEditor.this.myOwnDetails.updateBannerActions();
        }

        @Override
        void setText(String[] bannerText) {
            OptionsEditor.this.myOwnDetails.setText(bannerText);
        }
    }

    private static abstract class ConfigurableContent {
        private ConfigurableContent() {
        }

        abstract void set(ContentWrapper var1);

        abstract boolean isShowing();

        abstract void setBannerActions(Action[] var1);

        abstract void updateBannerActions();

        abstract void setText(String[] var1);
    }

    private class MyColleague
    extends OptionsEditorColleague.Adapter {
        private MyColleague() {
        }

        @Override
        public ActionCallback onSelected(Configurable configurable, Configurable oldConfigurable) {
            return OptionsEditor.this.processSelected(configurable, oldConfigurable);
        }

        @Override
        public ActionCallback onModifiedRemoved(Configurable configurable) {
            return this.updateIfCurrent(configurable);
        }

        @Override
        public ActionCallback onModifiedAdded(Configurable configurable) {
            return this.updateIfCurrent(configurable);
        }

        @Override
        public ActionCallback onErrorsChanged() {
            return this.updateIfCurrent(OptionsEditor.this.getContext().getCurrentConfigurable());
        }

        private ActionCallback updateIfCurrent(Configurable configurable) {
            if (OptionsEditor.this.getContext().getCurrentConfigurable() == configurable && configurable != null) {
                OptionsEditor.this.updateDetails();
                ConfigurableContent content = (ConfigurableContent)OptionsEditor.this.myConfigurable2Content.get(configurable);
                content.updateBannerActions();
                return new ActionCallback.Done();
            }
            return new ActionCallback.Rejected();
        }
    }

    private static class ContentWrapper
    extends NonOpaquePanel {
        private final JLabel myErrorLabel;
        private JComponent mySimpleContent;
        private ConfigurationException myException;
        private JComponent myMaster;
        private JComponent myToolbar;
        private DetailsComponent myDetails;
        private final Splitter mySplitter = new Splitter(false);
        private JPanel myLeft = new JPanel(new BorderLayout());
        public float myLastSplitterProportion;

        private ContentWrapper() {
            this.setLayout(new BorderLayout());
            this.myErrorLabel = new JLabel();
            this.myErrorLabel.setOpaque(true);
            this.myErrorLabel.setBackground(LightColors.RED);
            this.myLeft = new JPanel(new BorderLayout());
            this.mySplitter.addPropertyChangeListener("proportion", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ContentWrapper.this.myLastSplitterProportion = ((Float)evt.getNewValue()).floatValue();
                }
            });
        }

        void setContent(JComponent c, ConfigurationException e, boolean scrollable) {
            if (c != null && this.mySimpleContent == c && this.myException == e) {
                return;
            }
            this.removeAll();
            if (c != null) {
                if (scrollable) {
                    JScrollPane scroll = ScrollPaneFactory.createScrollPane(null, (boolean)true);
                    scroll.setViewport(new GradientViewport(c, 5, 5, 5, 5, false));
                    scroll.getVerticalScrollBar().setUnitIncrement(10);
                    this.add(scroll, "Center");
                } else {
                    this.add(c, "Center");
                }
            }
            if (e != null) {
                this.myErrorLabel.setText(UIUtil.toHtml((String)e.getMessage()));
                this.add(this.myErrorLabel, "North");
            }
            this.mySimpleContent = c;
            this.myException = e;
            this.myMaster = null;
            this.myToolbar = null;
            this.myDetails = null;
            this.mySplitter.setFirstComponent(null);
            this.mySplitter.setSecondComponent(null);
        }

        void setContent(JComponent master, JComponent toolbar, DetailsComponent details, ConfigurationException e) {
            if (this.myMaster == master && this.myToolbar == toolbar && this.myDetails == details && this.myException == e) {
                return;
            }
            this.myMaster = master;
            this.myToolbar = toolbar;
            this.myDetails = details;
            this.myException = e;
            this.removeAll();
            this.myLeft.removeAll();
            this.myLeft.add((Component)this.myToolbar, "North");
            this.myLeft.add((Component)this.myMaster, "Center");
            this.myDetails.setBannerMinHeight(this.myToolbar.getPreferredSize().height);
            this.mySplitter.setFirstComponent((JComponent)this.myLeft);
            this.mySplitter.setSecondComponent(this.myDetails.getComponent());
            this.mySplitter.setProportion(this.myLastSplitterProportion);
            this.add((Component)this.mySplitter, "Center");
            this.mySimpleContent = null;
        }

        public boolean isNull() {
            boolean superNull = super.isNull();
            if (superNull) {
                return superNull;
            }
            if (this.myMaster == null) {
                return NullableComponent.Check.isNull((Component)this.mySimpleContent);
            }
            return NullableComponent.Check.isNull((Component)this.myMaster);
        }
    }

    private class ResetAction
    extends AbstractAction {
        Configurable myConfigurable;

        ResetAction(Configurable configurable) {
            this.myConfigurable = configurable;
            this.putValue("Name", "Reset");
            this.putValue("ShortDescription", "Rollback changes for this configuration element");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsEditor.this.reset(this.myConfigurable, true);
            OptionsEditor.this.checkModified(this.myConfigurable);
        }

        @Override
        public boolean isEnabled() {
            return ((OptionsEditor)OptionsEditor.this).myFilter.myContext.isModified(this.myConfigurable) || OptionsEditor.this.getContext().getErrors().containsKey(this.myConfigurable);
        }
    }
}

